 
import { Navigation, Pagination } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react";

// import Swiper css
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";

const uniqueBrandData = [
  {
    id: 1,
    image: "assets/img/brand/brand-2-1.png",
    alt: "brand logo 1"
  },
  {
    id: 2,
    image: "assets/img/brand/brand-2-2.png",
    alt: "brand logo 2"
  },
  {
    id: 3,
    image: "assets/img/brand/brand-2-3.png",
    alt: "brand logo 3"
  },
  {
    id: 4,
    image: "assets/img/brand/brand-2-4.png",
    alt: "brand logo 4"
  },
  {
    id: 5,
    image: "assets/img/brand/brand-2-5.png",
    alt: "brand logo 5"
  },
  {
    id: 1,
    image: "assets/img/brand/brand-2-1.png",
    alt: "brand logo 1"
  },
  {
    id: 2,
    image: "assets/img/brand/brand-2-2.png",
    alt: "brand logo 2"
  },
  {
    id: 3,
    image: "assets/img/brand/brand-2-3.png",
    alt: "brand logo 3"
  },
  {
    id: 4,
    image: "assets/img/brand/brand-2-4.png",
    alt: "brand logo 4"
  },
  {
    id: 5,
    image: "assets/img/brand/brand-2-5.png",
    alt: "brand logo 5"
  }
];
 

export default function BrandHomeThree() {
  return (
    <div className="mtbrand__area mtbrand__3 pt-40 pb-130" data-bg-color="#0e1112" style={{ backgroundColor: `#0e1112` }}>
      <div className="container">
        <div className="row">
          <div className="mtbrand-wrapper pt-55">
            <Swiper
              slidesPerView={7}
              loop={true}
              speed={9000}
              pagination={{
                el: ".mtteam__pagination",
                clickable: true,
              }}
              navigation={{
                nextEl: ".mtteam__arrow-next",
                prevEl: ".mtteam__arrow-prev",
              }}
              modules={[Navigation, Pagination]}
              breakpoints={{
                1200: {
                  slidesPerView: 7,
                },
                992: {
                  slidesPerView: 3,
                },
                768: {
                  slidesPerView: 2,
                },
                575: {
                  slidesPerView: 2,
                },
                0: {
                  slidesPerView: 1,
                },
              }}
              className="swiper mt-brand-3-active">
              {uniqueBrandData.map((brand, i) => (
                <SwiperSlide className="swiper-slide" key={i}>
                  <div className="mtbrand__item">
                    <img src={brand.image} alt={brand.alt} />
                  </div>
                </SwiperSlide>
              ))}
            </Swiper>
          </div>
        </div>
      </div>
    </div>
  )
}
