 
import { Link } from "react-router-dom";
import { useEffect, useRef } from "react";


export default function HeroHomeThree() {
 
    const bgRef = useRef(null);
  
    useEffect(() => {
      import("jarallax").then(({ jarallax }) => {
       
        if (bgRef.current) {
          jarallax(bgRef.current, {
            speed: 0.4,
          });
        }
      });
    }, []);



  return (
    <section className="mthero__area mthero__3 pt-190 p-relative">
      <div className="mthero__3-trans mb-25 mt-7">
        <h1 className="mthero__3-trans-title wow img-custom-anim-left" data-wow-duration="1.5s" data-wow-delay="0.2s">
          Interior & Architecture</h1>
      </div>
      <div className="mthero__3-main-wrap mb-120">
        <div className="container p-relative">
          <div className="mthero__3-shape">
            <img src="assets/img/hero/shape-3-1.png" alt="" />
          </div>
          <div className="row">
            <div className="col-lg-7">
              <div className="mthero__wrap">
                <h2 className="mthero__title wow img-custom-anim-left" data-wow-duration="1.5s"
                  data-wow-delay="0.3s">Classic architecture <br />
                  is a timeless blend of <br />
                  elegance,</h2>
              </div>
            </div>
            <div className="col-lg-5">
              <div className="mthero__wrap-info ml-140">
                <p className="mb-28 wow img-custom-anim-right" data-wow-duration="1.5s" data-wow-delay="0.4s">Every
                  project we undertake is a testament to
                  dedication precision and unwavering commitment
                  to excellence. we specialize.</p>
                <div className="mtteam__btn pl-6 wow img-custom-anim-top" data-wow-duration="1.5s"
                  data-wow-delay="0.4s">
                  <Link to="/about">
                    <span className="mt-btn-black">Let’s Talk</span>
                    <span className="mt-btn-black mt-btn-icon rotate"><i
                      className="fa-solid fa-arrow-right"></i></span>
                  </Link>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className="mthero__3-thumb jarallax" ref={bgRef} style={{ backgroundImage: `url(/assets/img/hero/hero-bg-3.jpg)` }}></div>
    </section>
  )
}
