

import { Pagination } from "swiper/modules"
import { Swiper, SwiperSlide } from "swiper/react"

// import Swiper css
import "swiper/css"
import "swiper/css/pagination" 
import { Link } from "react-router-dom"
 

export default function PortfolioHomeThree() {
  return (
    <section id="mtproject__onepage" className="mtshowcase__area pt-120 pb-110 black-bg p-relative fix" data-bg-color="#0e1112" style={{ backgroundColor: `#0e1112` }}>
      <div className="container">
        <div className="mtshowcase__trans">
          <h2 className="mtshowcase__trans-title mt-upper">Our Portfolio</h2>
        </div>
        <div className="mtshowcase__main-wrap">
          <Swiper 
          slidesPerView={1.3}
          spaceBetween={40}
          loop={true}
          modules={[Pagination]}
          pagination={{
            el: ".swiper-pagination",
            clickable: true,
          }} 
          className="swiper mtshowcase__active mt-test-slider-space">

              <SwiperSlide className="swiper-slide">
                <div className="mtshowcase__wrapper ">
                  <div className="row align-items-center">
                    <div className="col-lg-4">
                      <div className="mtshowcase__content-wrap mb-30">
                        <div className="mtshowcase__content mb-50">
                          <span className="mb-10">Jan 06.2026</span>
                          <h3 className="mtshowcase__title"><Link to="/portfolio-details">Innovative <br />
                            UI/UX Design</Link></h3>
                        </div>
                        <div className="mtshowcase__btn-wrap">
                          <Link to="/portfolio-details">
                            <span className="mt-btn">view showcase</span>
                            <span className="mt-btn mt-btn-icon rotate"><i
                              className="fa-solid fa-arrow-right"></i></span>
                          </Link>
                        </div>
                      </div>
                    </div>
                    <div className="col-lg-8">
                      <div className="mtshowcase__thumb-wrap mb-30 wow img-custom-anim-top"
                        data-wow-duration="1.5s" data-wow-delay="0.2s">
                        <div className="mtshowcase__thumb br-10">
                          <img src="assets/img/project/project-3-1.jpg" alt="" />
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </SwiperSlide>
              <SwiperSlide className="swiper-slide">
                <div className="mtshowcase__wrapper ">
                  <div className="row align-items-center">
                    <div className="col-lg-4">
                      <div className="mtshowcase__content-wrap mb-30">
                        <div className="mtshowcase__content mb-50">
                          <span className="mb-10">Jan 06.2026</span>
                          <h3 className="mtshowcase__title"><Link to="/portfolio-details">Integrated
                            <br /> Interior Design</Link></h3>
                        </div>
                        <div className="mtshowcase__btn-wrap">
                          <Link to="/portfolio-details">
                            <span className="mt-btn">view showcase</span>
                            <span className="mt-btn mt-btn-icon rotate"><i
                              className="fa-solid fa-arrow-right"></i></span>
                          </Link>
                        </div>
                      </div>
                    </div>
                    <div className="col-lg-8">
                      <div className="mtshowcase__thumb-wrap mb-30 wow img-custom-anim-top"
                        data-wow-duration="1.5s" data-wow-delay="0.2s">
                        <div className="mtshowcase__thumb br-10">
                          <img src="assets/img/project/project-3-2.jpg" alt="" />
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </SwiperSlide>
              <SwiperSlide className="swiper-slide">
                <div className="mtshowcase__wrapper ">
                  <div className="row align-items-center">
                    <div className="col-lg-4">
                      <div className="mtshowcase__content-wrap mb-30">
                        <div className="mtshowcase__content mb-50">
                          <span className="mb-10">Jan 06.2026</span>
                          <h3 className="mtshowcase__title"><Link to="/portfolio-details">Innovative <br />
                            UI/UX Design</Link></h3>
                        </div>
                        <div className="mtshowcase__btn-wrap">
                          <Link to="/portfolio-details">
                            <span className="mt-btn">view showcase</span>
                            <span className="mt-btn mt-btn-icon rotate"><i
                              className="fa-solid fa-arrow-right"></i></span>
                          </Link>
                        </div>
                      </div>
                    </div>
                    <div className="col-lg-8">
                      <div className="mtshowcase__thumb-wrap mb-30 wow img-custom-anim-top"
                        data-wow-duration="1.5s" data-wow-delay="0.2s">
                        <div className="mtshowcase__thumb br-10">
                          <img src="assets/img/project/project-3-1.jpg" alt="" />
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </SwiperSlide>
 
          </Swiper>
        </div>
      </div>
    </section>
  )
}
