 
import { Link } from "react-router-dom";
import { Pagination } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react";
// import Swiper css
import "swiper/css";
import "swiper/css/pagination";

export default function ServiceHomeThree() {
  return (
    <section id="mtservice__onepage" className="mtservice__area mtservice__pagi-3 pt-120 pb-160 black-b p-relative" data-bg-color="#0B0E0F" style={{ backgroundColor: `#0B0E0F` }}>
      <div className="container p-relative">
        <div className="mt-section-wrapper mb-30">
          <div className="row">
            <div className="col-12">
              <div className="mt-section-content ml-110 mb-25">
                <h2 className="mt-section-title mtwhite mb-20">Classic Architecture, <br />
                  Modern Excellence</h2>
              </div>
            </div>
            <div className="col-lg-4">
              <div className="mt-section-content ml-110 mb-35">
                <h5 className="mt-section-subtitle mtwhite mb-20"><span></span>Services Us</h5>
              </div>
            </div>
            <div className="col-lg-8">
              <div className="mt-section-content ml-90 mb-35">
                <p className="mtwhite">Every project we undertake is a testament to <br />
                  dedication precision and unwavering commitment <br />
                  to excellence. we specialize in blending timeless <br />
                  architectural principles</p>
              </div>
            </div>
          </div>
        </div>
        <div className="row">
          <Swiper
            slidesPerView={3}
            spaceBetween={24}
            pagination={{
              el: ".mtservie-pagination",
              clickable: true,
            }}
            modules={[Pagination]}
            breakpoints={{
              1781: {
                slidesPerView: 3,
              },
              1199: {
                slidesPerView: 3,
              },
              991: {
                slidesPerView: 3,
              },
              767: {
                slidesPerView: 2,
              },
              550: {
                slidesPerView: 2,
              },
              0: {
                slidesPerView: 1,
              },
            }}
            className="swiper mtservice__active">
            <SwiperSlide className="swiper-slide">
              <div
                className="mtservice mtservice__3 mtservice__bg mtservice__border mb-30 wow img-custom-anim-top"
                data-wow-duration="1.5s" data-wow-delay="0.2s">
                <div className="mtservice__icon ">
                  <span><i className="fa-light fa-pen-paintbrush"></i></span>
                </div>
                <div className="mtservice__content">
                  <div className="mtservice__content-wrap">
                    <h3 className="mtservice__title mb-28"><Link to="/service-details">Concept Design</Link>
                    </h3>
                    <p className="mb-40">We believe that every project is an
                      opportunity to go beyond</p>
                  </div>
                  <div className="mtservice__btn-wrap">
                    <Link to="/service-details">
                      <span className="mt-btn">Read more</span>
                      <span className="mt-btn mt-btn-icon rotate"><i
                        className="fa-solid fa-arrow-right"></i></span>
                    </Link>
                  </div>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div
                className="mtservice mtservice__3 mtservice__bg mtservice__border mb-30 wow img-custom-anim-top"
                data-wow-duration="1.5s" data-wow-delay="0.2s">
                <div className="mtservice__icon ">
                  <span><i className="fa-light fa-floppy-disk-pen"></i></span>
                </div>
                <div className="mtservice__content">
                  <div className="mtservice__content-wrap">
                    <h3 className="mtservice__title mb-28"><Link to="/service-details">Landscape
                      Planning</Link></h3>
                    <p className="mb-40">We believe that every project is an
                      opportunity to go beyond</p>
                  </div>
                  <div className="mtservice__btn-wrap">
                    <Link to="/service-details">
                      <span className="mt-btn">Read more</span>
                      <span className="mt-btn mt-btn-icon rotate"><i
                        className="fa-solid fa-arrow-right"></i></span>
                    </Link>
                  </div>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div
                className="mtservice mtservice__3 mtservice__bg mtservice__border mb-30 wow img-custom-anim-top"
                data-wow-duration="1.5s" data-wow-delay="0.2s">
                <div className="mtservice__icon ">
                  <span><i className="fa-light fa-users"></i></span>
                </div>
                <div className="mtservice__content">
                  <div className="mtservice__content-wrap">
                    <h3 className="mtservice__title mb-28"><Link to="/service-details">Smart Building</Link>
                    </h3>
                    <p className="mb-40">We believe that every project is an
                      opportunity to go beyond</p>
                  </div>
                  <div className="mtservice__btn-wrap">
                    <Link to="/service-details">
                      <span className="mt-btn">Read more</span>
                      <span className="mt-btn mt-btn-icon rotate"><i
                        className="fa-solid fa-arrow-right"></i></span>
                    </Link>
                  </div>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div
                className="mtservice mtservice__3 mtservice__bg mtservice__border mb-30 wow img-custom-anim-top"
                data-wow-duration="1.5s" data-wow-delay="0.2s">
                <div className="mtservice__icon ">
                  <span><i className="fa-light fa-hammer-crash"></i></span>
                </div>
                <div className="mtservice__content">
                  <div className="mtservice__content-wrap">
                    <h3 className="mtservice__title mb-28"><Link to="/service-details">Luxury Design</Link>
                    </h3>
                    <p className="mb-40">We believe that every project is an
                      opportunity to go beyond</p>
                  </div>
                  <div className="mtservice__btn-wrap">
                    <Link to="/service-details">
                      <span className="mt-btn">Read more</span>
                      <span className="mt-btn mt-btn-icon rotate"><i
                        className="fa-solid fa-arrow-right"></i></span>
                    </Link>
                  </div>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div
                className="mtservice mtservice__3 mtservice__bg mtservice__border mb-30 wow img-custom-anim-top"
                data-wow-duration="1.5s" data-wow-delay="0.2s">
                <div className="mtservice__icon ">
                  <span><i className="fa-light fa-paint-roller"></i></span>
                </div>
                <div className="mtservice__content">
                  <div className="mtservice__content-wrap">
                    <h3 className="mtservice__title mb-28"><Link to="/service-details">Renovation</Link></h3>
                    <p className="mb-40">We believe that every project is an
                      opportunity to go beyond</p>
                  </div>
                  <div className="mtservice__btn-wrap">
                    <Link to="/service-details">
                      <span className="mt-btn">Read more</span>
                      <span className="mt-btn mt-btn-icon rotate"><i
                        className="fa-solid fa-arrow-right"></i></span>
                    </Link>
                  </div>
                </div>
              </div>
            </SwiperSlide>
          </Swiper>
          <div className="mtservice__pagi">
            <div className="mtservie-pagination"></div>
          </div>

        </div>
      </div>
    </section>
  )
}
