  
import { Link } from "react-router-dom";
import { Navigation } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react";

// import Swiper css
import "swiper/css"; 
import "swiper/css/navigation";


export default function TeamHomeThree() {
  return (
    <section id="mtteam__onepage" className="mtteam__area  pt-120 pb-120 p-palette fix" data-bg-color="#0b0e0f" style={{ backgroundColor: `#0b0e0f` }}>
      <div className="container">
        <div className="row align-items-center">
          <div className="col-lg-8">
            <div className="mt-section-content mb-60">
              <h2 className="mt-section-title mtwhite mb-20">Where Talent <br />
                Meets Innovation</h2>
              <h5 className="mt-section-subtitle mtwhite "><span></span>Our Team</h5>
            </div>
          </div>
          <div className="col-lg-4">
            <div className="mtblog__arrow z-index-4 mb-80">
              <div style={{cursor: 'pointer'}} className="mtteam__button-next mtblog__button">
                <span>
                  <svg xmlns="http://www.w3.org/2000/svg" width="23" height="14" viewBox="0 0 23 14"
                    fill="none">
                    <path
                      d="M12.4042 0C9.23442 2.80302 4.12106 5.44991 0 7.00078C4.12106 8.55061 9.23442 11.1965 12.4037 14L10.1942 7.80443L22.2084 7.80487C22.4184 7.8046 22.6197 7.71978 22.7681 7.56905C22.8788 7.45665 22.9542 7.31347 22.9848 7.15761C23.0153 7.00174 22.9996 6.84018 22.9397 6.69337C22.8797 6.54655 22.7782 6.42106 22.6479 6.33276C22.5177 6.24447 22.3645 6.19733 22.2078 6.1973L10.1941 6.1973L12.4042 0Z"
                      fill="#fff"></path>
                  </svg>
                </span>
              </div>
              <div style={{cursor: 'pointer'}} className="mtteam__button-prev mtblog__button">
                <span>
                  <svg xmlns="http://www.w3.org/2000/svg" width="23" height="14" viewBox="0 0 23 14"
                    fill="none">
                    <path
                      d="M10.5958 0C13.7656 2.80302 18.8789 5.44991 23 7.00078C18.8789 8.55061 13.7656 11.1965 10.5963 14L12.8058 7.80443L0.791596 7.80487C0.581603 7.8046 0.380306 7.71978 0.231934 7.56905C0.121174 7.45665 0.0457526 7.31347 0.0152059 7.15761C-0.0153409 7.00174 0.000354817 6.84018 0.0603161 6.69337C0.120277 6.54655 0.221807 6.42106 0.352071 6.33276C0.482334 6.24447 0.635485 6.19733 0.792157 6.1973L12.8059 6.1973L10.5958 0Z"
                      fill="#000"></path>
                  </svg>
                </span>
              </div>
            </div>
          </div>
        </div>
        <div className="mtteam__wrap mb-30">
          <Swiper
            slidesPerView={4.3}
            spaceBetween={24}
            loop={true}
            navigation={{
              nextEl: ".mtteam__button-next",
              prevEl: ".mtteam__button-prev",
            }}
            modules={[Navigation]}
            breakpoints={{
              1781: {
                slidesPerView: 4.5,
              },
              1199: {
                slidesPerView: 4,
              },
              991: {
                slidesPerView: 3,
              },
              767: {
                slidesPerView: 2,
              },
              550: {
                slidesPerView: 2,
              },
              0: {
                slidesPerView: 1,
              },
            }}
            className="swiper mtteam__active mt-team-slider-space">

            <SwiperSlide className="swiper-slide">
              <div className="mtteam mtteam__2 p-relative mb-24 wow img-custom-anim-top" data-wow-duration="1.5s"
                data-wow-delay="0.2s">
                <div className="mtteam__thumb text-center">
                  <div className="mtteam__social">
                    <a href="#"><i className="fa-brands fa-facebook-f"></i></a>
                    <a href="#"><i className="fa-brands fa-twitter"></i></a>
                    <a href="#"><i className="fa-brands fa-instagram"></i></a>
                    <a href="#"><i className="fa-brands fa-youtube"></i></a>
                  </div>
                  <img src="assets/img/team/team-3-1.jpg" alt="" />
                  <div className="mtteam__content ">
                    <span>Interior Design</span>
                    <h3 className="mtteam__title"><Link to="/team-details">Guy Hawkins</Link></h3>
                  </div>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="mtteam mtteam__2 p-relative mb-24 wow img-custom-anim-top" data-wow-duration="1.5s"
                data-wow-delay="0.2s">
                <div className="mtteam__thumb text-center">
                  <div className="mtteam__social">
                    <a href="#"><i className="fa-brands fa-facebook-f"></i></a>
                    <a href="#"><i className="fa-brands fa-twitter"></i></a>
                    <a href="#"><i className="fa-brands fa-instagram"></i></a>
                    <a href="#"><i className="fa-brands fa-youtube"></i></a>
                  </div>
                  <img src="assets/img/team/team-3-2.jpg" alt="" />
                  <div className="mtteam__content ">
                    <span>Interior Design</span>
                    <h3 className="mtteam__title"><Link to="/team-details">Guy John</Link></h3>
                  </div>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="mtteam mtteam__2 p-relative mb-24 wow img-custom-anim-top" data-wow-duration="1.5s"
                data-wow-delay="0.2s">
                <div className="mtteam__thumb text-center">
                  <div className="mtteam__social">
                    <a href="#"><i className="fa-brands fa-facebook-f"></i></a>
                    <a href="#"><i className="fa-brands fa-twitter"></i></a>
                    <a href="#"><i className="fa-brands fa-instagram"></i></a>
                    <a href="#"><i className="fa-brands fa-youtube"></i></a>
                  </div>
                  <img src="assets/img/team/team-3-3.jpg" alt="" />
                  <div className="mtteam__content ">
                    <span>Interior Design</span>
                    <h3 className="mtteam__title"><Link to="/team-details">MR Hawkins</Link></h3>
                  </div>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="mtteam mtteam__2 p-relative mb-24 wow img-custom-anim-top" data-wow-duration="1.5s"
                data-wow-delay="0.2s">
                <div className="mtteam__thumb text-center">
                  <div className="mtteam__social">
                    <a href="#"><i className="fa-brands fa-facebook-f"></i></a>
                    <a href="#"><i className="fa-brands fa-twitter"></i></a>
                    <a href="#"><i className="fa-brands fa-instagram"></i></a>
                    <a href="#"><i className="fa-brands fa-youtube"></i></a>
                  </div>
                  <img src="assets/img/team/team-3-4.jpg" alt="" />
                  <div className="mtteam__content ">
                    <span>Interior Design</span>
                    <h3 className="mtteam__title"><Link to="/team-details">John Mir</Link></h3>
                  </div>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="mtteam mtteam__2 p-relative mb-24 wow img-custom-anim-top" data-wow-duration="1.5s"
                data-wow-delay="0.2s">
                <div className="mtteam__thumb text-center">
                  <div className="mtteam__social">
                    <a href="#"><i className="fa-brands fa-facebook-f"></i></a>
                    <a href="#"><i className="fa-brands fa-twitter"></i></a>
                    <a href="#"><i className="fa-brands fa-instagram"></i></a>
                    <a href="#"><i className="fa-brands fa-youtube"></i></a>
                  </div>
                  <img src="assets/img/team/team-3-5.jpg" alt="" />
                  <div className="mtteam__content ">
                    <span>Interior Design</span>
                    <h3 className="mtteam__title"><Link to="/team-details">Khaled Mir</Link></h3>
                  </div>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="mtteam mtteam__2 p-relative mb-24 wow img-custom-anim-top" data-wow-duration="1.5s"
                data-wow-delay="0.2s">
                <div className="mtteam__thumb text-center">
                  <div className="mtteam__social">
                    <a href="#"><i className="fa-brands fa-facebook-f"></i></a>
                    <a href="#"><i className="fa-brands fa-twitter"></i></a>
                    <a href="#"><i className="fa-brands fa-instagram"></i></a>
                    <a href="#"><i className="fa-brands fa-youtube"></i></a>
                  </div>
                  <img src="assets/img/team/team-3-2.jpg" alt="" />
                  <div className="mtteam__content ">
                    <span>Interior Design</span>
                    <h3 className="mtteam__title"><Link to="/team-details">Guy Hawkins</Link></h3>
                  </div>
                </div>
              </div>
            </SwiperSlide>


          </Swiper>
        </div>
        <div className="mtteam__btn-wrap">
          <Link to="/team">
            <span className="mt-btn">Join Our Team</span>
            <span className="mt-btn mt-btn-icon rotate"><i className="fa-solid fa-arrow-right"></i></span>
          </Link>
        </div>
      </div>
    </section>
  )
}
