 
import { useEffect, useRef } from "react";
import { Navigation } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react";

// import Swiper css
import "swiper/css";
import "swiper/css/navigation";




export default function TestimonialHomeThree() {

  const bgRef = useRef(null);
  useEffect(() => {
    import("jarallax").then(({ jarallax }) => {

      if (bgRef.current) {
        jarallax(bgRef.current, {
          speed: 0.4,
        });
      }
    });
  }, []);



  return (
    <>
      <div className="pt-100 pb-120" data-bg-color="#0b0e0f" style={{ backgroundColor: `#0b0e0f` }}></div>
      <section className="mttestimonial__area mttestimonial__bg mttestimonial__3-bg pb-120 p-relative jarallax"
        data-background="" ref={bgRef} style={{ backgroundImage: `url(assets/img/testimonial/testimonial-bg-3.jpg)` }}>
        <div className="container-fluid">
          <div className="mttestimonial__wrapper">
            <div className="row justify-content-end">
              <div className="col-lg-7">
                <Swiper
                  slidesPerView={1}
                  loop={true}
                  navigation={{
                    nextEl: ".mttestimonial__button-next",
                    prevEl: ".mttestimonial__button-prev",
                  }}
                  modules={[Navigation]}
                  className="swiper mt-testimonial-active mttestimonial__3-space">


                  <SwiperSlide className="swiper-slide">
                    <div className="mttestimonial mttestimonial__3 fix">
                      <div className="mttestimonial__content-wrap mb-25 d-flex align-items-center">
                        <img className="mr-10" src="assets/img/testimonial/quate.png" alt="" />
                        <h3 className="mttestimonial__title">What Clients Say</h3>
                      </div>
                      <div className="mttestimonial__content">
                        <h4 className="mb-20"><span></span>Our Testimonial</h4>
                        <p className="mb-36">Our clients are at the heart of everything we do, and their
                          feedback <br />
                          testament to our dedication to excellence. Each project we undertake <br />
                          is a partnership built on open communication, trust, and a shared <br />
                          vision. From innovative designs to seamless execution,</p>
                      </div>
                      <div className="mttestimonial__author-wrap d-flex align-items-center">
                        <div className="mttestimonial__author-img mr-10">
                          <img src="assets/img/testimonial/author-1.png" alt="" />
                        </div>
                        <div className="mttestimonial__author-info">
                          <span className="mttestimonial__author-position">Construction</span>
                          <h3 className="mttestimonial__author-name mb-6">Brooklyn Simmons</h3>
                        </div>
                      </div>
                    </div>
                  </SwiperSlide>
                  <SwiperSlide className="swiper-slide">
                    <div className="mttestimonial mttestimonial__3 fix">
                      <div className="mttestimonial__content-wrap mb-25 d-flex align-items-center">
                        <img className="mr-10" src="assets/img/testimonial/quate.png" alt="" />
                        <h3 className="mttestimonial__title">What Clients Say</h3>
                      </div>
                      <div className="mttestimonial__content">
                        <h4 className="mb-20"><span></span>Our Testimonial</h4>
                        <p className="mb-36">Our clients are at the heart of everything we do, and their
                          feedback <br />
                          testament to our dedication to excellence. Each project we undertake <br />
                          is a partnership built on open communication, trust, and a shared <br />
                          vision. From innovative designs to seamless execution,</p>
                      </div>
                      <div className="mttestimonial__author-wrap d-flex align-items-center">
                        <div className="mttestimonial__author-img mr-10">
                          <img src="assets/img/testimonial/author-1.png" alt="" />
                        </div>
                        <div className="mttestimonial__author-info">
                          <span className="mttestimonial__author-position">Construction</span>
                          <h3 className="mttestimonial__author-name mb-6">Brooklyn Simmons</h3>
                        </div>
                      </div>
                    </div>
                  </SwiperSlide>


                  <div
                    className="mttestimonial__arrow mttestimonial__arrow-3 d-flex align-items-center justify-content- z-index-4">
                    <div style={{cursor: 'pointer'}} className="mttestimonial__button-next mttestimonial__button">
                      <span>
                        <svg xmlns="http://www.w3.org/2000/svg" width="23" height="14" viewBox="0 0 23 14"
                          fill="none">
                          <path
                            d="M12.4042 0C9.23442 2.80302 4.12106 5.44991 0 7.00078C4.12106 8.55061 9.23442 11.1965 12.4037 14L10.1942 7.80443L22.2084 7.80487C22.4184 7.8046 22.6197 7.71978 22.7681 7.56905C22.8788 7.45665 22.9542 7.31347 22.9848 7.15761C23.0153 7.00174 22.9996 6.84018 22.9397 6.69337C22.8797 6.54655 22.7782 6.42106 22.6479 6.33276C22.5177 6.24447 22.3645 6.19733 22.2078 6.1973L10.1941 6.1973L12.4042 0Z"
                            fill="#111" />
                        </svg>
                      </span>
                    </div>
                    <div style={{cursor: 'pointer'}} className="mttestimonial__button-prev mttestimonial__button mttestimonial__button-2">
                      <span>
                        <svg xmlns="http://www.w3.org/2000/svg" width="23" height="14" viewBox="0 0 23 14"
                          fill="none">
                          <path
                            d="M10.5958 0C13.7656 2.80302 18.8789 5.44991 23 7.00078C18.8789 8.55061 13.7656 11.1965 10.5963 14L12.8058 7.80443L0.791596 7.80487C0.581603 7.8046 0.380306 7.71978 0.231934 7.56905C0.121174 7.45665 0.0457526 7.31347 0.0152059 7.15761C-0.0153409 7.00174 0.000354817 6.84018 0.0603161 6.69337C0.120277 6.54655 0.221807 6.42106 0.352071 6.33276C0.482334 6.24447 0.635485 6.19733 0.792157 6.1973L12.8059 6.1973L10.5958 0Z"
                            fill="#fff" />
                        </svg>
                      </span>
                    </div>
                  </div>
                </Swiper>
              </div>
            </div>

          </div>
        </div>
      </section>
    </>
  )
}
