import { Link } from "react-router-dom";

export default function BlogHomeFour() {
  return (
    <section id="mtblog__onepage" className="mtblog__area mtblog__4 pt-120 pb-100 p-relative fix">
      <div className="container">
        <div className="row align-items-end mb-30">
          <div className="col-lg-8">
            <div className="mt-section-content mb-20">
              <h5 className="mt-section-subtitle mb-20"><span className="mtwhitebg"></span> Our latest Blog</h5>
              <h2 className="mt-section-title ">The Experts Behind <br />
                the Design.</h2>
            </div>
          </div>
          <div className="col-lg-4">
            <div className="mtteam__btn-wrap text-lg-end mb-20">
              <Link to="/blog">
                <span className="mt-btn mt-upper">See all Blog</span>
                <span className="mt-btn mt-btn-icon rotate"><i className="fa-solid fa-arrow-right"></i></span>
              </Link>
            </div>
          </div>
        </div>
        <div className="mtblog__main-wrapper">
          <div className="row">
            <div className="col-xl-4 col-lg-6 col-md-6">
              <div className="mtblog mb-30">
                <div className="mtblog__item mtblog__4">
                  <div className="mtblog__thumb p-relative mb-24 wow img-custom-anim-top" data-wow-duration="1.5s"
                    data-wow-delay="0.2s">
                    <Link to="/blog-details"><img src="assets/img/blog/blog-4-1.jpg" alt="" /></Link>
                  </div>
                  <div className="mtblog__content text-center mr-20 ml-20">
                    <div className="mtblog__meta mb-10">
                      <span><a href="#">Modern Interior</a></span>
                      <cite></cite>
                      <span><a href="#">02 march, 2026</a></span>
                    </div>
                    <h3 className="mtblog__title mb-25"><Link to="/blog-details">modern interior design,
                      innovative concepts,
                      and expert tips.</Link></h3>
                  </div>
                </div>
              </div>
            </div>
            <div className="col-xl-4 col-lg-6 col-md-6">
              <div className="mtblog mb-30">
                <div className="mtblog__item mtblog__4">
                  <div className="mtblog__thumb p-relative mb-24 wow img-custom-anim-top" data-wow-duration="1.5s"
                    data-wow-delay="0.3s">
                    <Link to="/blog-details"><img src="assets/img/blog/blog-4-2.jpg" alt="" /></Link>
                  </div>
                  <div className="mtblog__content text-center mr-20 ml-20">
                    <div className="mtblog__meta mb-10">
                      <span><a href="#">Modern Interior</a></span>
                      <cite></cite>
                      <span><a href="#">02 march, 2026</a></span>
                    </div>
                    <h3 className="mtblog__title mb-25"><Link to="/blog-details">Get inspired with expert
                      advice on modern
                      interiors, smart solutions,</Link></h3>
                  </div>
                </div>
              </div>
            </div>
            <div className="col-xl-4 col-lg-6 col-md-6">
              <div className="mtblog mb-30">
                <div className="mtblog__item mtblog__4">
                  <div className="mtblog__thumb p-relative mb-24 wow img-custom-anim-top" data-wow-duration="1.5s"
                    data-wow-delay="0.4s">
                    <Link to="/blog-details"><img src="assets/img/blog/blog-4-3.jpg" alt="" /></Link>
                  </div>
                  <div className="mtblog__content text-center mr-20 ml-20">
                    <div className="mtblog__meta mb-10">
                      <span><a href="#">Modern Interior</a></span>
                      <cite></cite>
                      <span><a href="#">02 march, 2026</a></span>
                    </div>
                    <h3 className="mtblog__title mb-25"><Link to="/blog-details">where every space tells a
                      story of
                      craftsmanship and creativity.</Link></h3>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
