 
import { Link } from "react-router-dom";
import { Navigation } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react";

//  import Swiper css
import "swiper/css";
import "swiper/css/navigation";


export default function ServiceHomeFour() {
  return (
    <section id="mtservice__onepage" className="mtservice__area  pt-60 pb-100 black-bg-2 fix ">
      <div className="container">
        <div className="row align-items-center">
          <Swiper
            slidesPerView={3}
            spaceBetween={24}
            loop={true}
            navigation={{
              nextEl: ".mtteam__button-next",
              prevEl: ".mtteam__button-prev",
            }}
            modules={[Navigation]}
            breakpoints={{
              1781: {
                slidesPerView: 3,
              },
              1199: {
                slidesPerView: 3,
              },
              991: {
                slidesPerView: 2,
              },
              767: {
                slidesPerView: 1,
              },
              550: {
                slidesPerView: 1,
              },
              0: {
                slidesPerView: 1,
              },
            }}
            className="swiper mtservice-active-3 mtservice-active-space">

            <SwiperSlide className="swiper-slide">
              <div className="mtservice mtservice__4 mtservice__bg mtservice__border mb-30">
                <div className="mtservice__icon">
                  <span><i className="fa-light fa-desktop"></i></span>
                </div>
                <div className="mtservice__content">
                  <div className="mtservice__content-wrap">
                    <h3 className="mtservice__title mb-28"><Link to="/service-details">Architectural &
                      Ambient
                      Lighting Design.</Link></h3>
                    <p className="mb-0">Every project we undertake testament
                      to dedication precision.</p>
                  </div>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="mtservice mtservice__4 mtservice__bg mtservice__border mb-30">
                <div className="mtservice__icon">
                  <span><i className="fa-light fa-booth-curtain"></i></span>
                </div>
                <div className="mtservice__content">
                  <div className="mtservice__content-wrap">
                    <h3 className="mtservice__title mb-28"><Link to="/service-details">3D Visualization &
                      <br />
                      Rendering</Link></h3>
                    <p className="mb-0">Every project we undertake testament
                      to dedication precision.</p>
                  </div>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="mtservice mtservice__4 mtservice__bg mtservice__border mb-30">
                <div className="mtservice__icon">
                  <span><i className="fa-light fa-floppy-disk-pen"></i></span>
                </div>
                <div className="mtservice__content">
                  <div className="mtservice__content-wrap">
                    <h3 className="mtservice__title mb-28"><Link to="/service-details">Material & Finish
                      <br />
                      Consultation</Link></h3>
                    <p className="mb-0">Every project we undertake testament
                      to dedication precision.</p>
                  </div>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="mtservice mtservice__4 mtservice__bg mtservice__border mb-30">
                <div className="mtservice__icon">
                  <span><i className="fa-light fa-pen-paintbrush"></i></span>
                </div>
                <div className="mtservice__content">
                  <div className="mtservice__content-wrap">
                    <h3 className="mtservice__title mb-28"><Link to="/service-details">On-Site Execution &
                      <br />
                      Supervision.</Link></h3>
                    <p className="mb-0">Every project we undertake testament
                      to dedication precision.</p>
                  </div>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="mtservice mtservice__4 mtservice__bg mtservice__border mb-30">
                <div className="mtservice__icon">
                  <span><i className="fa-light fa-floppy-disk-pen"></i></span>
                </div>
                <div className="mtservice__content">
                  <div className="mtservice__content-wrap">
                    <h3 className="mtservice__title mb-28"><Link to="/service-details">Material & Finish
                      <br />
                      Consultation</Link></h3>
                    <p className="mb-0">Every project we undertake testament
                      to dedication precision.</p>
                  </div>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="mtservice mtservice__4 mtservice__bg mtservice__border mb-30">
                <div className="mtservice__icon">
                  <span><i className="fa-light fa-booth-curtain"></i></span>
                </div>
                <div className="mtservice__content">
                  <div className="mtservice__content-wrap">
                    <h3 className="mtservice__title mb-28"><Link to="/service-details">3D Visualization &
                      <br />
                      Rendering</Link></h3>
                    <p className="mb-0">Every project we undertake testament
                      to dedication precision.</p>
                  </div>
                </div>
              </div>
            </SwiperSlide>


          </Swiper>
          <div className="mtservice__pagi">
            <div className="mtservie-pagination"></div>
          </div>

        </div>
      </div>
    </section>
  )
}
