import Count from "../../../common/count";

 

const counterData = [
  {
    id: 1,
    count: 10,
    suffix: "+",
    icon: "/assets/img/choose/icon-1.svg",
    title: "Years of",
    subtitle: "experience",
    duration: 1
  },
  {
    id: 2,
    count: 25,
    suffix: "k",
    icon: "/assets/img/choose/icon-2.svg",
    title: "Paid",
    subtitle: "customers",
    duration: 1
  },
  {
    id: 3,
    count: 99,
    suffix: "%",
    icon: "/assets/img/choose/icon-3.svg",
    title: "Client",
    subtitle: "satisfaction",
    duration: 1
  }
];


export default function ChooseHomeFive() {
  return (
    <section className="mtchoose__area black-bg-2 pt-70 pb-50 p-relative fix">
      <div className="mtchoose__thumb wow img-custom-anim-top" data-wow-duration="1.5s" data-wow-delay="0.2s">
        <img src="assets/img/choose/thumb-1.png" alt="" />
      </div>
      <div className="container">
        <div className="row justify-content-end">
          <div className="col-xl-7">
            <div className="mtchoose pl-60 mb-50">
              <div className="mt-section-content mb-50 ">
                <h2 className="mt-section-title mtwhite mb-30">Why you <br />
                  should choose</h2>
                <h5 className="mt-section-subtitle mtwhite"><span className=""></span>why choose Us</h5>
              </div>
              <div className="mtchoose__box-wrap d-flex align-items-center justify-content-between">
                <div className="mtchoose__box-info mr-30 mb-30 d-flex align-items-center ">
                  <div className="mtchoose__box-icon mr-20">
                    <span><i className="fa-regular fa-house"></i></span>
                  </div>
                  <h3 className="mtchoose__box-title">Attention to Detail</h3>
                </div>
                <div className="mtchoose__box-info mb-30 d-flex align-items-center">
                  <div className="mtchoose__box-icon mr-20">
                    <span><i className="fa-regular fa-house"></i></span>
                  </div>
                  <h3 className="mtchoose__box-title">Attention to Detail</h3>
                </div>
              </div>
              <div className="mtchoose__box-wrap d-flex align-items-center justify-content-between">
                <div className="mtchoose__box-info mr-30 mb-30 d-flex align-items-center ">
                  <div className="mtchoose__box-icon mr-20">
                    <span><i className="fa-regular fa-house"></i></span>
                  </div>
                  <h3 className="mtchoose__box-title">Attention to Detail</h3>
                </div>
                <div className="mtchoose__box-info mb-30 d-flex align-items-center">
                  <div className="mtchoose__box-icon mr-20">
                    <span><i className="fa-regular fa-house"></i></span>
                  </div>
                  <h3 className="mtchoose__box-title">Attention to Detail</h3>
                </div>
              </div>
            </div>
          </div>
          <div className="col-xl-10">
            <div className="row">
              {counterData.map((item, i) => (
                <div key={i} className="col-lg-4 col-md-6 mb-30">
                  <div className="mtfact__wrap text-center">
                    <div className="mtfact__item-2">
                      <h3 className="mtfact__count"><i className="purecounter" data-purecounter-duration="1"
                        data-purecounter-end="10">
                        <Count number={item.count} text={item.suffix} add_style={true} />
                      </i></h3>
                      <img src={item.icon} alt={item.title} />
                      <p>{item.title} <br /> {item.subtitle}</p>
                    </div>
                  </div>
                </div>
              )
              )}
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
