 

import { useState } from 'react';
import { Link } from "react-router-dom";

export default function ServiceHomeFive() {
  const [activeTab, setActiveTab] = useState('nav-profile');

  const handleTabClick = (tabId: string) => {
    setActiveTab(tabId);
  };

  const isTabActive = (tabId: string) => {
    return activeTab === tabId;
  };

  return (
    <div id="mtproject__onepage" className="mt-project-tab-area black-bg-2 pt-50 pb-60">
      <div className="container ">
        <div className="row align-items-center">
          <div className="col-lg-8">
            <div className="mt-section-content mb-50 ">
              <h2 className="mt-section-title mtwhite mb-30">Classic architecture
                services</h2>
              <h5 className="mt-section-subtitle mtwhite"><span className=""></span>Services Us</h5>
            </div>
          </div>
          <div className="col-lg-4">
            <div className="mtproject__btn mb-50 text-lg-end">
              <Link to="/services">
                <span className="mt-btn-black mtwhite">See All Services</span>
                <span className="mt-btn-black mtwhite mt-btn-icon rotate"><i
                  className="fa-solid fa-arrow-right"></i></span>
              </Link>
            </div>
          </div>
        </div>
        <div className="row">
          <div className="col-xl-4">
            <div className="mt-project-tab-wraper">
              <nav>
                <div className="mt-project-tab" id="nav-tab" role="tablist">
                  <button 
                    className={`nav-links ${isTabActive('nav-home') ? 'active' : ''}`} 
                    onClick={() => handleTabClick('nav-home')}
                    type="button" 
                    role="tab" 
                    aria-selected={isTabActive('nav-home')}
                  >
                    <span>01</span>Lighting
                  </button>
                  <button 
                    className={`nav-links ${isTabActive('nav-profile') ? 'active' : ''}`} 
                    onClick={() => handleTabClick('nav-profile')}
                    type="button" 
                    role="tab" 
                    aria-selected={isTabActive('nav-profile')}
                  >
                    <span>02</span>Décor
                  </button>
                  <button 
                    className={`nav-links ${isTabActive('nav-contact') ? 'active' : ''}`} 
                    onClick={() => handleTabClick('nav-contact')}
                    type="button" 
                    role="tab" 
                    aria-selected={isTabActive('nav-contact')}
                  >
                    <span>03</span>Integration
                  </button>
                  <button 
                    className={`nav-links ${isTabActive('nav-contact-1') ? 'active' : ''}`} 
                    onClick={() => handleTabClick('nav-contact-1')}
                    type="button" 
                    role="tab" 
                    aria-selected={isTabActive('nav-contact-1')}
                  >
                    <span>04</span>Execution
                  </button>
                </div>
              </nav>
            </div>
          </div>
          <div className="col-xl-8">
            <div className="mt-project-tab-content ">
              <div className="tab-content" id="nav-tabContent">
                 
                <div 
                  className={`tab-pane fade ${isTabActive('nav-home') ? 'show active' : ''}`} 
                  id="nav-home" 
                  role="tabpanel" 
                  aria-labelledby="nav-home-tab"
                  tabIndex={0}
                >
                  <div className="mt-project-tab-content-wrap d-flex align-items-center justify-content-between">
                    <div className="mt-project-tab-thumb mr-60 wow img-custom-anim-top" data-wow-duration="1.5s"
                      data-wow-delay="0.2s">
                      <a className="popup-image" href="assets/img/project/project-6-1.png"><img
                        src="assets/img/project/project-6-1.png" alt="" /></a>
                    </div>
                    <div className="mt-project-tab-content">
                      <img src="assets/img/project/shape-5.png" alt="" />
                      <p className="pb-15">that seamlessly blend modern aesthetics
                        with functional elegance. Our approach to
                        interior design driven innovation.</p>
                      <div className="mtteam__btn">
                        <Link to="/portfolio-details">
                          <span className="mt-btn-black mtwhite">Let&apos;s Talk</span> {' '}
                          <span className="mt-btn-black mt-btn-icon mtwhite rotate"><i
                            className="fa-solid fa-arrow-right"></i></span>
                        </Link>
                      </div>
                    </div>
                  </div>
                </div>
                
                {/* Tab 2 - Décor */}
                <div 
                  className={`tab-pane fade ${isTabActive('nav-profile') ? 'show active' : ''}`} 
                  id="nav-profile" 
                  role="tabpanel"
                  aria-labelledby="nav-profile-tab" 
                  tabIndex={0}
                >
                  <div className="mt-project-tab-content-wrap d-flex align-items-center justify-content-between">
                    <div className="mt-project-tab-thumb mr-60 wow img-custom-anim-top" data-wow-duration="1.5s"
                      data-wow-delay="0.2s">
                      <a className="popup-image" href="assets/img/project/project-6-1.png"><img
                        src="assets/img/project/project-6-1.png" alt="" /></a>
                    </div>
                    <div className="mt-project-tab-content">
                      <img src="assets/img/project/shape-5.png" alt="" />
                      <p className="pb-15">that seamlessly blend modern aesthetics
                        with functional elegance. Our approach to
                        interior design driven innovation.</p>
                      <div className="mtteam__btn">
                        <Link to="/portfolio-details">
                          <span className="mt-btn-black mtwhite">Let&apos;s Talk</span> {' '}
                          <span className="mt-btn-black mt-btn-icon mtwhite rotate"><i
                            className="fa-solid fa-arrow-right"></i></span>
                        </Link>
                      </div>
                    </div>
                  </div>
                </div>
                
                {/* Tab 3 - Integration */}
                <div 
                  className={`tab-pane fade ${isTabActive('nav-contact') ? 'show active' : ''}`} 
                  id="nav-contact" 
                  role="tabpanel" 
                  aria-labelledby="nav-contact-tab"
                  tabIndex={0}
                >
                  <div className="mt-project-tab-content-wrap d-flex align-items-center justify-content-between">
                    <div className="mt-project-tab-thumb mr-60 wow img-custom-anim-top" data-wow-duration="1.5s"
                      data-wow-delay="0.2s">
                      <a className="popup-image" href="assets/img/project/project-6-1.png"><img
                        src="assets/img/project/project-6-1.png" alt="" /></a>
                    </div>
                    <div className="mt-project-tab-content">
                      <img src="assets/img/project/shape-5.png" alt="" />
                      <p className="pb-15">that seamlessly blend modern aesthetics
                        with functional elegance. Our approach to
                        interior design driven innovation.</p>
                      <div className="mtteam__btn">
                        <Link to="/portfolio-details">
                          <span className="mt-btn-black mtwhite">Let&apos;s Talk</span> {' '}
                          <span className="mt-btn-black mt-btn-icon mtwhite rotate"><i
                            className="fa-solid fa-arrow-right"></i></span>
                        </Link>
                      </div>
                    </div>
                  </div>
                </div>
                
                {/* Tab 4 - Execution */}
                <div 
                  className={`tab-pane fade ${isTabActive('nav-contact-1') ? 'show active' : ''}`} 
                  id="nav-contact-1" 
                  role="tabpanel"
                  aria-labelledby="nav-contact-tab-1" 
                  tabIndex={0}
                >
                  <div className="mt-project-tab-content-wrap d-flex align-items-center justify-content-between">
                    <div className="mt-project-tab-thumb mr-60 wow img-custom-anim-top" data-wow-duration="1.5s"
                      data-wow-delay="0.2s">
                      <a className="popup-image" href="assets/img/project/project-6-1.png"><img
                        src="assets/img/project/project-6-1.png" alt="" /></a>
                    </div>
                    <div className="mt-project-tab-content">
                      <img src="assets/img/project/shape-5.png" alt="" />
                      <p className="pb-15">that seamlessly blend modern aesthetics
                        with functional elegance. Our approach to
                        interior design driven innovation.</p>
                      <div className="mtteam__btn">
                        <Link to="/portfolio-details">
                          <span className="mt-btn-black mtwhite">Let&apos;s Talk</span> {' '}
                          <span className="mt-btn-black mt-btn-icon mtwhite rotate"><i
                            className="fa-solid fa-arrow-right"></i></span>
                        </Link>
                      </div>
                    </div>
                  </div>
                </div>
                
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}