 
import { useState } from "react";

const faqData = [
  {
    id: "collapseOne",
    title: "Elegant Space Planning",
    content: "Google has said for years that the most important single factor to them is high quality content. Now more than ever, they have the ability.",
    isOpen: true
  },
  {
    id: "collapseTwo",
    title: "Premium Material Selection",
    content: "Google has said for years that the most important single factor to them is high quality content. Now more than ever, they have the ability.",
    isOpen: false
  },
  {
    id: "collapseThree",
    title: "Smart Lighting & Ambience",
    content: "Google has said for years that the most important single factor to them is high quality content. Now more than ever, they have the ability.",
    isOpen: false
  },
  {
    id: "collapseFour",
    title: "About Architecture agency",
    content: "Google has said for years that the most important single factor to them is high quality content. Now more than ever, they have the ability.",
    isOpen: false
  }
];


export default function PortfolioDetailsFaq() {

  const [faqItems, setFaqItems] = useState(faqData);

  const toggleFaq = (id: string) => {
    setFaqItems(prevItems =>
      prevItems.map(item => ({
        ...item,
        isOpen: item.id === id ? !item.isOpen : false
      }))
    );
  };


  return (
    <div className="accordion" id="accordionExampleOne">
      {faqItems.map((item) => (
        <div key={item.id} className="mt-accordion-item mb-20">
          <h2 className="accordion-header mb-6">
            <button
              className={`mt-accordion-button ${item.isOpen ? '' : 'collapsed'}`}
              type="button"
              onClick={() => toggleFaq(item.id)}
              aria-expanded={item.isOpen}
              aria-controls={item.id}
            >
              {item.title}
            </button>
          </h2>
          <div
            id={item.id}
            className={`mt-accordion-collapse collapse ${item.isOpen ? 'show' : ''}`}
            data-bs-parent="#accordionExampleOne"
          >
            <div className="mt-accordion-body pr-50">
              <p>{item.content}</p>
            </div>
          </div>
        </div>
      ))}
    </div>
  )
}
