 
import { useState } from 'react';

const faqData = [
  {
    id: "collapseOne",
    question: "Do you provide custom design solutions?",
    answer: "Every project we undertake is a testament to dedication precision and unwavering commitment to excellence. we specialize in blending. commitment to excellence we specialize in blending.",
    isOpen: true
  },
  {
    id: "collapseTwo", 
    question: "How long does a typical project take?",
    answer: "Every project we undertake is a testament to dedication precision and unwavering commitment to excellence. we specialize in blending. commitment to excellence we specialize in blending.",
    isOpen: false
  },
  {
    id: "collapseThree",
    question: "What is your pricing structure?",
    answer: "Every project we undertake is a testament to dedication precision and unwavering commitment to excellence. we specialize in blending. commitment to excellence we specialize in blending.",
    isOpen: false
  },
  {
    id: "collapseFour",
    question: "What materials do you use?",
    answer: "Every project we undertake is a testament to dedication precision and unwavering commitment to excellence. we specialize in blending. commitment to excellence we specialize in blending.",
    isOpen: false
  },
  {
    id: "collapseFive",
    question: "Do you offer eco-friendly options?",
    answer: "Every project we undertake is a testament to dedication precision and unwavering commitment to excellence. we specialize in blending. commitment to excellence we specialize in blending.",
    isOpen: false
  }
];


export default function PricingFaq() {
    const [faqs, setFaqs] = useState(faqData);
  
    const toggleFaq = (id: string) => {
      setFaqs(prevFaqs => 
        prevFaqs.map(faq => 
          faq.id === id 
            ? { ...faq, isOpen: !faq.isOpen }
            : { ...faq, isOpen: false }
        )
      );
    };
  
  return (
    <section className="mtfaq__area mtfaq__whtite pt-40 pb-110 p-relative">
      <div className="container">
        <div className="row align-items-center">
          <div className="col-lg-7">
            <div className="mt-section-content mb-50 mr-20">
              <h2 className="mt-section-title  mb-20">Frequently <br />
                Asked Questions</h2>
              <h5 className="mt-section-subtitle "><span className="mtwhitebg"></span>Our FAQ</h5>
            </div>
          </div>
          <div className="col-lg-5">
            <div className="mt-section-content mb-50 ml-130">
              <p className="">Every project we undertake is a testament to
                dedication precision and unwavering commitment
                to excellence. we specialize in blending.</p>
            </div>
          </div>
        </div>
        <div className="row justify-content-end">
          <div className="col-lg-6">
            <div className="mtfaq mtfaq__2">
              <div className="accordion" id="accordionExampleOne">
                {faqs.map((faq, index) => (
                  <div className="mt-accordion-item mb-20" key={index}>
                    <h2 className="accordion-header mb-6">
                      <button 
                        className={`mt-accordion-button ${faq.isOpen ? '' : 'collapsed'}`}
                        type="button"
                        onClick={() => toggleFaq(faq.id)}
                        aria-expanded={faq.isOpen}
                        aria-controls={faq.id}
                      >
                        {faq.question}
                      </button>
                    </h2>
                    <div 
                      id={faq.id} 
                      className={`mt-accordion-collapse collapse ${faq.isOpen ? 'show' : ''}`}
                      data-bs-parent="#accordionExampleOne"
                    >
                      <div className="mt-accordion-body pr-50">
                        <p>{faq.answer}</p>
                      </div>
                    </div>
                  </div>
                ))} 
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
