import { Link } from "react-router-dom";


export default function ServiceDetailsLocation() {
  return (
    <section className="mtservice__details-area pt-130 pb-110">
      <div className="container">
        <div className="mtservice__details-box-wrap mb-90">
          <div className="row">
            <div className="mt-section-content mb-40">
              <h2 className="mt-section-title details-border mb-20">Service overview</h2>
            </div>
            <div className="col-lg-6">
              <div className="mt-section-content mb-40 mr-50">
                <p className="mb-40">Branding design is the process of creating a unique identity that visually and
                  strategically represents a business. It includes logo design, color schemes, typography, and
                  brand messaging to ensure consistency across all platforms.</p>
                <p>Branding design is the visual and strategic identity of a business, shaping how it is
                  perceived
                  by customers. It includes elements like the logo, color palette, typography, imagery, and
                  messaging, all working together to create a strong and memorable brand presence.</p>
              </div>
            </div>
            <div className="col-lg-6">
              <div className="mtservice__details-box mr-100">
                <h4 className="mtservice__details-boxtitle mb-20">Our Approach to Branding</h4>
                <ul>
                  <li><i className="fa-regular fa-shield-check"></i> <strong>Bespoke Interior Design</strong> -
                    Customized designs tailored to your vision and lifestyle.</li>
                  <li><i className="fa-regular fa-shield-check"></i> <strong>Layout Optimization</strong> -
                    Maximizing functionality with smart layouts.</li>
                  <li><i className="fa-regular fa-shield-check"></i> <strong>3D Visualization</strong> -
                    Energy-efficient and environmentally responsible interiors.</li>
                  <li><i className="fa-regular fa-shield-check"></i> <strong>Automation Solutions</strong> -
                    Handpicked elements for a unique and cohesive look.</li>

                </ul>
              </div>
            </div>
          </div>
        </div>
        <div className="mtservice__details-item-wrap mt-40 mb-70">
          <div className="mt-section-content mb-40">
            <h2 className="mt-section-title mb-20">What we offer</h2>
          </div>
          <div className="row">
            <div className="col-xl-4 col-lg-6">
              <div className="mtservice__details-item  mb-30">
                <div className="mtservice__details-icon mb-20">
                  <span><i className="fa-light fa-pen-paintbrush"></i></span>
                </div>
                <div className="mtservice__details-content">
                  <h4 className=" mb-20"><Link to="/services">Concept Design</Link></h4>
                  <p className="mb-20">We believe that every project is an
                    opportunity to go beyond</p>

                  <ul>
                    <li>Bespoke Interior Design</li>
                    <li>Luxury & Contemporary Styling</li>
                    <li>Furniture & Decor Curation</li>
                  </ul>
                </div>
              </div>
            </div>
            <div className="col-xl-4 col-lg-6">
              <div className="mtservice__details-item  mb-30">
                <div className="mtservice__details-icon mb-20">
                  <span><i className="fa-light fa-pen-to-square"></i></span>
                </div>
                <div className="mtservice__details-content">
                  <h4 className=" mb-20"><Link to="/services">Concept Design</Link></h4>
                  <p className="mb-20">We believe that every project is an
                    opportunity to go beyond</p>

                  <ul>
                    <li>Bespoke Interior Design</li>
                    <li>Luxury & Contemporary Styling</li>
                    <li>Furniture & Decor Curation</li>
                  </ul>
                </div>
              </div>
            </div>
            <div className="col-xl-4 col-lg-6">
              <div className="mtservice__details-item  mb-30">
                <div className="mtservice__details-icon mb-20">
                  <span><i className="fa-light fa-paint-roller"></i></span>
                </div>
                <div className="mtservice__details-content">
                  <h4 className=" mb-20"><Link to="/services">Exterior Design</Link></h4>
                  <p className="mb-20">We believe that every project is an
                    opportunity to go beyond</p>

                  <ul>
                    <li>Bespoke Interior Design</li>
                    <li>Luxury & Contemporary Styling</li>
                    <li>Furniture & Decor Curation</li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div className="mtservice__details-gellary">
          <div className="row">
            <div className="col-lg-6">
              <div className="mtservice__details-thumb mb-20 wow img-custom-anim-top" data-wow-duration="1.5s"
                data-wow-delay="0.2s">
                <img src="assets/img/service/service-1.jpg" alt="" />
              </div>
            </div>
            <div className="col-lg-6">
              <div className="mtservice__details-thumb mb-20 wow img-custom-anim-top" data-wow-duration="1.5s"
                data-wow-delay="0.3s">
                <img src="assets/img/service/service-2.jpg" alt="" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
