import Count from "../../common/count";

 


const counterData = [
  { id: 1, number: "01", count: "K", value: 55, desc: "Product sale per day", duration: 1 },
  { id: 2, number: "02", count: "M+", value: 56, desc: "Total Product Downloaded", duration: 1 },
  { id: 3, number: "03", count: "K", value: 50, desc: "Tested by customers", duration: 1 },
  { id: 4, number: "04", count: "M+", value: 80, desc: "Tested by customers", duration: 1 }
];

interface CounterServiceProps {
  style_2?: boolean;
}

export default function CounterService({style_2}: CounterServiceProps) {
  return (
    <section className={`mtfact__area mtfact__white p-relative ${style_2 ? 'pt-60 pb-100' : 'pt-130 pb-50'}`}>
      <div className="container">
        <div className="row g-0">
          {counterData.map((item, i) => (
            <div key={i} className="col-xl-3 col-lg-6">
              <div className="mtfact mb-30">
                <div className="mtfact__item">
                  <h3 className="mtfact__count mb-150"><i className="purecounter" data-purecounter-duration="1"
                    data-purecounter-end="55">
                    <Count number={item.value} text={item.count} />
                  </i></h3>
                  <div className="mtfact__content d-flex justify-content-between">
                    <span className="mtfact__number mr-20">{item.number}</span>
                    <p>{item.desc.split(" ")[0]} <br />
                      {item.desc.split(" ").slice(1).join(" ")}</p>
                  </div>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
