

export default function TeamDetailsArea() {
  return (
    <section className="mt-team-details-area pt-130 pb-100 p-relative" data-bg-color="#F8F8F8" style={{ backgroundColor: `#F8F8F8` }}>
      <div className="mt-team-details-shape">
        <img src="assets/img/team/shape.png" alt="" />
      </div>
      <div className="container">
        <div className="mt-team-details-wrapper mb-80">
          <div className="row">
            <div className="col-lg-6">
              <div className="mt-team-details-thumb mb-30 mr-40 wow img-custom-anim-top" data-wow-duration="1.5s"
                data-wow-delay="0.3s">
                <img src="assets/img/team/team-details.jpg" alt="" />
              </div>
            </div>
            <div className="col-lg-6">
              <div className="mt-team-details-wrap mb-30">
                <div className="mt-section-content mb-10">
                  <h5 className="mt-section-subtitle mb-20">Illustrator <cite></cite></h5>
                  <h2 className="mt-section-title mb-20">Guy Hawking</h2>
                  <p className="mb-20">At Arsha our team is the heart of our creativity and innovation. We are a
                    group of passionate designers, architects, and project managers dedicated to transforming
                    spaces with precision, style, and functionality.</p>
                  <p>With years of experience in interior design, our experts bring a wealth of knowledge in
                    luxury interiors, modern aesthetics, and smart space solutions. From concept development
                    to final execution</p>
                </div>
                <div className="mt-team-details-box-wrap">
                  <div className="row align-items-center">
                    <div className="col-xl-6">
                      <div className="mt-team-details-box mb-30 d-flex align-items-center">
                        <div className="mt-team-details-box-icon mr-20">
                          <span><i className="fa-regular fa-user"></i></span>
                        </div>
                        <div className="mt-team-details-box-content">
                          <span>Experience</span>
                          <h4 className="mt-team-details-box-title">More Then 20+ Years</h4>
                        </div>
                      </div>
                    </div>
                    <div className="col-xl-6">
                      <div className="mt-team-details-box mb-30 d-flex align-items-center">
                        <div className="mt-team-details-box-icon mr-20">
                          <span><i className="fa-regular fa-phone"></i></span>
                        </div>
                        <div className="mt-team-details-box-content">
                          <span>Mobile</span>
                          <h4 className="mt-team-details-box-title"><a href="tel:+00239555-0108">+00 (239)
                            555-0108</a></h4>
                        </div>
                      </div>
                    </div>
                    <div className="col-xl-6">
                      <div className="mt-team-details-box mb-30 d-flex align-items-center">
                        <div className="mt-team-details-box-icon mr-20">
                          <span><i className="fa-regular fa-location-dot"></i></span>
                        </div>
                        <div className="mt-team-details-box-content">
                          <span>Address</span>
                          <h4 className="mt-team-details-box-title">4517 Washington Ave.</h4>
                        </div>
                      </div>
                    </div>
                    <div className="col-xl-6">
                      <div className="mt-team-details-box mb-30 d-flex align-items-center">
                        <div className="mt-team-details-box-icon mr-20">
                          <span><i className="fa-regular fa-envelope"></i></span>
                        </div>
                        <div className="mt-team-details-box-content">
                          <span>Gmail</span>
                          <h4 className="mt-team-details-box-title"><a
                            href="mailto:A.laxfy@gmail.com">A.laxfy@gmail.com</a></h4>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="mt-team-details-btn-wrap d-flex align-items-center">
                  <div className="mt-team-details-follow mr-20">
                    <p>Follow:</p>
                  </div>
                  <div className="mt-team-details-social">
                    <a href="#"><i className="fab fa-facebook-f"></i></a>
                    <a href="#"><i className="fab fa-twitter"></i></a>
                    <a href="#"><i className="fab fa-instagram"></i></a>
                    <a href="#"><i className="fab fa-linkedin-in"></i></a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div className="mt-team-details-skill">
          <div className="row">
            <div className="col-lg-6">
              <div className="mt-section-content mb-50 mr-90">
                <h2 className="mt-section-title mt-fs-40 mb-20">Early Years</h2>
                <p className="mb-40">He is a services industry veteran with a diversified wealth of expertise that
                  includes worldwide operations, delivery, process improvements, mergers and acquisitions, and
                  integration, as well as sales and business.</p>
                <p>He is a services industry veteran with a diversified wealth of expertise that includes
                  worldwide operations, delivery, process improvements, mergers and acquisitions, and
                  integration, as well as sales and business.</p>
              </div>
            </div>
            <div className="col-lg-6">
              <div className="mtskill">
                <div className="mt-section-content mb-40">
                  <h2 className="mt-section-title mt-fs-40 mb-20">Arsha experience</h2>
                  <p>If you are going to use a passage of Lorem Ipsum, you need to be all while developing a
                    culture that fosters engaged sure</p>
                </div>
                <div className="mtskill__item mb-30">
                  <h6>Integrity & Transparency</h6>
                  <span className="progress-count" style={{ left: `calc(90% - 15px)` }}>90%</span>
                  <div className="fix">
                    <div className="progress">
                      <div className="progress-bar" role="progressbar" data-width="90%" aria-valuenow={25}
                        aria-valuemin={0} aria-valuemax={100}
                        style={{ width: `90%`, visibility: `visible`, animationDuration: `1s`, animationDelay: `0.3s`, animationName: `slideInLeft` }}>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="mtskill__item mb-30">
                  <h6>Quality & Excellence</h6>
                  <span className="progress-count" style={{ left: `calc(85% - 15px)` }}>85%</span>
                  <div className="fix">
                    <div className="progress">
                      <div className="progress-bar" role="progressbar" data-width="85%" aria-valuenow={25}
                        aria-valuemin={0} aria-valuemax={100}
                        style={{ width: `85%`, visibility: `visible`, animationDuration: `1s`, animationDelay: `0.3s`, animationName: `slideInLeft` }}>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="mtskill__item mb-30">
                  <h6>Client-Centric Approach</h6>
                  <span className="progress-count" style={{ left: `calc(95% - 15px)` }}>95%</span>
                  <div className="fix">
                    <div className="progress">
                      <div className="progress-bar" role="progressbar" data-width="95%" aria-valuenow={25}
                        aria-valuemin={0} aria-valuemax={100}
                        style={{ width: `95%`, visibility: `visible`, animationDuration: `1s`, animationDelay: `0.3s`, animationName: `slideInLeft` }}>
                      </div>
                    </div>
                  </div>
                </div>

              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
