
import { Swiper, SwiperSlide } from "swiper/react"
import { Autoplay } from "swiper/modules"

// swiper styles
import "swiper/css"
import "swiper/css/navigation"

export default function TestimonialArea() {
  return (
    <section className="mttestimonial__area mttestimonial__bg-4 pt-130 pb-130 p-relative jarallax"
      style={{backgroundImage: `url(/assets/img/testimonial/testimonial-bg-4.jpg)`}}>
      <div className="container">
        <div className="mttestimonial__wrapper mttestimonial__border pb-160">
          <Swiper
            slidesPerView={3}
            spaceBetween={25}
            loop={true}
            navigation={{
              nextEl: ".mttestimonial__arrow-next",
              prevEl: ".mttestimonial__arrow-prev",
            }}

            breakpoints={{
              1200: {
                slidesPerView: 3,
              },
              992: {
                slidesPerView: 2,
              },
              768: {
                slidesPerView: 2,
              },
              0: {
                slidesPerView: 1,
              },
            }}
            className="swiper mt-testimonial-4-active">

            <SwiperSlide className="swiper-slide">
              <div className="mttestimonial mttestimonial__4 text-center">
                <div className="mttestimonial__author-wrap mb-15">
                  <img src="assets/img/testimonial/author-1.png" alt="" />
                </div>
                <p className="mb-20">"Working with interon was an absolute pleasure! Their attention to detail
                  and innovative designs completely transformed our space.be happier!"</p>
                <div className="mttestimonial__author-wrap">
                  <h3 className="mttestimonial__author-name mb-6 mt-10 mb-0">Brooklyn Simmons</h3>
                  <span className="mttestimonial__author-position">Construction</span>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="mttestimonial mttestimonial__4 text-center">
                <div className="mttestimonial__author-wrap mb-15">
                  <img src="assets/img/testimonial/author-1.png" alt="" />
                </div>
                <p className="mb-20">"Working with interon was an absolute pleasure! Their attention to detail
                  and innovative designs completely transformed our space.be happier!"</p>
                <div className="mttestimonial__author-wrap">
                  <h3 className="mttestimonial__author-name mb-6 mt-10 mb-0">Brooklyn Simmons</h3>
                  <span className="mttestimonial__author-position">Construction</span>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="mttestimonial mttestimonial__4 text-center">
                <div className="mttestimonial__author-wrap mb-15">
                  <img src="assets/img/testimonial/author-1.png" alt="" />
                </div>
                <p className="mb-20">"Working with interon was an absolute pleasure! Their attention to detail
                  and innovative designs completely transformed our space.be happier!"</p>
                <div className="mttestimonial__author-wrap">
                  <h3 className="mttestimonial__author-name mb-6 mt-10 mb-0">Brooklyn Simmons</h3>
                  <span className="mttestimonial__author-position">Construction</span>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="mttestimonial mttestimonial__4 text-center">
                <div className="mttestimonial__author-wrap mb-15">
                  <img src="assets/img/testimonial/author-1.png" alt="" />
                </div>
                <p className="mb-20">"Working with interon was an absolute pleasure! Their attention to detail
                  and innovative designs completely transformed our space.be happier!"</p>
                <div className="mttestimonial__author-wrap">
                  <h3 className="mttestimonial__author-name mb-6 mt-10 mb-0">Brooklyn Simmons</h3>
                  <span className="mttestimonial__author-position">Construction</span>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="mttestimonial mttestimonial__4 text-center">
                <div className="mttestimonial__author-wrap mb-15">
                  <img src="assets/img/testimonial/author-1.png" alt="" />
                </div>
                <p className="mb-20">"Working with interon was an absolute pleasure! Their attention to detail
                  and innovative designs completely transformed our space.be happier!"</p>
                <div className="mttestimonial__author-wrap">
                  <h3 className="mttestimonial__author-name mb-6 mt-10 mb-0">Brooklyn Simmons</h3>
                  <span className="mttestimonial__author-position">Construction</span>
                </div>
              </div>
            </SwiperSlide>


          </Swiper>
        </div>
        <div className="mtbrand-wrapper pt-55">
          <Swiper
            modules={[Autoplay]}
            autoplay={{ delay: 0, disableOnInteraction: false }}
            speed={4000}
            loop={true}
            slidesPerView={7}
            spaceBetween={30}            
            breakpoints={{
              1200: {
                slidesPerView: 7,
              },
              992: {
                slidesPerView: 5,
              },
              768: {
                slidesPerView: 4,
              },
              575: {
                slidesPerView: 3,
              },
              0: {
                slidesPerView: 3,
              },
            }}
            className="mt-brand-2-active"
          >
            {[
              "brand-1-1.png",
              "brand-1-2.png",
              "brand-1-3.png",
              "brand-1-4.png",
              "brand-1-5.png",
              "brand-1-6.png",
              "brand-1-7.png",
              "brand-1-1.png",
              "brand-1-2.png",
              "brand-1-3.png",
            ].map((img, i) => (
              <SwiperSlide key={i}>
                <div className="mtbrand__item">
                  <img src={`/assets/img/brand/${img}`} alt="brand" />
                </div>
              </SwiperSlide>
            ))}
          </Swiper>
        </div>
      </div>
    </section>
  )
}
