
type SubMenuItem = {
  id: number;
  image: string;
  title: string;
  onePageLink: string;
  path: string;
};


type MenuItem = {
  id: number;
  title: string;
  path: string;
  type: "dropdown" | "link";
  has_dropdown: boolean;
  sub_menus?: SubMenuItem[]; 
};

type MenuData = MenuItem[];


const menu_data_two:MenuData = [
  {
    id: 1,
    title: "HOME",
    path: "#",
    type: "dropdown",
    has_dropdown: true,
    sub_menus: [
      {
        id: 1,
        image: "/assets/img/demo/home-1.jpg",
        title: "Home 01", 
        onePageLink: "/home-one-page",
        path: "/"
      },
      {
        id: 2,
        image: "/assets/img/demo/home-2.jpg",
        title: "Home 02", 
        onePageLink: "/home-2-one-page",
        path: "/home-2"
      },
      {
        id: 3,
        image: "/assets/img/demo/home-3.jpg",
        title: "Home 03", 
        onePageLink: "/home-3-one-page",
        path: "/home-3"
      },
      {
        id: 4,
        image: "/assets/img/demo/home-4.jpg",
        title: "Home 04", 
        onePageLink: "/home-4-one-page",
        path: "/home-4"
      },
      {
        id: 5,
        image: "/assets/img/demo/home-5.jpg",
        title: "Home 05", 
        onePageLink: "/home-5-one-page",
        path: "/home-5"
      }
    ]
  },
  {
    id: 2,
    title: "ABOUT",
    path: "#mtabout__onepage",
    type: "link",
    has_dropdown: false,
  },
  {
    id: 3,
    title: "SERVICES",
    path: "#mtservice__onepage",
    type: "link",
    has_dropdown: false,
  },
  {
    id: 4,
    title: "PORTFOLIO",
    path: "#mtproject__onepage",
    type: "link",
    has_dropdown: false,
  },
  {
    id: 5,
    title: "TEAM",
    path: "#mtteam__onepage",
    type: "link",
    has_dropdown: false,
  },
  {
    id: 6,
    title: "BLOG",
    path: "#mtblog__onepage",
    type: "link",
    has_dropdown: false,
  }
];

export default menu_data_two