 
type MenuLink = {
  label: string;
  path: string;
};

type SubMenuItem = {
  img?: string;
  title: string;
  path: string;
  links?: MenuLink[];
};

type MenuItem = {
  title: string;
  has_dropdown: boolean;
  path: string;
  sub_menus?: SubMenuItem[];
};

type MenuData = MenuItem[];



const menu_data: MenuData = [
  {
    title: "HOME",
    has_dropdown: true,
    path: "#",
    sub_menus: [
      {
        img: "assets/img/demo/home-1.jpg",
        title: "Home 01",
        path: "/",
        links: [
          { label: "Multi page", path: "/" },
          { label: "One Page", path: "/home-one-page" },
        ],
      },
      {
        img: "assets/img/demo/home-2.jpg",
        title: "Home 02",
        path: "/home-2",
        links: [
          { label: "Multi page", path: "/home-2" },
          { label: "One Page", path: "/home-2-one-page" },
        ],
      },
      {
        img: "assets/img/demo/home-3.jpg",
        title: "Home 03",
        path: "/home-3",
        links: [
          { label: "Multi page", path: "/home-3" },
          { label: "One Page", path: "/home-3-one-page" },
        ],
      },
      {
        img: "assets/img/demo/home-4.jpg",
        title: "Home 04",
        path: "/home-4",
        links: [
          { label: "Multi page", path: "/home-4" },
          { label: "One Page", path: "/home-4-one-page" },
        ],
      },
      {
        img: "assets/img/demo/home-5.jpg",
        title: "Home 05",
        path: "/home-5",
        links: [
          { label: "Multi page", path: "/home-5" },
          { label: "One Page", path: "/home-5-one-page" },
        ],
      },
    ],
  },
  { title: "ABOUT", has_dropdown: false, path: "/about" },
  {
    title: "SERVICES",
    has_dropdown: true,
    path: "#",
    sub_menus: [
      { title: "SERVICES", path: "/services" },
      { title: "SERVICES DETAILS", path: "/service-details" },
    ],
  },
  {
    title: "PAGES",
    has_dropdown: true,
    path: "#",
    sub_menus: [
      { title: "ABOUT", path: "/about" },
      { title: "SERVICE", path: "/services" },
      { title: "SERVICE DETAILS", path: "/service-details" },
      { title: "PORTFOLIO", path: "/portfolio" },
      { title: "PORTFOLIO DETAILS", path: "/portfolio-details" },
      { title: "OUR PRICEING", path: "/pricing" },
      { title: "TESTIMONIAL", path: "/testimonial" },
      { title: "OUR FAQ", path: "/faq" },
      { title: "OUR TEAM", path: "/team" },
      { title: "TEAM DETAILS", path: "/team-details" },
      { title: "ERROR 404", path: "/error-404" },
      { title: "CONTACT", path: "/contact" },
    ],
  },
  {
    title: "BLOG",
    has_dropdown: true,
    path: "#",
    sub_menus: [
      { title: "BLOG", path: "/blog" },
      { title: "BLOG GRID", path: "/blog-grid" },
      { title: "BLOG LIST", path: "/blog-list" },
      { title: "BLOG DETAILS", path: "/blog-details" },
      { title: "BLOG DETAILS 2", path: "/blog-details-no-sidebar" },
    ],
  },
  { title: "CONTACT", has_dropdown: false, path: "/contact" },
];

export default menu_data;