
import { useEffect, useState } from 'react';

interface StickyState {
  sticky: boolean;
}

const UseSticky = (): StickyState => {
  const [sticky, setSticky] = useState(false);

  useEffect(() => {
    let ticking = false;

    const handleScroll = (): void => {
      const scrollY = window.pageYOffset || document.documentElement.scrollTop || 0;
      setSticky(scrollY > 80);
    };

    const onScroll = () => {
      if (!ticking) {
        window.requestAnimationFrame(handleScroll);
        ticking = true;
        setTimeout(() => {
          ticking = false;
        }, 16); // ~60fps
      }
    };

    window.addEventListener('scroll', onScroll, { passive: true });
    return () => window.removeEventListener('scroll', onScroll);
  }, []);

  return { sticky };
};

export default UseSticky;