import { Link } from "react-router-dom";


export default function FooterFive() {
  return (
    <footer className="mt-footer-area mt-footer-5 p-relative black-bg-2 " data-bg-color="#131313" style={{ backgroundColor: `#131313` }}>
      <div className="container">
        <div className="mt-footer-main-wrapper pt-70 mb-45">
          <div className="row">
            <div className="col-lg-3">
              <div className="mt-footer-widget footer-cols-1 mb-50">
                <div className="mt-footer-logo">
                  <Link to="/"><img src="assets/img/logo/white-logo.png" alt="" /></Link>
                </div>
              </div>
            </div>
            <div className="col-lg-3">
              <div className="mt-footer-widget footer-cols-2 mb-50">
                <h2 className="mt-footer-title mb-20">Find us </h2>
                <div className="mt-footer-content">
                  <p className="mb-30">4517 Washington Ave. Manchester,
                    Kentucky 39495</p>

                </div>
                <h2 className="mt-footer-title mb-20">Get in touch</h2>
                <div className="mt-footer-content">
                  <span className="d-block mb-9"><a href="tel:1525545862155">+123 456 856</a></span>
                  <span className="d-block"><a href="mailto:Admin@gmail.com">Admin@gmail.com</a></span>
                </div>
              </div>
            </div>
            <div className="col-lg-3">
              <div className="mt-footer-widget footer-cols-3 mb-50">
                <h2 className="mt-footer-title mb-20">Top Link </h2>
                <div className="mt-footer-content">
                  <ul>
                    <li><Link to="/">Home</Link></li>
                    <li><Link to="/about">About Us</Link></li>
                    <li><Link to="/services">Services</Link></li>
                    <li><Link to="/blog">Our Blog</Link></li>
                    <li><Link to="/contact">Our Contact</Link></li>
                  </ul>
                </div>
              </div>
            </div>
            <div className="col-lg-3">
              <div className="mt-footer-widget footer-cols-4 mb-50">
                <h2 className="mt-footer-title mb-20">Subscribe</h2>
                <div className="mt-footer-newsletter mb-30">
                  <form action="#">
                    <div className="p-relative">
                      <input type="email" placeholder="Email Address" />
                      <button type="submit"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="15"
                        viewBox="0 0 14 15" fill="none">
                        <path
                          d="M2.41363 4.25813C5.97436 4.01426 10.6091 2.51164 13.9998 0.956055C12.4436 4.34619 10.9404 8.98031 10.6971 12.541L8.35749 7.54937L1.14767 14.7597C1.02149 14.8856 0.850496 14.9562 0.672272 14.9561C0.539302 14.956 0.409327 14.9166 0.298775 14.8427C0.188223 14.7688 0.102057 14.6638 0.0511761 14.541C0.000294708 14.4181 -0.0130205 14.2829 0.0129128 14.1525C0.0388461 14.0221 0.102865 13.9023 0.196875 13.8083L7.40667 6.59846L2.41363 4.25813Z"
                          fill="#C6F906" />
                      </svg></button>
                    </div>
                  </form>
                </div>
                <div className="mt-footer-social mb-10">
                  <a href="#"><i className="fa-brands fa-facebook-f"></i></a>
                  <a href="#"><i className="fa-brands fa-twitter"></i></a>
                  <a href="#"><i className="fa-brands fa-instagram"></i></a>
                  <a href="#"><i className="fa-brands fa-youtube"></i></a>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div className="mt-footer-copyright-area  mt-footer-copyright-5 p-relative ">
          <div className="row align-items-center">
            <div className="col-xl-12 ">
              <div className="mt-footer-copyright text-center">
                <p>© 1995-{new Date().getFullYear()} All rights for <Link to="/">Nanantal</Link> exclusive</p>
              </div>
            </div>

          </div>
        </div>
      </div>
    </footer>
  )
}
