import { Link } from "react-router-dom";

 

export default function FooterOne() {
  return (
      <footer className="mt-footer-area p-relative black-bg-2 pb-60">
      <div className="container">
         <div className="mt-footer-main-wrapper pt-120 mb-25">
            <div className="row">
               <div className="col-lg-3">
                  <div className="mt-footer-widget footer-cols-1 mb-50">
                     <div className="mt-footer-logo">
                        <Link to="/"><img src="assets/img/logo/white-logo.png" alt="" /></Link>
                     </div>
                  </div>
               </div>
               <div className="col-lg-3">
                  <div className="mt-footer-widget footer-cols-2 mb-50">
                     <h2 className="mt-footer-title mb-20">Address </h2>
                     <div className="mt-footer-content">
                        <p>4517 Washington Ave. Manchester,
                           Kentucky 39495</p>
                        <span><a href="tel:1525545862155">+1525 5458 621 55</a></span>
                     </div>
                  </div>
               </div>
               <div className="col-lg-3">
                  <div className="mt-footer-widget footer-cols-3 mb-50">
                     <h2 className="mt-footer-title mb-20">Top Link </h2>
                     <div className="mt-footer-content">
                        <ul>
                           <li><Link to="/about">About Us</Link></li>
                           <li><Link to="/">Home</Link></li>
                           <li><Link to="/services">Services</Link></li>
                           <li><Link to="#">Page</Link></li>
                           <li><Link to="/blog">Blog</Link></li>
                        </ul>
                     </div>
                  </div>
               </div>
               <div className="col-lg-3">
                  <div className="mt-footer-widget footer-cols-4 mb-50">
                     <h2 className="mt-footer-title mb-20">Subscribe</h2>
                     <div className="mt-footer-newsletter">
                        <form action="#">
                           <div className="p-relative">
                              <input type="email" placeholder="Email Address" />
                              <button type="submit"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="15"
                                    viewBox="0 0 14 15" fill="none">
                                    <path
                                       d="M2.41363 4.25813C5.97436 4.01426 10.6091 2.51164 13.9998 0.956055C12.4436 4.34619 10.9404 8.98031 10.6971 12.541L8.35749 7.54937L1.14767 14.7597C1.02149 14.8856 0.850496 14.9562 0.672272 14.9561C0.539302 14.956 0.409327 14.9166 0.298775 14.8427C0.188223 14.7688 0.102057 14.6638 0.0511761 14.541C0.000294708 14.4181 -0.0130205 14.2829 0.0129128 14.1525C0.0388461 14.0221 0.102865 13.9023 0.196875 13.8083L7.40667 6.59846L2.41363 4.25813Z"
                                       fill="#C6F906" />
                                 </svg></button>
                           </div>
                        </form>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div className="mt-footer-copyright-area mt-footer-copyright-space p-relative " style={{backgroundColor: "#C6F906"}}>
            <div className="row align-items-center">
               <div className="col-xl-3 col-lg-3">
                  <div className="mt-footer-copyright mb-30">
                     <h3 className="mt-footer-copyright-title">Say Hello</h3>
                     <span><a href="mailto:info@website.com">info@website.com</a></span>
                  </div>
               </div>
               <div className="col-xl-6 col-lg-6">
                  <div className="mt-footer-copyright-menu text-center mb-30">
                     <ul>
                        <li><Link to="/about">about Us</Link><i></i></li>
                        <li><Link to="#">Management</Link><i></i></li>
                        <li><Link to="/portfolio">project</Link><i></i></li>
                        <li><Link to="/faq">FAQ’s</Link></li>
                     </ul>
                  </div>
               </div>
               <div className="col-xl-3 col-lg-3">
                  <div className="mt-footer-copyright text-end mb-30">
                     <h3 className="mt-footer-copyright-title">Contact</h3>
                     <span><a href="tel:0257045550127">+025 (704) 555-0127</a></span>
                  </div>
               </div>
            </div>
            <div className="mt-footer-copyright-text mtborder text-center">
               <div className="mt-footer-copyright-social mb-10">
                  <a href="#"><i className="fa-brands fa-facebook-f"></i></a> {' '}
                  <a href="#"><i className="fa-brands fa-twitter"></i></a> {' '}
                  <a href="#"><i className="fa-brands fa-instagram"></i></a> {' '}
                  <a href="#"><i className="fa-brands fa-youtube"></i></a> {' '}
               </div>
               <div className="mt-footer-copyright-bottom text-center">
                  <p>© 1995-{new Date().getFullYear()} All rights for Nanantal exclusive.</p>
               </div>
            </div>
         </div>
      </div>
   </footer>
  )
}
