import { Link } from "react-router-dom";

 

export default function FooterThree() {
  return (
    <footer className="mt-footer-area p-relative black-bg-2 " data-bg-color="#0B0E0F" style={{ backgroundColor: `#0B0E0F` }}>
      <div className="container">
         <div className="mt-footer-wrapper pt-100 mb-40">
            <div className="row">
               <div className="col-xl-3 col-lg-6 col-md-6">
                  <div className="mt-footer-widget footer-3-cols-1 mb-50">
                     <div className="mt-footer-content pl-6">
                        <h4 className="mb-45">start your
                           journey with us</h4>
                        <div className="footerg__btn-wrap">
                           <Link to="/contact">
                              <span className="mt-btn">contact Us</span>
                              <span className="mt-btn mt-btn-icon rotate"><i className="fa-solid fa-arrow-right"></i></span>
                           </Link>
                        </div>
                     </div>
                  </div>
               </div>
               <div className="col-xl-3 col-lg-6 col-md-6">
                  <div className="mt-footer-widget footer-2-cols-2 mb-50">
                     <h2 className="mt-footer-title mb-20 ">Company </h2>
                     <div className="mt-footer-content">
                        <ul>
                           <li><Link to="/">who we are?</Link></li>
                           <li><Link to="/services">our Services</Link></li>
                           <li><Link to="/team">Meet Our Team</Link></li>
                           <li><Link to="/blog">latest blog</Link></li>
                           <li><Link to="/contact">Contact</Link></li>
                        </ul>
                     </div>
                  </div>
               </div>
               <div className="col-xl-3 col-lg-6 col-md-6">
                  <div className="mt-footer-widget footer-2-cols-3 mb-50">
                     <h2 className="mt-footer-title mb-20 ">Services </h2>
                     <div className="mt-footer-content">
                        <ul>
                           <li><Link to="/">Custom Home Design</Link></li>
                           <li><Link to="/testimonial">Structural Engineering</Link></li>
                           <li><Link to="/service-details">Restoration Services</Link></li>
                           <li><Link to="/portfolio-details">Exterior Detailing</Link></li>
                           <li><Link to="/team-details">Renovation</Link></li>
                        </ul>
                     </div>
                  </div>
               </div>
               <div className="col-xl-3 col-lg-6 col-md-6">
                  <div className="mt-footer-widget footer-2-cols-4 mb-50">
                     <h2 className="mt-footer-title mb-20 ">Newsletter.</h2>
                     <div className="mt-footer-newsletter">
                        <form action="#">
                           <div className="newsletter-3 p-relative mb-15">
                              <input type="email" placeholder="Enter email" />
                              <button type="submit">Subscribe</button>
                           </div>
                        </form>
                     </div>
                     <p>Don't miss the latest news</p>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <div className="mt-footer-copyright-area mt-footer-copyright-2 mt-footer-copyright-3 p-relative ">
         <div className="container">
            <div className="row align-items-center">
               <div className="col-xl-4 col-lg-4">
                  <div className="mt-footer-copyright mb-35">
                     <p>© 1995-{new Date().getFullYear()} All rights for <Link to="/">Nanantal</Link> exclusive</p>
                  </div>
               </div>
               <div className="col-xl-4 col-lg-4">
                  <div className="mt-footer-copyright-logo text-center mb-35">
                     <Link to="/"><img src="assets/img/logo/white-logo.png" alt="" /></Link>
                  </div>
               </div>
               <div className="col-xl-4 col-lg-4">
                  <div className="mt-footer-copyright-menu text-center text-lg-end mb-35">
                     <ul>
                        <li><a href="#">Terms & Condition | </a></li> {' '}
                        <li><a href="#">Privacy Policy |</a></li> {' '}
                        <li><a href="#">Legal</a></li> {' '}
                     </ul>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </footer>
  )
}
