import { Link } from "react-router-dom";


export default function FooterTwo() {
  return (
    <footer className="mt-footer-area p-relative black-bg-2 ">
      <div className="container">
        <div className="mt-footer-wrapper mtborder pt-100">
          <div className="row">
            <div className="col-lg-3 col-md-6">
              <div className="mt-footer-widget footer-2-cols-1 mb-50">
                <div className="mt-footer-logo mb-20">
                  <Link to="/"><img src="assets/img/logo/white-logo.png" alt="" /></Link>
                </div>
                <div className="mt-footer-content">
                  <p className="mb-60">Every project we undertake is a
                    testament dedication.</p>
                  <div className="mt-footer-social mb-10">
                    <a href="#"><span>FB.</span></a>{" "}
                    <a href="#"><span>TW.</span></a>{" "}
                    <a href="#"><span>IN.</span></a>{" "}
                    <a href="#"><span>LE.</span></a>{" "}
                  </div>
                </div>
              </div>
            </div>
            <div className="col-lg-3 col-md-6">
              <div className="mt-footer-widget footer-2-cols-2 mb-50">
                <h2 className="mt-footer-title mb-20 mt-upper">Company </h2>
                <div className="mt-footer-content">
                  <ul>
                    <li><Link to="/">who we are?</Link></li>
                    <li><Link to="/services">our Services</Link></li>
                    <li><Link to="/team">Meet Our Team</Link></li>
                    <li><Link to="/blog">latest blog</Link></li>
                    <li><Link to="/contact">Contact</Link></li>
                  </ul>
                </div>
              </div>
            </div>
            <div className="col-lg-3 col-md-6">
              <div className="mt-footer-widget footer-2-cols-3 mb-50">
                <h2 className="mt-footer-title mb-20 mt-upper">Services </h2>
                <div className="mt-footer-content">
                  <ul>
                    <li><Link to="/">Custom Home Design</Link></li>
                    <li><Link to="#">Structural Engineering</Link></li>
                    <li><Link to="/service-details">Restoration Services</Link></li>
                    <li><Link to="/team-details">Exterior Detailing</Link></li>
                    <li><Link to="#">Renovation</Link></li>
                  </ul>
                </div>
              </div>
            </div>
            <div className="col-lg-3 col-md-6">
              <div className="mt-footer-widget footer-2-cols-4 mb-50">
                <h2 className="mt-footer-title mb-20 mt-upper">Newsletter.</h2>
                <p>Don't miss the latest news</p>
                <div className="mt-footer-newsletter">
                  <form action="#">
                    <div className="newsletter-2 p-relative">
                      <input type="email" placeholder="Enter email" />
                      <button type="submit"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="15"
                        viewBox="0 0 14 15" fill="none">
                        <path
                          d="M2.41363 4.25813C5.97436 4.01426 10.6091 2.51164 13.9998 0.956055C12.4436 4.34619 10.9404 8.98031 10.6971 12.541L8.35749 7.54937L1.14767 14.7597C1.02149 14.8856 0.850496 14.9562 0.672272 14.9561C0.539302 14.956 0.409327 14.9166 0.298775 14.8427C0.188223 14.7688 0.102057 14.6638 0.0511761 14.541C0.000294708 14.4181 -0.0130205 14.2829 0.0129128 14.1525C0.0388461 14.0221 0.102865 13.9023 0.196875 13.8083L7.40667 6.59846L2.41363 4.25813Z"
                          fill="#C6F906" />
                      </svg></button>
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className="mt-footer-copyright-area mt-footer-copyright-2 p-relative ">
        <div className="container">
          <div className="row align-items-center">
            <div className="col-lg-6 col-md-6">
              <div className="mt-footer-copyright mb-10">
                <p>© 1995-{new Date().getFullYear()} All rights for <a href="index">Nanantal</a> exclusive</p>
              </div>
            </div>
            <div className="col-lg-6 col-md-6">
              <div className="mt-footer-copyright-menu text-center text-md-end mb-10">
                <ul>
                  <li><a href="#">Terms & Condition |  </a></li>{" "}
                  <li><a href="#">Privacy Policy | </a></li>{" "}
                  <li><a href="#">Legal</a></li>{" "}
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </footer>
  )
}
