 
import { Link } from "react-router-dom";
import Navmenu from "./Navmenu";
import { useState } from "react"; 
import UseSticky from "../../hooks/UseSticky";
import OffCanvas from "../../common/OffCanvas";



export default function HeaderFive() {
   const { sticky } = UseSticky();
  const [menuOpen, setMenuOpen] = useState(false);

  return (
    <>
      <header className="mtheader__area mt-transparent-header p-relative">
        <div
          className="mtheader__top-area mtheader__top-5 mtheader__top-border-bottom  theme-bg p-relative d-none d-lg-block">
          <div className="container">
            <div className="mtheader__top-wrap d-flex align-items-center justify-content-between">
              <div className="mtheader__top-left">
                <a href="#"><i className="fa-light fa-location-dot"></i><span>2464 Royal Ln. Mesa, New York</span></a>
                <a href="mailto:info@arcitagmail.com"><i
                  className="fa-light fa-envelope"></i><span>Info@Nanantalgmail.com</span></a>
              </div>
              <div className="mtheader__top-right d-flex align-items-center justify-content-between">
                <div className="mtheader__top-left mr-10">
                  <a href="#"><i className="fa-regular fa-clock"></i><span>Mon - Sat 8:00 - 18:20</span></a>
                </div>
                <div className="mtheader__top-social">
                  <a href="#"><i className="fa-brands fa-pinterest-p"></i></a>
                  <a href="#"><i className="fa-brands fa-instagram"></i></a>
                  <a href="#"><i className="fa-brands fa-facebook-f"></i></a>
                  <a href="#"><i className="fa-brands fa-youtube"></i></a>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div id="mt-header-sticky" className={`mtheader__main-wrapper ${sticky ? "header-sticky" : ""}`}>
          <div className="container">
            <div className="row align-items-center">
              <div className="col-xl-2 col-6">
                <div className="mtheader__logo">
                  <Link to="/"><img src="assets/img/logo/white-logo.png" alt="" /></Link>
                </div>
              </div>
              <div className="col-xl-8 d-none d-xl-block">
                <div className="mtheader__menu  text-center">
                  <nav className="mt-mobile-menu-active">
                    <Navmenu />
                  </nav>
                </div>
              </div>
              <div className="col-xl-2 col-6">
                <div className="mtheader__right text-end">
                  <div className="mtheader__right-bar mt-10 mb-10">
                    <button className="mt-offcanvas-toogle" onClick={() => setMenuOpen(true)}><i className="fa-light fa-bars-staggered"></i></button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </header>
      <OffCanvas menuOpen={menuOpen} setMenuOpen={setMenuOpen} />


    </>
  )
}
