 
import { Link } from "react-router-dom";
import Navmenu from "./Navmenu";
import { useState } from "react"; 
import UseSticky from "../../hooks/UseSticky";
import SearchArea from "../../common/SearchArea";
import OffCanvas from "../../common/OffCanvas";

export default function HeaderOne() {
  const { sticky } = UseSticky();
  const [searchOpen, setSearchOpen] = useState(false);
  const [menuOpen, setMenuOpen] = useState(false);


  return (
    <>
      <header className="mtheader__area mt-transparent-header p-relative">
        <div id="mt-header-sticky" className={`mtheader ${sticky ? "header-sticky" : ""}`}>
          <div className="container">
            <div className="row align-items-center">
              <div className="col-xl-2 col-lg-4 col-6">
                <div className="mtheader__logo">
                  <Link to="/"><img src="assets/img/logo/white-logo.png" alt="" /></Link>
                </div>
              </div>
              <div className="col-xl-7 d-none d-xl-block">
                <div className="mtheader__menu text-center">
                  <nav className="mt-mobile-menu-active">
                    <Navmenu />
                  </nav>
                </div>
              </div>
              <div className="col-xl-3 col-lg-8 col-6">
                <div className="mtheader__right d-flex align-items-center justify-content-end">
                  <div className="mtheader__search mr-15">
                    <button onClick={() => setSearchOpen(!searchOpen)} className="mtsearch mt-search-toggle"><i
                      className="fa-regular fa-magnifying-glass"></i></button>
                    <span></span>
                  </div>
                  <div className="mtheader__btn-wrap d-none d-md-block mr-15">
                    <Link to="/about" className="mt-btn-wrap">
                      <span className="mt-btn">Let’s Talk</span>
                      <span className="mt-btn mt-btn-icon"><i className="fa-solid fa-arrow-right"></i></span>
                    </Link>
                  </div>
                  <div className="mtheader__right-bar mt-10 mb-10  d-block d-xl-none">
                    <button className="mt-offcanvas-toogle" onClick={() => setMenuOpen(!menuOpen)}><i className="fa-light fa-bars-staggered"></i></button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </header>
      <SearchArea searchOpen={searchOpen} setSearchOpen={setSearchOpen} />
      <OffCanvas menuOpen={menuOpen} setMenuOpen={setMenuOpen} />
    </>
  )
}
