//  

// import { usePathname } from 'next/navigation';
// import HeaderTwo from './HeaderTwo';
// import HeaderThree from './HeaderThree';
// import HeaderFour from './HeaderFour';
// import HeaderFive from './HeaderFive';
// import HeaderOne from './HeaderOne'; 
// import OnePageHeaderOne from '../one-page-headers/OnePageHeaderOne';
// import OnePageHeaderTwo from '../one-page-headers/OnePageHeaderTwo';
// import OnePageHeaderThree from '../one-page-headers/OnePageHeaderThree';
// import OnePageHeaderFour from '../one-page-headers/OnePageHeaderFour';
// import OnePageHeaderFive from '../one-page-headers/OnePageHeaderFive';

// export default function HeaderSelector() {
//   const pathname = usePathname() || '';

//   // Check one-page routes FIRST (more specific)
//   if (pathname.includes('home-one-page')) return <OnePageHeaderOne />;
//   if (pathname.includes('home-2-one-page')) return <OnePageHeaderTwo />;
//   if (pathname.includes('home-3-one-page')) return <OnePageHeaderThree />;
//   if (pathname.includes('home-4-one-page')) return <OnePageHeaderFour />;
//   if (pathname.includes('home-5-one-page')) return <OnePageHeaderFive />;

//   // Then check multi-page routes (less specific)
//   if (pathname.includes('home-2')) return <HeaderTwo />;
//   if (pathname.includes('home-3')) return <HeaderThree />;
//   if (pathname.includes('home-4')) return <HeaderFour />;
//   if (pathname.includes('home-5')) return <HeaderFive />;

//   // Default: home-1 or other pages
//   return <HeaderOne />;
// }



import { useLocation } from "react-router-dom";

import HeaderTwo from "./HeaderTwo";
import HeaderThree from "./HeaderThree";
import HeaderFour from "./HeaderFour";
import HeaderFive from "./HeaderFive";
import HeaderOne from "./HeaderOne";

import OnePageHeaderOne from "../one-page-headers/OnePageHeaderOne";
import OnePageHeaderTwo from "../one-page-headers/OnePageHeaderTwo";
import OnePageHeaderThree from "../one-page-headers/OnePageHeaderThree";
import OnePageHeaderFour from "../one-page-headers/OnePageHeaderFour";
import OnePageHeaderFive from "../one-page-headers/OnePageHeaderFive";

export default function HeaderSelector() {
  const location = useLocation();
  const pathname = location.pathname || "";

  // One-page headers (more specific)
  if (pathname.includes("home-one-page")) return <OnePageHeaderOne />;
  if (pathname.includes("home-2-one-page")) return <OnePageHeaderTwo />;
  if (pathname.includes("home-3-one-page")) return <OnePageHeaderThree />;
  if (pathname.includes("home-4-one-page")) return <OnePageHeaderFour />;
  if (pathname.includes("home-5-one-page")) return <OnePageHeaderFive />;

  // Multi-page headers
  if (pathname.includes("home-2")) return <HeaderTwo />;
  if (pathname.includes("home-3")) return <HeaderThree />;
  if (pathname.includes("home-4")) return <HeaderFour />;
  if (pathname.includes("home-5")) return <HeaderFive />;

  // Default
  return <HeaderOne />;
}
