 
import { Link } from "react-router-dom";
import menu_data from "../../data/menu-data";


export default function Navmenu() {
  return (
    <ul>
      {menu_data.map((item, i) => (
        <li key={i} className={`${item.has_dropdown ? 'dropdown has-dropdown' : ''}`}>
          <Link to={item.path}>{item.title}</Link>
          {i === 0 && (
            <div className="mt-submenu sub-menu has-homemenu">
              <div className="row gx-6 row-cols-1 row-cols-md-2 row-cols-xl-5">
                {item.sub_menus?.map((sub_item, index) => (
                  <div key={index} className="col homemenu">
                    <div className="homemenu-thumb mb-15">
                      <img src={sub_item.img} alt="" />
                      <div className="homemenu-btn">
                        {sub_item?.links?.map((link, link_index) => (
                          <Link className="mt-menu-btn" key={link_index} to={link.path}>{link.label}</Link>
                        ))}
                      </div>
                    </div>
                    <div className="homemenu-content text-center">
                      <h4 className="homemenu-title">
                        <Link to={sub_item.path}>{sub_item.title}</Link>
                      </h4>
                    </div>
                  </div>
                ))}
              </div>
            </div>
          )}
          {i !== 0 && item.has_dropdown && (
            <ul className="sub-menu">
              {item.sub_menus?.map((sub_item, index) => (
                <li key={index}>
                  <Link to={sub_item.path}>{sub_item.title}</Link>
                </li>
              ))}
            </ul>
          )}
        </li>
      ))}
    </ul>
  )
}
