 
import { Link } from "react-router-dom";
import OnePageNaveMenu from "./OnePageNaveMenu"; 
import { useState } from "react"; 
import UseSticky from "../../hooks/UseSticky";
import OnePageOffCanvas from "../../common/OnePageOffCanvas";



export default function OnePageHeaderThree() {
   const { sticky } = UseSticky();
  const [menuOpen, setMenuOpen] = useState(false);



  return (
    <>
      <header className="mtheader__area mtheader__3 mt-transparent-header p-relative">
        <div className="mtheader__top-area mtheader__top-border-bottom p-relative d-none d-lg-block">
          <div className="container">
            <div className="mtheader__top-wrapper d-flex align-items-center justify-content-between">
              <div className="mtheader__top-left">
                <a href="#"><i className="fa-light fa-location-dot"></i><span>2464 Royal Ln. Mesa, New York</span></a>
                <a href="mailto:info@arcitagmail.com"><i
                  className="fa-light fa-envelope"></i><span>Info@Nanantalgmail.com</span></a>
              </div>
              <div className="mtheader__top-right d-flex align-items-center justify-content-between">
                <div className="mtheader__top-left d-none d-xl-block mr-10">
                  <a href="#"><i className="fa-regular fa-clock"></i><span>Mon - Sat 8:00 - 18:20</span></a>
                </div>
                <div className="mtheader__top-social">
                  <a href="#"><i className="fa-brands fa-pinterest-p"></i></a>
                  <a href="#"><i className="fa-brands fa-instagram"></i></a>
                  <a href="#"><i className="fa-brands fa-facebook-f"></i></a>
                  <a href="#"><i className="fa-brands fa-youtube"></i></a>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div id="mt-header-sticky" className={`mtheader__main-wrapper ${sticky ? "header-sticky" : ""}`}>
          <div className="container">
            <div className="row align-items-center">
              <div className="col-xl-2 col-6">
                <div className="mtheader__logo mtheader__logo-2">
                  <Link to="/"><img src="assets/img/logo/logo-3.png" alt="" /></Link>
                </div>
              </div>
              <div className="col-xl-7 d-none d-xl-block">
                <div className="mtheader__menu  mtheader__menu-2">
                  <nav className="mt-mobile-menu-active">
                    <OnePageNaveMenu />
                  </nav>
                </div>
              </div>
              <div className="col-xl-3 col-6">
                <div className="mtheader__right d-flex align-items-center justify-content-end">
                  <div className="mtheader__btn-wrap d-none d-md-block mr-10">
                    <Link to="/about" className="mt-btn-wrap">
                      <span className="mt-btn-border">Get Quite</span> {' '}
                      <span className="mt-btn-border mt-btn-border-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="12" viewBox="0 0 20 12"
                          fill="none">
                          <path
                            d="M9.37166 0.142181C12.0619 2.48755 16.4017 4.70229 19.8993 5.99995C16.4017 7.29674 12.0619 9.5106 9.3721 11.8564L11.2473 6.67238L1.05074 6.67275C0.872519 6.67253 0.701676 6.60155 0.575751 6.47543C0.481748 6.38139 0.417737 6.26159 0.391812 6.13117C0.365886 6.00075 0.379207 5.86557 0.430097 5.74272C0.480986 5.61988 0.567157 5.51488 0.677713 5.441C0.788269 5.36712 0.918249 5.32767 1.05122 5.32765L11.2474 5.32765L9.37166 0.142181Z"
                            fill="#111111" />
                        </svg>
                      </span>
                    </Link>
                  </div>
                  <div className="mtheader__right-bar mt-10 mb-10">
                    <button className="mt-offcanvas-toogle" onClick={() => setMenuOpen(!menuOpen)}><i className="fa-light fa-bars-staggered"></i></button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </header>
      <OnePageOffCanvas menuOpen={menuOpen} setMenuOpen={setMenuOpen} />

    </>
  )
}
