 
import { Link } from "react-router-dom";
import OnePageNaveMenu from "./OnePageNaveMenu";
import { useState } from "react";
import UseSticky from "../../hooks/UseSticky";
import OnePageOffCanvas from "../../common/OnePageOffCanvas";



export default function OnePageHeaderTwo() {
   const { sticky } = UseSticky();
  const [menuOpen, setMenuOpen] = useState(false);

  return (
    <>
      <header className="mtheader__area mt-transparent-header p-relative">
        <div id="mt-header-sticky" className={`mtheader mtheader__2 ${sticky ? "header-sticky" : ""}`}>
          <div className="container">
            <div className="row align-items-center">
              <div className="col-xl-2 col-6">
                <div className="mtheader__logo">
                  <Link to="/"><img src="assets/img/logo/white-logo.png" alt="" /></Link>
                </div>
              </div>
              <div className="col-xl-8 d-none d-xl-block">
                <div className="mtheader__menu  text-center">
                  <nav className="mt-mobile-menu-active">
                    <OnePageNaveMenu />
                  </nav>
                </div>
              </div>
              <div className="col-xl-2 col-6">
                <div className="mtheader__right text-end">
                  <div className="mtheader__right-bar mt-10 mb-10">
                    <button className="mt-offcanvas-toogle" onClick={() => setMenuOpen(true)}><i className="fa-light fa-bars-staggered"></i></button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </header>
      <OnePageOffCanvas menuOpen={menuOpen} setMenuOpen={setMenuOpen} />

    </>
  )
}
