 
import { Link } from "react-router-dom";
import { useState } from "react";
import menu_data_two from "../../data/menu-data-two";

export default function OnePageMobileMenu() {

  // menu toggle function 
  const [navTitle, setNavTitle] = useState<string>("");
  const openMobileMenu = (menu: string) => {
    if (navTitle === menu) {
      setNavTitle("");
    } else {
      setNavTitle(menu);
    }
  };




  return (
    <ul>

      {menu_data_two.map((item, i) => (
        <li key={i} className={`${item.has_dropdown ? 'dropdown has-dropdown' : ''} ${navTitle === item.title ? "active" : ""}`} >
          <Link to={item.path}>{item.title}</Link>
          {i === 0 && (
            <>
              <div className="mt-submenu sub-menu has-homemenu" style={{ display: navTitle === item.title ? "block" : "none" }}>
                <div className="row gx-6 row-cols-1 row-cols-md-2 row-cols-xl-5">
                  {item.sub_menus?.map((sub_item, index) => (
                    <div key={index} className="col homemenu">
                      <div className="homemenu-thumb mb-15">
                        <img src={sub_item.image} alt="" />
                        <div className="homemenu-btn"> 
                          <Link className="mt-menu-btn" to={sub_item.path}>Multi page</Link> {' '}
                          <Link className="mt-menu-btn" to={sub_item.onePageLink}>One Page</Link> {' '}
                        </div>
                      </div>
                      <div className="homemenu-content text-center">
                        <h4 className="homemenu-title">
                          <Link to={sub_item.path}>{sub_item.title}</Link>
                        </h4>
                      </div>
                    </div>
                  ))}
                </div>
              </div>
              <button className="mt-menu-close" onClick={() => openMobileMenu(item.title)}><i className="fas fa-chevron-right"></i></button>
            </>
          )}

        </li>
      ))}
    </ul>
  )
}
