 
import { Link } from "react-router-dom";
import menu_data_two from "../../data/menu-data-two";


export default function OnePageNaveMenu() {
  return (
    <ul>
      {menu_data_two.map((item, i) => (
        <li key={i} className={`${item.has_dropdown ? 'dropdown has-dropdown' : ''}`}>
          <Link to={item.path}>{item.title}</Link>
          {i === 0 && (
            <div className="mt-submenu sub-menu has-homemenu">
              <div className="row gx-6 row-cols-1 row-cols-md-2 row-cols-xl-5">
                {item.sub_menus?.map((sub_item, index) => (
                  <div key={index} className="col homemenu">
                    <div className="homemenu-thumb mb-15">
                      <img src={sub_item.image} alt="" />
                      <div className="homemenu-btn">
                        <Link className="mt-menu-btn" to={sub_item.path}>Multi page</Link> {' '}
                        <Link className="mt-menu-btn" to={sub_item.onePageLink}>One Page</Link> {' '}
                      </div>
                    </div>
                    <div className="homemenu-content text-center">
                      <h4 className="homemenu-title">
                        <Link to={sub_item.path}>{sub_item.title}</Link>
                      </h4>
                    </div>
                  </div>
                ))}
              </div>
            </div>
          )}
        </li>
      ))}
    </ul>
  )
}

