 

import * as Dialog from "@radix-ui/react-dialog";
import { useState } from "react";

const VideoPopup = ({ children }: { children: React.ReactNode }) => {
  const [open, setOpen] = useState(false);

  return (
    <Dialog.Root open={open} onOpenChange={setOpen}>
      <Dialog.Trigger asChild>
        <div style={{ cursor: "pointer" }}>{children}</div>
      </Dialog.Trigger>

      <Dialog.Portal>
        {/* Overlay */}
        <Dialog.Overlay
          style={{
            background: "rgba(0, 0, 0, 0.6)",
            position: "fixed",
            inset: 0,
            backdropFilter: "blur(2px)",
          }}
        />

        {/* Modal Content */}
        <Dialog.Content
          style={{
            background: "white",
            padding: 0,
            borderRadius: "8px",
            position: "fixed",
            top: "50%",
            left: "50%",
            transform: "translate(-50%, -50%)",
            width: "800px",
            maxWidth: "90vw",
            maxHeight: "90vh",
            overflow: "hidden",
            boxShadow: "0 10px 30px rgba(0,0,0,0.3)",
          }}
        >
          {/* Close Button */}
          <Dialog.Close
            style={{
              position: "absolute",
              top: "10px",
              right: "10px",
              background: "none",
              border: "none",
              fontSize: "24px",
              cursor: "pointer",
              lineHeight: 1,
            }}
          >
            ✕
          </Dialog.Close>

          {/* Video */}
          <div
            style={{
              position: "relative",
              width: "100%",
              paddingBottom: "56.25%",
              height: 0,
            }}
          >
            <iframe
              src="https://www.youtube.com/embed/Q5PG0rMXgvw"
              title="YouTube video player"
              allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
              allowFullScreen
              style={{
                position: "absolute",
                top: 0,
                left: 0,
                width: "100%",
                height: "100%",
                border: "none",
              }}
            />
          </div>
        </Dialog.Content>
      </Dialog.Portal>
    </Dialog.Root>
  );
};

export default VideoPopup;
