<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Enqueue custom styles.
 */
if ( ! class_exists( 'Atomlab_Custom_Css' ) ) {
	class Atomlab_Custom_Css {

		public function __construct() {
			add_action( 'wp_enqueue_scripts', array( $this, 'extra_css' ) );
		}

		/**
		 * Responsive styles.
		 *
		 * @access public
		 */
		public function extra_css() {
			$primary_color = Atomlab::setting( 'primary_color' );
			$px            = 'px';

			// Responsive body font-size.
			$body_font_sensitive       = Atomlab::setting( 'body_font_sensitive' );
			$body_font_size_max        = Atomlab::setting( 'body_font_size' );
			$body_font_size_min        = $body_font_size_max * $body_font_sensitive;
			$body_font_size_responsive = "calc($body_font_size_min$px + ($body_font_size_max - $body_font_size_min) * ((100vw - 554px) / 646))";

			// Responsive H1 font-size.
			$heading_font_sensitive  = Atomlab::setting( 'heading_font_sensitive' );
			$h1_font_size_max        = Atomlab::setting( 'h1_font_size' );
			$h1_font_size_min        = $h1_font_size_max * $heading_font_sensitive;
			$h1_font_size_responsive = "calc($h1_font_size_min$px + ($h1_font_size_max - $h1_font_size_min) * ((100vw - 554px) / 646))";

			// Responsive H2 font-size.
			$h2_font_size_max        = Atomlab::setting( 'h2_font_size' );
			$h2_font_size_min        = $h2_font_size_max * $heading_font_sensitive;
			$h2_font_size_responsive = "calc($h2_font_size_min$px + ($h2_font_size_max - $h2_font_size_min) * ((100vw - 554px) / 646))";

			// Responsive H3 font-size.
			$h3_font_size_max        = Atomlab::setting( 'h3_font_size' );
			$h3_font_size_min        = $h3_font_size_max * $heading_font_sensitive;
			$h3_font_size_responsive = "calc($h3_font_size_min$px + ($h3_font_size_max - $h3_font_size_min) * ((100vw - 554px) / 646))";

			// Responsive H4 font-size.
			$h4_font_size_max        = Atomlab::setting( 'h4_font_size' );
			$h4_font_size_min        = $h4_font_size_max * $heading_font_sensitive;
			$h4_font_size_responsive = "calc($h4_font_size_min$px + ($h4_font_size_max - $h4_font_size_min) * ((100vw - 554px) / 646))";

			// Responsive H5 font-size.
			$h5_font_size_max        = Atomlab::setting( 'h5_font_size' );
			$h5_font_size_min        = $h5_font_size_max * $heading_font_sensitive;
			$h5_font_size_responsive = "calc($h5_font_size_min$px + ($h5_font_size_max - $h5_font_size_min) * ((100vw - 554px) / 646))";

			// Responsive H6 font-size.
			$h6_font_size_max        = Atomlab::setting( 'h6_font_size' );
			$h6_font_size_min        = $h6_font_size_max * $heading_font_sensitive;
			$h6_font_size_responsive = "calc($h6_font_size_min$px + ($h6_font_size_max - $h6_font_size_min) * ((100vw - 554px) / 646))";

			$body_typo     = Atomlab::setting( 'typography_body' );
			$_primary_font = $body_typo['font-family'];
			$_primary_font = trim( $_primary_font, ' ,' );

			$extra_style = "
				.primary-font, .tm-button, button, input, select, textarea{ font-family: $_primary_font }
				.primary-font-important { font-family: $_primary_font !important }
				body{font-size: $body_font_size_min$px}
				h1,.h1{font-size: $h1_font_size_min$px}
				h2,.h2{font-size: $h2_font_size_min$px}
				h3,.h3{font-size: $h3_font_size_min$px}
				h4,.h4{font-size: $h4_font_size_min$px}
				h5,.h5{font-size: $h5_font_size_min$px}
				h6,.h6{font-size: $h6_font_size_min$px}

				@media (min-width: 544px) and (max-width: 1199px) {
					body{font-size: $body_font_size_responsive}
					h1,.h1{font-size: $h1_font_size_responsive}
					h2,.h2{font-size: $h2_font_size_responsive}
					h3,.h3{font-size: $h3_font_size_responsive}
					h4,.h4{font-size: $h4_font_size_responsive}
					h5,.h5{font-size: $h5_font_size_responsive}
					h6,.h6{font-size: $h6_font_size_responsive}
				}
			";

			$custom_logo_width        = Atomlab_Helper::get_post_meta( 'custom_logo_width', '' );
			$custom_sticky_logo_width = Atomlab_Helper::get_post_meta( 'custom_sticky_logo_width', '' );

			if ( $custom_logo_width !== '' ) {
				$extra_style .= ".branding__logo img {
                    width: {$custom_logo_width} !important;
                }";
			}

			if ( $custom_sticky_logo_width !== '' ) {
				$extra_style .= ".headroom--not-top .branding__logo .sticky-logo {
                    width: {$custom_sticky_logo_width} !important;
                }";
			}

			$headerStickyHeight = Atomlab::setting( 'header_sticky_height' );
			$stickyPadding      = $headerStickyHeight + 30;
			if ( is_admin_bar_showing() ) {
				$stickyPadding += 32;
			}

			$extra_style .= ".tm-sticky-kit.is_stuck {
				padding-top: {$stickyPadding}px;
			}";

			$site_width = Atomlab_Helper::get_post_meta( 'site_width', '' );
			if ( $site_width === '' ) {
				$site_width = Atomlab::setting( 'site_width' );
			}
			if ( $site_width !== '' ) {
				$extra_style .= ".boxed {
                max-width: $site_width;
            }
            @media (min-width: 1200px) { .container {
				max-width: $site_width;
			}}";
			}

			$tmp = '';

			$site_background_color = Atomlab_Helper::get_post_meta( 'site_background_color', '' );
			if ( $site_background_color !== '' ) {
				$tmp .= "background-color: $site_background_color !important;";
			}

			$site_background_image = Atomlab_Helper::get_post_meta( 'site_background_image', '' );
			if ( $site_background_image !== '' ) {
				$site_background_repeat = Atomlab_Helper::get_post_meta( 'site_background_repeat', '' );
				$tmp                    .= "background-image: url( $site_background_image ) !important; background-repeat: $site_background_repeat !important;";
			}

			$site_background_position = Atomlab_Helper::get_post_meta( 'site_background_position', '' );
			if ( $site_background_position !== '' ) {
				$tmp .= "background-position: $site_background_position !important;";
			}

			$site_background_attachment = Atomlab_Helper::get_post_meta( 'site_background_attachment', '' );
			if ( $site_background_attachment !== '' ) {
				$tmp .= "background-attachment: $site_background_attachment !important;";
			}

			if ( $tmp !== '' ) {
				$extra_style .= "body { $tmp; }";
			}

			$tmp = '';

			$content_background_color = Atomlab_Helper::get_post_meta( 'content_background_color', '' );
			if ( $content_background_color !== '' ) {
				$tmp .= "background-color: $content_background_color !important;";
			}

			$content_background_image = Atomlab_Helper::get_post_meta( 'content_background_image', '' );
			if ( $content_background_image !== '' ) {
				$content_background_repeat = Atomlab_Helper::get_post_meta( 'content_background_repeat', '' );
				$tmp                       .= "background-image: url( $content_background_image ) !important; background-repeat: $content_background_repeat !important;";
			}

			$content_background_position = Atomlab_Helper::get_post_meta( 'content_background_position', '' );
			if ( $content_background_position !== '' ) {
				$tmp .= "background-position: $content_background_position !important;";
			}

			$content_padding = Atomlab_Helper::get_post_meta( 'content_padding' );
			if ( $content_padding === '0' ) {
				$tmp .= 'padding-top: 0;';
				$tmp .= 'padding-bottom: 0;';
			}

			if ( $tmp !== '' ) {
				$extra_style .= ".page-content { $tmp; }";
			}

			$extra_style .= $this->primary_color_css();
			$extra_style .= $this->secondary_color_css();
			$extra_style .= $this->third_color_css();
			$extra_style .= $this->sidebar_css();
			$extra_style .= $this->title_bar_css();
			$extra_style .= $this->footer_css();
			$extra_style .= $this->mobile_menu_css();
			$extra_style .= $this->light_gallery_css();

			//$extra_style = Atomlab_Minify::css( $extra_style );

			wp_add_inline_style( 'atomlab-style', html_entity_decode( $extra_style, ENT_QUOTES ) );
		}

		function sidebar_css() {
			$css = '';

			if ( is_search() && ! is_post_type_archive( 'product' ) ) {
				$page_sidebar1 = Atomlab::setting( 'search_page_sidebar_1' );
				$page_sidebar2 = Atomlab::setting( 'search_page_sidebar_2' );
			} elseif ( is_post_type_archive( 'product' ) || ( function_exists( 'is_product_taxonomy' ) && is_product_taxonomy() ) ) {
				$page_sidebar1 = Atomlab::setting( 'product_archive_page_sidebar_1' );
				$page_sidebar2 = Atomlab::setting( 'product_archive_page_sidebar_2' );
			} elseif ( is_post_type_archive( 'portfolio' ) || Atomlab_Portfolio::is_taxonomy() ) {
				$page_sidebar1 = Atomlab::setting( 'portfolio_archive_page_sidebar_1' );
				$page_sidebar2 = Atomlab::setting( 'portfolio_archive_page_sidebar_2' );
			} elseif ( is_archive() ) {
				$page_sidebar1 = Atomlab::setting( 'blog_archive_page_sidebar_1' );
				$page_sidebar2 = Atomlab::setting( 'blog_archive_page_sidebar_2' );
			} elseif ( is_home() ) {
				$page_sidebar1 = Atomlab::setting( 'home_page_sidebar_1' );
				$page_sidebar2 = Atomlab::setting( 'home_page_sidebar_2' );
			} elseif ( is_singular( 'post' ) ) {
				$page_sidebar1 = Atomlab_Helper::get_post_meta( 'page_sidebar_1', 'default' );
				$page_sidebar2 = Atomlab_Helper::get_post_meta( 'page_sidebar_2', 'default' );
				if ( $page_sidebar1 === 'default' ) {
					$page_sidebar1 = Atomlab::setting( 'post_page_sidebar_1' );
				}
				if ( $page_sidebar2 === 'default' ) {
					$page_sidebar2 = Atomlab::setting( 'post_page_sidebar_2' );
				}
			} elseif ( is_singular( 'portfolio' ) ) {
				$page_sidebar1 = Atomlab_Helper::get_post_meta( 'page_sidebar_1', 'default' );
				$page_sidebar2 = Atomlab_Helper::get_post_meta( 'page_sidebar_2', 'default' );
				if ( $page_sidebar1 === 'default' ) {
					$page_sidebar1 = Atomlab::setting( 'portfolio_page_sidebar_1' );
				}

				if ( $page_sidebar2 === 'default' ) {
					$page_sidebar2 = Atomlab::setting( 'portfolio_page_sidebar_2' );
				}
			} elseif ( is_singular( 'product' ) ) {
				$page_sidebar1 = Atomlab_Helper::get_post_meta( 'page_sidebar_1', 'default' );
				$page_sidebar2 = Atomlab_Helper::get_post_meta( 'page_sidebar_2', 'default' );
				if ( $page_sidebar1 === 'default' ) {
					$page_sidebar1 = Atomlab::setting( 'product_page_sidebar_1' );
				}

				if ( $page_sidebar2 === 'default' ) {
					$page_sidebar2 = Atomlab::setting( 'product_page_sidebar_2' );
				}
			} else {
				$page_sidebar1 = Atomlab_Helper::get_post_meta( 'page_sidebar_1', 'default' );
				$page_sidebar2 = Atomlab_Helper::get_post_meta( 'page_sidebar_2', 'default' );
				if ( $page_sidebar1 === 'default' ) {
					$page_sidebar1 = Atomlab::setting( 'page_sidebar_1' );
				}

				if ( $page_sidebar2 === 'default' ) {
					$page_sidebar2 = Atomlab::setting( 'page_sidebar_2' );
				}
			}

			if ( 'none' !== $page_sidebar1 ) {
				$sidebars_breakpoint = Atomlab::setting( 'sidebars_breakpoint' );
				$sidebars_below      = Atomlab::setting( 'sidebars_below_content_mobile' );

				if ( 'none' !== $page_sidebar2 ) {
					$sidebar_width  = Atomlab::setting( 'dual_sidebar_width' );
					$sidebar_offset = Atomlab::setting( 'dual_sidebar_offset' );
					$content_width  = 100 - $sidebar_width * 2;
				} else {
					$sidebar_width  = Atomlab::setting( 'single_sidebar_width' );
					$sidebar_offset = Atomlab::setting( 'single_sidebar_offset' );
					$content_width  = 100 - $sidebar_width;
				}

				$css .= "
				@media (min-width: {$sidebars_breakpoint}px) {
					.page-content .page-sidebar {
						flex: 0 0 $sidebar_width%;
						max-width: $sidebar_width%;
					}
					.page-main-content {
						flex: 0 0 $content_width%;
						max-width: $content_width%;
					}
				}
				@media (min-width: 1200px) {
					.page-sidebar-left .page-sidebar-inner {
						padding-right: $sidebar_offset;
					}
					.page-sidebar-right .page-sidebar-inner {
						padding-left: $sidebar_offset;
					}
				}";

				$_max_width_breakpoint = $sidebars_breakpoint - 1;

				if ( $sidebars_below === '1' ) {
					$css .= "
					@media (max-width: {$_max_width_breakpoint}px) {
						.page-main-content {
							-webkit-order: -1;
							-moz-order: -1;
							order: -1;
							margin-bottom: 50px;
						}
					}";
				}
			}

			return $css;
		}

		function title_bar_css() {
			$css = $title_bar_tmp = $overlay_tmp = '';

			$bg_color   = Atomlab_Helper::get_post_meta( 'page_title_bar_background_color', '' );
			$bg_image   = Atomlab_Helper::get_post_meta( 'page_title_bar_background', '' );
			$bg_overlay = Atomlab_Helper::get_post_meta( 'page_title_bar_background_overlay', '' );

			if ( $bg_color !== '' ) {
				$title_bar_tmp .= "background-color: {$bg_color}!important;";
			}

			if ( $bg_image !== '' ) {
				$title_bar_tmp .= "background-image: url({$bg_image})!important;";
			}

			if ( $bg_overlay !== '' ) {
				$overlay_tmp .= "background-color: {$bg_overlay}!important;";
			}

			if ( $title_bar_tmp !== '' ) {
				$css .= ".page-title-bar-inner{ {$title_bar_tmp} }";
			}

			if ( $overlay_tmp !== '' ) {
				$css .= ".page-title-bar-overlay{ {$overlay_tmp} }";
			}

			$title_bar_01_bg_type = Atomlab::setting( 'title_bar_01_bg_type' );

			if ( $title_bar_01_bg_type === 'gradient' ) {
				$_color_1 = Atomlab::setting( 'title_bar_01_bg_color_1' );
				$_color_2 = Atomlab::setting( 'title_bar_01_bg_color_2' );


				$css .= ".page-title-bar-01 .page-title-bar-inner {
                	background: {$_color_2};
                    background: -moz-linear-gradient(-180deg, {$_color_1} 0%, {$_color_2} 100%);
                    background: -webkit-linear-gradient(-180deg, {$_color_1} 0%,{$_color_2} 100%);
                    background: -o-linear-gradient(-180deg, {$_color_1} 0%,{$_color_2} 100%);
                    background: -ms-linear-gradient(-180deg, {$_color_1} 0%,{$_color_2} 100%);
                    background: linear-gradient(-180deg, {$_color_1} 0%,{$_color_2} 100%);
                }";
			}

			return $css;
		}

		function mobile_menu_css() {
			$css = '';

			$bg_type  = Atomlab::setting( 'mobile_menu_bg_type' );
			$_color_1 = Atomlab::setting( 'mobile_menu_bg_color_1' );
			$_color_2 = Atomlab::setting( 'mobile_menu_bg_color_2' );
			if ( $bg_type === 'gradient' ) {
				$css .= ".page-mobile-main-menu {
                	background: {$_color_2};
                    background: -moz-linear-gradient(-151deg, {$_color_1} 0%, {$_color_2} 100%);
                    background: -webkit-linear-gradient(-151deg, {$_color_1} 0%,{$_color_2} 100%);
                    background: -o-linear-gradient(-151deg, {$_color_1} 0%,{$_color_2} 100%);
                    background: -ms-linear-gradient(-151deg, {$_color_1} 0%,{$_color_2} 100%);
                    background: linear-gradient(-151deg, {$_color_1} 0%,{$_color_2} 100%);
                }";
			} else {
				$css .= ".page-mobile-main-menu {
                	background: {$_color_1};
                }";
			}

			return $css;
		}

		function footer_css() {
			$footer_page = Atomlab_Helper::get_post_meta( 'footer_page', 'default' );
			$css         = '';
			if ( $footer_page === 'default' ) {
				$footer_page = Atomlab::setting( 'footer_page' );
			}

			if ( $footer_page === '' ) {
				return '';
			}

			$_atomlab_args = array(
				'post_type' => 'ic_footer',
				'name'      => $footer_page,
			);

			$_atomlab_query = new WP_Query( $_atomlab_args );

			if ( $_atomlab_query->have_posts() ) {
				while ( $_atomlab_query->have_posts() ) : $_atomlab_query->the_post();
					$footer_options = Atomlab_Helper::get_the_footer_page_options();

					$css                = '';
					$widget_title_color = Atomlab_Helper::get_the_post_meta( $footer_options, 'widget_title_color', '' );
					$text_color         = Atomlab_Helper::get_the_post_meta( $footer_options, 'text_color', '' );
					$link_color         = Atomlab_Helper::get_the_post_meta( $footer_options, 'link_color', '' );
					$link_hover_color   = Atomlab_Helper::get_the_post_meta( $footer_options, 'link_hover_color', '' );

					if ( $widget_title_color !== '' ) {
						$css .= ".page-footer .widgettitle { color: {$widget_title_color}; }";
					}

					if ( $text_color !== '' ) {
						$css .= "
						.page-footer,
						.page-footer .widget_text {
							color: {$text_color};
						}";
					}

					if ( $link_color !== '' ) {
						$css .= "
			                .page-footer a,
			                .page-footer .widget_recent_entries li a,
			                .page-footer .widget_recent_comments li a,
			                .page-footer .widget_archive li a,
			                .page-footer .widget_categories li a,
			                .page-footer .widget_meta li a,
			                .page-footer .widget_product_categories li a,
			                .page-footer .widget_rss li a,
			                .page-footer .widget_pages li a,
			                .page-footer .widget_nav_menu li a,
			                .page-footer .insight-core-bmw li a {
			                    color: {$link_color};
			                }";
					}

					if ( $link_hover_color !== '' ) {
						$css .= "
			                .page-footer a:hover,
			                .page-footer .widget_recent_entries li a:hover,
			                .page-footer .widget_recent_comments li a:hover,
			                .page-footer .widget_archive li a:hover,
			                .page-footer .widget_categories li a:hover,
			                .page-footer .widget_meta li a:hover,
			                .page-footer .widget_product_categories li a:hover,
			                .page-footer .widget_rss li a:hover,
			                .page-footer .widget_pages li a:hover,
			                .page-footer .widget_nav_menu li a:hover,
			                .page-footer .insight-core-bmw li a:hover {
			                    color: {$link_hover_color};
			                }";
					}
				endwhile;
			}

			wp_reset_postdata();

			return $css;
		}

	function primary_color_css() {
		$color = Atomlab::setting( 'primary_color' );

		// Set CSS variable for primary color.
		$css = ":root { --primary-color: {$color}; }";

		return $css;
	}

	function secondary_color_css() {
		$color   = Atomlab::setting( 'secondary_color' );
		$alpha90 = Atomlab_Color::hex2rgba( $color, '0.9' );
		$alpha70 = Atomlab_Color::hex2rgba( $color, '0.7' );
		$alpha47 = Atomlab_Color::hex2rgba( $color, '0.47' );

		// Set CSS variables for secondary color and its alpha variants.
		$css = ":root { 
			--secondary-color: {$color}; 
			--secondary-color-alpha-90: {$alpha90};
			--secondary-color-alpha-70: {$alpha70};
			--secondary-color-alpha-47: {$alpha47};
		}";

		return $css;
	}

	function third_color_css() {
		$color = Atomlab::setting( 'third_color' );

		// Set CSS variable for third color.
		$css = ":root { --third-color: {$color}; }";

		return $css;
	}

		function light_gallery_css() {
			$css                    = '';
			$primary_color          = Atomlab::setting( 'primary_color' );
			$secondary_color        = Atomlab::setting( 'secondary_color' );
			$cutom_background_color = Atomlab::setting( 'light_gallery_custom_background' );
			$background             = Atomlab::setting( 'light_gallery_background' );

			$tmp = '';

			if ( $background === 'primary' ) {
				$tmp .= "background-color: {$primary_color} !important;";
			} elseif ( $background === 'secondary' ) {
				$tmp .= "background-color: {$secondary_color} !important;";
			} else {
				$tmp .= "background-color: {$cutom_background_color} !important;";
			}

			$css .= ".lg-backdrop { $tmp }";

			return $css;
		}

		function get_typo_css( $typography ) {
			$css = '';

			if ( ! empty( $typography ) ) {
				foreach ( $typography as $attr => $value ) {
					if ( $attr === 'subsets' ) {
						continue;
					}
					if ( $attr === 'font-family' ) {
						$css .= "{$attr}: \"{$value}\", Helvetica, Arial, sans-serif;";
					} elseif ( $attr === 'variant' ) {
						$css .= "font-weight: {$value};";
					} else {
						$css .= "{$attr}: {$value};";
					}
				}
			}

			return $css;
		}
	}

	new Atomlab_Custom_Css();
}
