<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Initial OneClick import for this theme
 */
if ( ! class_exists( 'Atomlab_Import' ) ) {
	class Atomlab_Import {

		public function __construct() {
			add_filter( 'insight_core_import_demos', array( $this, 'import_demos' ) );
			add_filter( 'insight_core_import_generate_thumb', '__return_true' );
			add_filter( 'insight_core_import_delete_exist_posts', '__return_true' );
		}

		public function import_demos() {
			return array(
				'01' => array(
					'screenshot' => ATOMLAB_THEME_URI . '/screenshot.jpg',
					'name'       => ATOMLAB_THEME_NAME,
					'url'        => 'https://www.dropbox.com/s/ll7nd1zy04u7oua/atomlab-insightcore01-2.0.5.zip?dl=1',
				),
			);
		}
	}

	new Atomlab_Import();
}
