<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Plugin installation and activation for WordPress themes
 */
if ( ! class_exists( 'Atomlab_Register_Plugins' ) ) {
	class Atomlab_Register_Plugins {

		const GOOGLE_DRIVER_API = 'AIzaSyDXOs0Bxx-uBEA4fH4fzgoHtl64g0RWv-g';

		public function __construct() {
			add_filter( 'insight_core_tgm_plugins', array( $this, 'register_required_plugins' ) );
		}

		public function register_required_plugins() {
			/*
			 * Array of plugin arrays. Required keys are name and slug.
			 * If the source is NOT from the .org repo, then source is also required.
			 */
			$plugins = array(
				array(
					'name'     => esc_html__( 'Insight Core', 'atomlab' ),
					'slug'     => 'insight-core',
					'source'   => $this->get_plugin_google_driver_url( '1tGr6r_A1YIGdrpZobbO8qxUwBfKulwi8' ),
					'version'  => '2.8.1',
					'required' => true,
				),
				array(
					'name'     => esc_html__( 'Revolution Slider', 'atomlab' ),
					'slug'     => 'revslider',
					'source'   => $this->get_plugin_google_driver_url( '1vBqV5JiajPOZfEYnD_QerOxSrDYNULND' ),
					'version'  => '6.7.40',
					'required' => true,
				),
				array(
					'name'     => esc_html__( 'WPBakery Page Builder', 'atomlab' ),
					'slug'     => 'js_composer',
					'source'   => $this->get_plugin_google_driver_url( '1QjNtYNQgvm_QmzWFzvOsRBNQAXRGFmBf' ),
					'version'  => '8.7.2',
					'required' => true,
				),
				array(
					'name'    => esc_html__( 'WPBakery Page Builder (Visual Composer) Clipboard', 'atomlab' ),
					'slug'    => 'vc_clipboard',
					'source'  => $this->get_plugin_google_driver_url( '1szBZeNRhU3wbVR7YRC18wCCrV2Vdr0ku' ),
					'version' => '5.0.8',
				),
				array(
					'name' => esc_html__( 'Contact Form 7', 'atomlab' ),
					'slug' => 'contact-form-7',
				),
				array(
					'name' => esc_html__( 'MailChimp for WordPress', 'atomlab' ),
					'slug' => 'mailchimp-for-wp',
				),
				array(
					'name' => esc_html__( 'WP-PostViews', 'atomlab' ),
					'slug' => 'wp-postviews',
				),
				array(
					'name' => esc_html__( 'Image Hotspot by DevVN', 'atomlab' ),
					'slug' => 'devvn-image-hotspot',
				),
				array(
					'name' => esc_html__( 'WooCommerce', 'atomlab' ),
					'slug' => 'woocommerce',
				),
				array(
					'name'     => esc_html__( 'WPC Smart Wishlist for WooCommerce', 'atomlab' ),
					'slug'     => 'woo-smart-wishlist',
					'required' => false,
				),
				array(
					'name' => esc_html__( 'WPC Smart Compare for WooCommerce', 'atomlab' ),
					'slug' => 'woo-smart-compare',
				),
			);

			return $plugins;
		}

		public function get_plugin_google_driver_url( $file_id ) {
			return "https://www.googleapis.com/drive/v3/files/{$file_id}?alt=media&key=" . self::GOOGLE_DRIVER_API;
		}

	}

	new Atomlab_Register_Plugins();
}
