<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Atomlab_Portfolio' ) ) {
	class Atomlab_Portfolio {

		public function __construct() {
			add_action( 'wp_ajax_portfolio_infinite_load', array( $this, 'infinite_load' ) );
			add_action( 'wp_ajax_nopriv_portfolio_infinite_load', array( $this, 'infinite_load' ) );
		}

		public static function is_taxonomy() {
			return is_tax( get_object_taxonomies( 'portfolio' ) );
		}

		public static function get_categories( $args = array() ) {
			$defaults = array(
				'all' => true,
			);
			$args     = wp_parse_args( $args, $defaults );
			$terms    = get_terms( array(
				'taxonomy' => 'portfolio_category',
			) );
			$results  = array();

			if ( $args['all'] === true ) {
				$results['-1'] = esc_html__( 'All', 'atomlab' );
			}

			if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
				foreach ( $terms as $term ) {
					$results[ $term->slug ] = $term->name;
				}
			}

			return $results;
		}

		public static function get_tags( $args = array() ) {
			$defaults = array(
				'all' => true,
			);
			$args     = wp_parse_args( $args, $defaults );
			$terms    = get_terms( array(
				'taxonomy' => 'portfolio_tags',
			) );
			$results  = array();

			if ( $args['all'] === true ) {
				$results['-1'] = esc_html__( 'All', 'atomlab' );
			}

			if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
				foreach ( $terms as $term ) {
					$results[ $term->slug ] = $term->name;
				}
			}

			return $results;
		}

		public function infinite_load() {
			$post_type      = ! empty( $_POST['post_type'] ) ? sanitize_text_field( $_POST['post_type'] ) : 'portfolio';
			$posts_per_page = ! empty( $_POST['posts_per_page'] ) ? intval( $_POST['posts_per_page'] ) : - 1;
			$orderby        = ! empty( $_POST['orderby'] ) ? sanitize_text_field( $_POST['orderby'] ) : 'date';
			$order          = ! empty( $_POST['order'] ) ? sanitize_text_field( $_POST['order'] ) : 'DESC';
			$paged          = ! empty( $_POST['paged'] ) ? intval( $_POST['paged'] ) : 1;

			$args = array(
				'post_type'      => $post_type,
				'posts_per_page' => $posts_per_page,
				'orderby'        => $orderby,
				'order'          => $order,
				'paged'          => $paged,
				'post_status'    => 'publish',
			);

			if ( ! empty( $_POST['taxonomies'] ) ) {
				$args = Atomlab_VC::get_tax_query_of_taxonomies( $args, sanitize_text_field( $_POST['taxonomies'] ) );
			}

			$style         = isset( $_POST['style'] ) ? sanitize_text_field( $_POST['style'] ) : 'grid';
			$overlay_style = isset( $_POST['overlay_style'] ) ? sanitize_text_field( $_POST['overlay_style'] ) : '';
			$image_size    = isset( $_POST['image_size'] ) ? sanitize_text_field( $_POST['image_size'] ) : '480x480';
			$metro_layout  = isset( $_POST['metro_layout'] ) ? sanitize_text_field( $_POST['metro_layout'] ) : '';

			$atomlab_query = new WP_Query( $args );
			$count         = $atomlab_query->post_count;

			$response = array(
				'max_num_pages' => $atomlab_query->max_num_pages,
				'found_posts'   => $atomlab_query->found_posts,
				'count'         => $atomlab_query->post_count,
			);

			ob_start();

			if ( $atomlab_query->have_posts() ) :
				set_query_var( 'atomlab_query', $atomlab_query );
				set_query_var( 'count', $count );
				set_query_var( 'metro_layout', $metro_layout );
				set_query_var( 'image_size', $image_size );
				set_query_var( 'overlay_style', $overlay_style );

				get_template_part( 'loop/shortcodes/portfolio/style', $style );
			endif;
			wp_reset_postdata();

			$template = ob_get_clean();

			$template             = preg_replace( '~>\s+<~', '><', $template );
			$response['template'] = $template;

			wp_send_json_success( $response );
		}

		public static function get_the_permalink() {
			$external = Atomlab::setting( 'archive_portfolio_external_url' );

			$url = get_the_permalink();

			if ( $external === '1' ) {
				$_url = self::get_post_meta( 'portfolio_url', '' );

				if ( $_url !== '' ) {
					$url = $_url;
				}
			}

			return $url;
		}

		public static function the_permalink() {
			$url = self::get_the_permalink();

			echo esc_url( $url );
		}

		public static function get_post_meta( $name, $default = '' ) {
			$options = maybe_unserialize( get_post_meta( get_the_ID(), 'insight_portfolio_options', true ) );
			if ( $options !== false && isset( $options[ $name ] ) ) {
				return $options[ $name ];
			}

			return $default;
		}
	}

	new Atomlab_Portfolio();
}
