<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Atomlab_VC_Icon_Linea_SVG' ) ) {
	class Atomlab_VC_Icon_Linea_SVG {

		public function __construct() {
			/*
			 * Add styles & script file only on add new or edit post type.
			 */
			add_action( 'load-post.php', array( $this, 'enqueue_scripts' ) );
			add_action( 'load-post-new.php', array( $this, 'enqueue_scripts' ) );

			add_filter( 'vc_iconpicker-type-linea_svg', array( $this, 'add_fonts' ) );

			add_action( 'vc_enqueue_font_icon_element', array( $this, 'vc_element_enqueue' ) );
		}

		public function vc_element_enqueue( $font ) {
			switch ( $font ) {
				case 'linea_svg':
					wp_enqueue_script( 'vivus', ATOMLAB_THEME_URI . '/assets/js/vivus.min.js', array( 'jquery' ), null, true );
					break;
			}
		}

		public function enqueue_scripts() {
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
		}

		function admin_enqueue_scripts() {
			// Enqueue CSS for Linea font.
			wp_enqueue_style( 'linea', ATOMLAB_THEME_URI . '/assets/fonts/linea/font-linea.min.css', null, null );
		}

		public function add_fonts( $icons ) {
			$new_icons = array(
				esc_html__( 'Arrows & Direction', 'atomlab' ) => array(
					array( 'linea-arrows-anticlockwise' => 'arrows anticlockwise' ),
					array( 'linea-arrows-anticlockwise-dashed' => 'arrows anticlockwise dashed' ),
					array( 'linea-arrows-button-down' => 'arrows button down' ),
					array( 'linea-arrows-button-off' => 'arrows button off' ),
					array( 'linea-arrows-button-on' => 'arrows button on' ),
					array( 'linea-arrows-button-up' => 'arrows button up' ),
					array( 'linea-arrows-check' => 'arrows check' ),
					array( 'linea-arrows-circle-check' => 'arrows circle check' ),
					array( 'linea-arrows-circle-down' => 'arrows circle down' ),
					array( 'linea-arrows-circle-downleft' => 'arrows circle downleft' ),
					array( 'linea-arrows-circle-downright' => 'arrows circle downright' ),
					array( 'linea-arrows-circle-left' => 'arrows circle left' ),
					array( 'linea-arrows-circle-minus' => 'arrows circle minus' ),
					array( 'linea-arrows-circle-plus' => 'arrows circle plus' ),
					array( 'linea-arrows-circle-remove' => 'arrows circle remove' ),
					array( 'linea-arrows-circle-right' => 'arrows circle right' ),
					array( 'linea-arrows-circle-up' => 'arrows circle up' ),
					array( 'linea-arrows-circle-upleft' => 'arrows circle upleft' ),
					array( 'linea-arrows-circle-upright' => 'arrows circle upright' ),
					array( 'linea-arrows-clockwise' => 'arrows clockwise' ),
					array( 'linea-arrows-clockwise-dashed' => 'arrows clockwise dashed' ),
					array( 'linea-arrows-compress' => 'arrows compress' ),
					array( 'linea-arrows-deny' => 'arrows deny' ),
					array( 'linea-arrows-diagonal' => 'arrows diagonal' ),
					array( 'linea-arrows-diagonal2' => 'arrows diagonal2' ),
					array( 'linea-arrows-down' => 'arrows down' ),
					array( 'linea-arrows-down-double-34' => 'arrows down double-34' ),
					array( 'linea-arrows-downleft' => 'arrows downleft' ),
					array( 'linea-arrows-downright' => 'arrows downright' ),
					array( 'linea-arrows-drag-down' => 'arrows drag down' ),
					array( 'linea-arrows-drag-down-dashed' => 'arrows drag down dashed' ),
					array( 'linea-arrows-drag-horiz' => 'arrows drag horiz' ),
					array( 'linea-arrows-drag-left' => 'arrows drag left' ),
					array( 'linea-arrows-drag-left-dashed' => 'arrows drag left dashed' ),
					array( 'linea-arrows-drag-right' => 'arrows drag right' ),
					array( 'linea-arrows-drag-right-dashed' => 'arrows drag right dashed' ),
					array( 'linea-arrows-drag-up' => 'arrows drag up' ),
					array( 'linea-arrows-drag-up-dashed' => 'arrows drag up dashed' ),
					array( 'linea-arrows-drag-vert' => 'arrows drag vert' ),
					array( 'linea-arrows-exclamation' => 'arrows exclamation' ),
					array( 'linea-arrows-expand' => 'arrows expand' ),
					array( 'linea-arrows-expand-diagonal1' => 'arrows expand diagonal1' ),
					array( 'linea-arrows-expand-horizontal1' => 'arrows expand horizontal1' ),
					array( 'linea-arrows-expand-vertical1' => 'arrows expand vertical1' ),
					array( 'linea-arrows-fit-horizontal' => 'arrows fit horizontal' ),
					array( 'linea-arrows-fit-vertical' => 'arrows fit vertical' ),
					array( 'linea-arrows-glide' => 'arrows glide' ),
					array( 'linea-arrows-glide-horizontal' => 'arrows glide horizontal' ),
					array( 'linea-arrows-glide-vertical' => 'arrows glide vertical' ),
					array( 'linea-arrows-hamburger1' => 'arrows hamburger1' ),
					array( 'linea-arrows-hamburger-2' => 'arrows hamburger 2' ),
					array( 'linea-arrows-horizontal' => 'arrows horizontal' ),
					array( 'linea-arrows-info' => 'arrows info' ),
					array( 'linea-arrows-keyboard-alt' => 'arrows keyboard alt' ),
					array( 'linea-arrows-keyboard-cmd-29' => 'arrows keyboard cmd-29' ),
					array( 'linea-arrows-keyboard-delete' => 'arrows keyboard delete' ),
					array( 'linea-arrows-keyboard-down-28' => 'arrows keyboard down-28' ),
					array( 'linea-arrows-keyboard-left' => 'arrows keyboard left' ),
					array( 'linea-arrows-keyboard-return' => 'arrows keyboard return' ),
					array( 'linea-arrows-keyboard-right' => 'arrows keyboard right' ),
					array( 'linea-arrows-keyboard-shift' => 'arrows keyboard shift' ),
					array( 'linea-arrows-keyboard-tab' => 'arrows keyboard tab' ),
					array( 'linea-arrows-keyboard-up' => 'arrows keyboard up' ),
					array( 'linea-arrows-left' => 'arrows left' ),
					array( 'linea-arrows-left-double-32' => 'arrows left double-32' ),
					array( 'linea-arrows-minus' => 'arrows minus' ),
					array( 'linea-arrows-move' => 'arrows move' ),
					array( 'linea-arrows-move2' => 'arrows move2' ),
					array( 'linea-arrows-move-bottom' => 'arrows move bottom' ),
					array( 'linea-arrows-move-left' => 'arrows move left' ),
					array( 'linea-arrows-move-right' => 'arrows move right' ),
					array( 'linea-arrows-move-top' => 'arrows move top' ),
					array( 'linea-arrows-plus' => 'arrows plus' ),
					array( 'linea-arrows-question' => 'arrows question' ),
					array( 'linea-arrows-remove' => 'arrows remove' ),
					array( 'linea-arrows-right' => 'arrows right' ),
					array( 'linea-arrows-right-double-31' => 'arrows right double-31' ),
					array( 'linea-arrows-rotate' => 'arrows rotate' ),
					array( 'linea-arrows-rotate-anti' => 'arrows rotate anti' ),
					array( 'linea-arrows-rotate-anti-dashed' => 'arrows rotate anti dashed' ),
					array( 'linea-arrows-rotate-dashed' => 'arrows rotate dashed' ),
					array( 'linea-arrows-shrink' => 'arrows shrink' ),
					array( 'linea-arrows-shrink-diagonal1' => 'arrows shrink diagonal1' ),
					array( 'linea-arrows-shrink-diagonal2' => 'arrows shrink diagonal2' ),
					array( 'linea-arrows-shrink-horizonal2' => 'arrows shrink horizonal2' ),
					array( 'linea-arrows-shrink-horizontal1' => 'arrows shrink horizontal1' ),
					array( 'linea-arrows-shrink-vertical1' => 'arrows shrink vertical1' ),
					array( 'linea-arrows-shrink-vertical2' => 'arrows shrink vertical2' ),
					array( 'linea-arrows-sign-down' => 'arrows sign down' ),
					array( 'linea-arrows-sign-left' => 'arrows sign left' ),
					array( 'linea-arrows-sign-right' => 'arrows sign right' ),
					array( 'linea-arrows-sign-up' => 'arrows sign up' ),
					array( 'linea-arrows-slide-down1' => 'arrows slide down1' ),
					array( 'linea-arrows-slide-down2' => 'arrows slide down2' ),
					array( 'linea-arrows-slide-left1' => 'arrows slide left1' ),
					array( 'linea-arrows-slide-left2' => 'arrows slide left2' ),
					array( 'linea-arrows-slide-right1' => 'arrows slide right1' ),
					array( 'linea-arrows-slide-right2' => 'arrows slide right2' ),
					array( 'linea-arrows-slide-up1' => 'arrows slide up1' ),
					array( 'linea-arrows-slide-up2' => 'arrows slide up2' ),
					array( 'linea-arrows-slim-down' => 'arrows slim down' ),
					array( 'linea-arrows-slim-down-dashed' => 'arrows slim down dashed' ),
					array( 'linea-arrows-slim-left' => 'arrows slim left' ),
					array( 'linea-arrows-slim-left-dashed' => 'arrows slim left dashed' ),
					array( 'linea-arrows-slim-right' => 'arrows slim right' ),
					array( 'linea-arrows-slim-right-dashed' => 'arrows slim right dashed' ),
					array( 'linea-arrows-slim-up' => 'arrows slim up' ),
					array( 'linea-arrows-slim-up-dashed' => 'arrows slim up dashed' ),
					array( 'linea-arrows-square-check' => 'arrows square check' ),
					array( 'linea-arrows-square-down' => 'arrows square down' ),
					array( 'linea-arrows-square-downleft' => 'arrows square downleft' ),
					array( 'linea-arrows-square-downright' => 'arrows square downright' ),
					array( 'linea-arrows-square-left' => 'arrows square left' ),
					array( 'linea-arrows-square-minus' => 'arrows square minus' ),
					array( 'linea-arrows-square-plus' => 'arrows square plus' ),
					array( 'linea-arrows-square-remove' => 'arrows square remove' ),
					array( 'linea-arrows-square-right' => 'arrows square right' ),
					array( 'linea-arrows-square-up' => 'arrows square up' ),
					array( 'linea-arrows-square-upleft' => 'arrows square upleft' ),
					array( 'linea-arrows-square-upright' => 'arrows square upright' ),
					array( 'linea-arrows-squares' => 'arrows squares' ),
					array( 'linea-arrows-stretch-diagonal1' => 'arrows stretch diagonal1' ),
					array( 'linea-arrows-stretch-diagonal2' => 'arrows stretch diagonal2' ),
					array( 'linea-arrows-stretch-diagonal3' => 'arrows stretch diagonal3' ),
					array( 'linea-arrows-stretch-diagonal4' => 'arrows stretch diagonal4' ),
					array( 'linea-arrows-stretch-horizontal1' => 'arrows stretch horizontal1' ),
					array( 'linea-arrows-stretch-horizontal2' => 'arrows stretch horizontal2' ),
					array( 'linea-arrows-stretch-vertical1' => 'arrows stretch vertical1' ),
					array( 'linea-arrows-stretch-vertical2' => 'arrows stretch vertical2' ),
					array( 'linea-arrows-switch-horizontal' => 'arrows switch horizontal' ),
					array( 'linea-arrows-switch-vertical' => 'arrows switch vertical' ),
					array( 'linea-arrows-up' => 'arrows up' ),
					array( 'linea-arrows-up-double' => 'arrows up double' ),
					array( 'linea-arrows-upright' => 'arrows upright' ),
					array( 'linea-arrows-vertical' => 'arrows vertical' ),
				),
				esc_html__( 'Basic', 'atomlab' )              => array(
					array( 'linea-basic-accelerator' => 'basic accelerator' ),
					array( 'linea-basic-alarm' => 'basic alarm' ),
					array( 'linea-basic-anchor' => 'basic anchor' ),
					array( 'linea-basic-anticlockwise' => 'basic anticlockwise' ),
					array( 'linea-basic-archive' => 'basic archive' ),
					array( 'linea-basic-archive-full' => 'basic archive full' ),
					array( 'linea-basic-ban' => 'basic ban' ),
					array( 'linea-basic-battery-charge' => 'basic battery charge' ),
					array( 'linea-basic-battery-empty' => 'basic battery empty' ),
					array( 'linea-basic-battery-full' => 'basic battery full' ),
					array( 'linea-basic-battery-half' => 'basic battery half' ),
					array( 'linea-basic-bolt' => 'basic bolt' ),
					array( 'linea-basic-book' => 'basic book' ),
					array( 'linea-basic-book-pen' => 'basic book pen' ),
					array( 'linea-basic-book-pencil' => 'basic book pencil' ),
					array( 'linea-basic-bookmark' => 'basic bookmark' ),
					array( 'linea-basic-calculator' => 'basic calculator' ),
					array( 'linea-basic-calendar' => 'basic calendar' ),
					array( 'linea-basic-cards-diamonds' => 'basic cards diamonds' ),
					array( 'linea-basic-cards-hearts' => 'basic cards hearts' ),
					array( 'linea-basic-case' => 'basic case' ),
					array( 'linea-basic-chronometer' => 'basic chronometer' ),
					array( 'linea-basic-clessidre' => 'basic clessidre' ),
					array( 'linea-basic-clock' => 'basic clock' ),
					array( 'linea-basic-clockwise' => 'basic clockwise' ),
					array( 'linea-basic-cloud' => 'basic cloud' ),
					array( 'linea-basic-clubs' => 'basic clubs' ),
					array( 'linea-basic-compass' => 'basic compass' ),
					array( 'linea-basic-cup' => 'basic cup' ),
					array( 'linea-basic-diamonds' => 'basic diamonds' ),
					array( 'linea-basic-display' => 'basic display' ),
					array( 'linea-basic-download' => 'basic download' ),
					array( 'linea-basic-exclamation' => 'basic exclamation' ),
					array( 'linea-basic-eye' => 'basic eye' ),
					array( 'linea-basic-eye-closed' => 'basic eye closed' ),
					array( 'linea-basic-female' => 'basic female' ),
					array( 'linea-basic-flag1' => 'basic flag1' ),
					array( 'linea-basic-flag2' => 'basic flag2' ),
					array( 'linea-basic-floppydisk' => 'basic floppydisk' ),
					array( 'linea-basic-folder' => 'basic folder' ),
					array( 'linea-basic-folder-multiple' => 'basic folder multiple' ),
					array( 'linea-basic-gear' => 'basic gear' ),
					array( 'linea-basic-geolocalize-01' => 'basic geolocalize-01' ),
					array( 'linea-basic-geolocalize-05' => 'basic geolocalize-05' ),
					array( 'linea-basic-globe' => 'basic globe' ),
					array( 'linea-basic-gunsight' => 'basic gunsight' ),
					array( 'linea-basic-hammer' => 'basic hammer' ),
					array( 'linea-basic-headset' => 'basic headset' ),
					array( 'linea-basic-heart' => 'basic heart' ),
					array( 'linea-basic-heart-broken' => 'basic heart broken' ),
					array( 'linea-basic-helm' => 'basic helm' ),
					array( 'linea-basic-home' => 'basic home' ),
					array( 'linea-basic-info' => 'basic info' ),
					array( 'linea-basic-ipod' => 'basic ipod' ),
					array( 'linea-basic-joypad' => 'basic joypad' ),
					array( 'linea-basic-key' => 'basic key' ),
					array( 'linea-basic-keyboard' => 'basic keyboard' ),
					array( 'linea-basic-laptop' => 'basic laptop' ),
					array( 'linea-basic-life-buoy' => 'basic life buoy' ),
					array( 'linea-basic-lightbulb' => 'basic lightbulb' ),
					array( 'linea-basic-link' => 'basic link' ),
					array( 'linea-basic-lock' => 'basic lock' ),
					array( 'linea-basic-lock-open' => 'basic lock open' ),
					array( 'linea-basic-magic-mouse' => 'basic magic mouse' ),
					array( 'linea-basic-magnifier' => 'basic magnifier' ),
					array( 'linea-basic-magnifier-minus' => 'basic magnifier minus' ),
					array( 'linea-basic-magnifier-plus' => 'basic magnifier plus' ),
					array( 'linea-basic-mail' => 'basic mail' ),
					array( 'linea-basic-mail-multiple' => 'basic mail multiple' ),
					array( 'linea-basic-mail-open' => 'basic mail open' ),
					array( 'linea-basic-mail-open-text' => 'basic mail open text' ),
					array( 'linea-basic-male' => 'basic male' ),
					array( 'linea-basic-map' => 'basic map' ),
					array( 'linea-basic-message' => 'basic message' ),
					array( 'linea-basic-message-multiple' => 'basic message multiple' ),
					array( 'linea-basic-message-txt' => 'basic message txt' ),
					array( 'linea-basic-mixer2' => 'basic mixer2' ),
					array( 'linea-basic-mouse' => 'basic mouse' ),
					array( 'linea-basic-notebook' => 'basic notebook' ),
					array( 'linea-basic-notebook-pen' => 'basic notebook pen' ),
					array( 'linea-basic-notebook-pencil' => 'basic notebook pencil' ),
					array( 'linea-basic-paperplane' => 'basic paperplane' ),
					array( 'linea-basic-pencil-ruler' => 'basic pencil ruler' ),
					array( 'linea-basic-pencil-ruler-pen' => 'basic pencil ruler pen' ),
					array( 'linea-basic-photo' => 'basic photo' ),
					array( 'linea-basic-picture' => 'basic picture' ),
					array( 'linea-basic-picture-multiple' => 'basic picture multiple' ),
					array( 'linea-basic-pin1' => 'basic pin1' ),
					array( 'linea-basic-pin2' => 'basic pin2' ),
					array( 'linea-basic-postcard' => 'basic postcard' ),
					array( 'linea-basic-postcard-multiple' => 'basic postcard multiple' ),
					array( 'linea-basic-printer' => 'basic printer' ),
					array( 'linea-basic-question' => 'basic question' ),
					array( 'linea-basic-rss' => 'basic rss' ),
					array( 'linea-basic-server' => 'basic server' ),
					array( 'linea-basic-server2' => 'basic server2' ),
					array( 'linea-basic-server-cloud' => 'basic server cloud' ),
					array( 'linea-basic-server-download' => 'basic server download' ),
					array( 'linea-basic-server-upload' => 'basic server upload' ),
					array( 'linea-basic-settings' => 'basic settings' ),
					array( 'linea-basic-share' => 'basic share' ),
					array( 'linea-basic-sheet' => 'basic sheet' ),
					array( 'linea-basic-sheet-multiple' => 'basic sheet multiple' ),
					array( 'linea-basic-sheet-pen' => 'basic sheet pen' ),
					array( 'linea-basic-sheet-pencil' => 'basic sheet pencil' ),
					array( 'linea-basic-sheet-txt' => 'basic sheet txt' ),
					array( 'linea-basic-signs' => 'basic signs' ),
					array( 'linea-basic-smartphone' => 'basic smartphone' ),
					array( 'linea-basic-spades' => 'basic spades' ),
					array( 'linea-basic-spread' => 'basic spread' ),
					array( 'linea-basic-spread-bookmark' => 'basic spread bookmark' ),
					array( 'linea-basic-spread-text' => 'basic spread text' ),
					array( 'linea-basic-spread-text-bookmark' => 'basic spread text bookmark' ),
					array( 'linea-basic-star' => 'basic star' ),
					array( 'linea-basic-tablet' => 'basic tablet' ),
					array( 'linea-basic-target' => 'basic target' ),
					array( 'linea-basic-todo' => 'basic todo' ),
					array( 'linea-basic-todo-pen' => 'basic todo pen' ),
					array( 'linea-basic-todo-pencil' => 'basic todo pencil' ),
					array( 'linea-basic-todo-txt' => 'basic todo txt' ),
					array( 'linea-basic-todolist-pen' => 'basic todolist pen' ),
					array( 'linea-basic-todolist-pencil' => 'basic todolist pencil' ),
					array( 'linea-basic-trashcan' => 'basic trashcan' ),
					array( 'linea-basic-trashcan-full' => 'basic trashcan full' ),
					array( 'linea-basic-trashcan-refresh' => 'basic trashcan refresh' ),
					array( 'linea-basic-trashcan-remove' => 'basic trashcan remove' ),
					array( 'linea-basic-upload' => 'basic upload' ),
					array( 'linea-basic-usb' => 'basic usb' ),
					array( 'linea-basic-video' => 'basic video' ),
					array( 'linea-basic-watch' => 'basic watch' ),
					array( 'linea-basic-webpage' => 'basic webpage' ),
					array( 'linea-basic-webpage-img-txt' => 'basic webpage img txt' ),
					array( 'linea-basic-webpage-multiple' => 'basic webpage multiple' ),
					array( 'linea-basic-webpage-txt' => 'basic webpage txt' ),
					array( 'linea-basic-world' => 'basic world' ),
				),
				esc_html__( 'Basic Elaboration', 'atomlab' )  => array(
					array( 'linea-basic-elaboration-bookmark-checck' => 'basic elaboration bookmark checck' ),
					array( 'linea-basic-elaboration-bookmark-minus' => 'basic elaboration bookmark minus' ),
					array( 'linea-basic-elaboration-bookmark-plus' => 'basic elaboration bookmark plus' ),
					array( 'linea-basic-elaboration-bookmark-remove' => 'basic elaboration bookmark remove' ),
					array( 'linea-basic-elaboration-briefcase-check' => 'basic elaboration briefcase check' ),
					array( 'linea-basic-elaboration-briefcase-download' => 'basic elaboration briefcase download' ),
					array( 'linea-basic-elaboration-briefcase-flagged' => 'basic elaboration briefcase flagged' ),
					array( 'linea-basic-elaboration-briefcase-minus' => 'basic elaboration briefcase minus' ),
					array( 'linea-basic-elaboration-briefcase-plus' => 'basic elaboration briefcase plus' ),
					array( 'linea-basic-elaboration-briefcase-refresh' => 'basic elaboration briefcase refresh' ),
					array( 'linea-basic-elaboration-briefcase-remove' => 'basic elaboration briefcase remove' ),
					array( 'linea-basic-elaboration-briefcase-search' => 'basic elaboration briefcase search' ),
					array( 'linea-basic-elaboration-briefcase-star' => 'basic elaboration briefcase star' ),
					array( 'linea-basic-elaboration-briefcase-upload' => 'basic elaboration briefcase upload' ),
					array( 'linea-basic-elaboration-browser-check' => 'basic elaboration browser check' ),
					array( 'linea-basic-elaboration-browser-download' => 'basic elaboration browser download' ),
					array( 'linea-basic-elaboration-browser-minus' => 'basic elaboration browser minus' ),
					array( 'linea-basic-elaboration-browser-plus' => 'basic elaboration browser plus' ),
					array( 'linea-basic-elaboration-browser-refresh' => 'basic elaboration browser refresh' ),
					array( 'linea-basic-elaboration-browser-remove' => 'basic elaboration browser remove' ),
					array( 'linea-basic-elaboration-browser-search' => 'basic elaboration browser search' ),
					array( 'linea-basic-elaboration-browser-star' => 'basic elaboration browser star' ),
					array( 'linea-basic-elaboration-browser-upload' => 'basic elaboration browser upload' ),
					array( 'linea-basic-elaboration-calendar-check' => 'basic elaboration calendar check' ),
					array( 'linea-basic-elaboration-calendar-cloud' => 'basic elaboration calendar cloud' ),
					array( 'linea-basic-elaboration-calendar-download' => 'basic elaboration calendar download' ),
					array( 'linea-basic-elaboration-calendar-empty' => 'basic elaboration calendar empty' ),
					array( 'linea-basic-elaboration-calendar-flagged' => 'basic elaboration calendar flagged' ),
					array( 'linea-basic-elaboration-calendar-heart' => 'basic elaboration calendar heart' ),
					array( 'linea-basic-elaboration-calendar-minus' => 'basic elaboration calendar minus' ),
					array( 'linea-basic-elaboration-calendar-next' => 'basic elaboration calendar next' ),
					array( 'linea-basic-elaboration-calendar-noaccess' => 'basic elaboration calendar noaccess' ),
					array( 'linea-basic-elaboration-calendar-pencil' => 'basic elaboration calendar pencil' ),
					array( 'linea-basic-elaboration-calendar-plus' => 'basic elaboration calendar plus' ),
					array( 'linea-basic-elaboration-calendar-previous' => 'basic elaboration calendar previous' ),
					array( 'linea-basic-elaboration-calendar-refresh' => 'basic elaboration calendar refresh' ),
					array( 'linea-basic-elaboration-calendar-remove' => 'basic elaboration calendar remove' ),
					array( 'linea-basic-elaboration-calendar-search' => 'basic elaboration calendar search' ),
					array( 'linea-basic-elaboration-calendar-star' => 'basic elaboration calendar star' ),
					array( 'linea-basic-elaboration-calendar-upload' => 'basic elaboration calendar upload' ),
					array( 'linea-basic-elaboration-cloud-check' => 'basic elaboration cloud check' ),
					array( 'linea-basic-elaboration-cloud-download' => 'basic elaboration cloud download' ),
					array( 'linea-basic-elaboration-cloud-minus' => 'basic elaboration cloud minus' ),
					array( 'linea-basic-elaboration-cloud-noaccess' => 'basic elaboration cloud noaccess' ),
					array( 'linea-basic-elaboration-cloud-plus' => 'basic elaboration cloud plus' ),
					array( 'linea-basic-elaboration-cloud-refresh' => 'basic elaboration cloud refresh' ),
					array( 'linea-basic-elaboration-cloud-remove' => 'basic elaboration cloud remove' ),
					array( 'linea-basic-elaboration-cloud-search' => 'basic elaboration cloud search' ),
					array( 'linea-basic-elaboration-cloud-upload' => 'basic elaboration cloud upload' ),
					array( 'linea-basic-elaboration-document-check' => 'basic elaboration document check' ),
					array( 'linea-basic-elaboration-document-cloud' => 'basic elaboration document cloud' ),
					array( 'linea-basic-elaboration-document-download' => 'basic elaboration document download' ),
					array( 'linea-basic-elaboration-document-flagged' => 'basic elaboration document flagged' ),
					array( 'linea-basic-elaboration-document-graph' => 'basic elaboration document graph' ),
					array( 'linea-basic-elaboration-document-heart' => 'basic elaboration document heart' ),
					array( 'linea-basic-elaboration-document-minus' => 'basic elaboration document minus' ),
					array( 'linea-basic-elaboration-document-next' => 'basic elaboration document next' ),
					array( 'linea-basic-elaboration-document-noaccess' => 'basic elaboration document noaccess' ),
					array( 'linea-basic-elaboration-document-note' => 'basic elaboration document note' ),
					array( 'linea-basic-elaboration-document-pencil' => 'basic elaboration document pencil' ),
					array( 'linea-basic-elaboration-document-picture' => 'basic elaboration document picture' ),
					array( 'linea-basic-elaboration-document-plus' => 'basic elaboration document plus' ),
					array( 'linea-basic-elaboration-document-previous' => 'basic elaboration document previous' ),
					array( 'linea-basic-elaboration-document-refresh' => 'basic elaboration document refresh' ),
					array( 'linea-basic-elaboration-document-remove' => 'basic elaboration document remove' ),
					array( 'linea-basic-elaboration-document-search' => 'basic elaboration document search' ),
					array( 'linea-basic-elaboration-document-star' => 'basic elaboration document star' ),
					array( 'linea-basic-elaboration-document-upload' => 'basic elaboration document upload' ),
					array( 'linea-basic-elaboration-folder-check' => 'basic elaboration folder check' ),
					array( 'linea-basic-elaboration-folder-cloud' => 'basic elaboration folder cloud' ),
					array( 'linea-basic-elaboration-folder-document' => 'basic elaboration folder document' ),
					array( 'linea-basic-elaboration-folder-download' => 'basic elaboration folder download' ),
					array( 'linea-basic-elaboration-folder-flagged' => 'basic elaboration folder flagged' ),
					array( 'linea-basic-elaboration-folder-graph' => 'basic elaboration folder graph' ),
					array( 'linea-basic-elaboration-folder-heart' => 'basic elaboration folder heart' ),
					array( 'linea-basic-elaboration-folder-minus' => 'basic elaboration folder minus' ),
					array( 'linea-basic-elaboration-folder-next' => 'basic elaboration folder next' ),
					array( 'linea-basic-elaboration-folder-noaccess' => 'basic elaboration folder noaccess' ),
					array( 'linea-basic-elaboration-folder-note' => 'basic elaboration folder note' ),
					array( 'linea-basic-elaboration-folder-pencil' => 'basic elaboration folder pencil' ),
					array( 'linea-basic-elaboration-folder-picture' => 'basic elaboration folder picture' ),
					array( 'linea-basic-elaboration-folder-plus' => 'basic elaboration folder plus' ),
					array( 'linea-basic-elaboration-folder-previous' => 'basic elaboration folder previous' ),
					array( 'linea-basic-elaboration-folder-refresh' => 'basic elaboration folder refresh' ),
					array( 'linea-basic-elaboration-folder-remove' => 'basic elaboration folder remove' ),
					array( 'linea-basic-elaboration-folder-search' => 'basic elaboration folder search' ),
					array( 'linea-basic-elaboration-folder-star' => 'basic elaboration folder star' ),
					array( 'linea-basic-elaboration-folder-upload' => 'basic elaboration folder upload' ),
					array( 'linea-basic-elaboration-mail-check' => 'basic elaboration mail check' ),
					array( 'linea-basic-elaboration-mail-cloud' => 'basic elaboration mail cloud' ),
					array( 'linea-basic-elaboration-mail-document' => 'basic elaboration mail document' ),
					array( 'linea-basic-elaboration-mail-download' => 'basic elaboration mail download' ),
					array( 'linea-basic-elaboration-mail-flagged' => 'basic elaboration mail flagged' ),
					array( 'linea-basic-elaboration-mail-heart' => 'basic elaboration mail heart' ),
					array( 'linea-basic-elaboration-mail-next' => 'basic elaboration mail next' ),
					array( 'linea-basic-elaboration-mail-noaccess' => 'basic elaboration mail noaccess' ),
					array( 'linea-basic-elaboration-mail-note' => 'basic elaboration mail note' ),
					array( 'linea-basic-elaboration-mail-pencil' => 'basic elaboration mail pencil' ),
					array( 'linea-basic-elaboration-mail-picture' => 'basic elaboration mail picture' ),
					array( 'linea-basic-elaboration-mail-previous' => 'basic elaboration mail previous' ),
					array( 'linea-basic-elaboration-mail-refresh' => 'basic elaboration mail refresh' ),
					array( 'linea-basic-elaboration-mail-remove' => 'basic elaboration mail remove' ),
					array( 'linea-basic-elaboration-mail-search' => 'basic elaboration mail search' ),
					array( 'linea-basic-elaboration-mail-star' => 'basic elaboration mail star' ),
					array( 'linea-basic-elaboration-mail-upload' => 'basic elaboration mail upload' ),
					array( 'linea-basic-elaboration-message-check' => 'basic elaboration message check' ),
					array( 'linea-basic-elaboration-message-dots' => 'basic elaboration message dots' ),
					array( 'linea-basic-elaboration-message-happy' => 'basic elaboration message happy' ),
					array( 'linea-basic-elaboration-message-heart' => 'basic elaboration message heart' ),
					array( 'linea-basic-elaboration-message-minus' => 'basic elaboration message minus' ),
					array( 'linea-basic-elaboration-message-note' => 'basic elaboration message note' ),
					array( 'linea-basic-elaboration-message-plus' => 'basic elaboration message plus' ),
					array( 'linea-basic-elaboration-message-refresh' => 'basic elaboration message refresh' ),
					array( 'linea-basic-elaboration-message-remove' => 'basic elaboration message remove' ),
					array( 'linea-basic-elaboration-message-sad' => 'basic elaboration message sad' ),
					array( 'linea-basic-elaboration-smartphone-cloud' => 'basic elaboration smartphone cloud' ),
					array( 'linea-basic-elaboration-smartphone-heart' => 'basic elaboration smartphone heart' ),
					array( 'linea-basic-elaboration-smartphone-noaccess' => 'basic elaboration smartphone noaccess' ),
					array( 'linea-basic-elaboration-smartphone-note' => 'basic elaboration smartphone note' ),
					array( 'linea-basic-elaboration-smartphone-pencil' => 'basic elaboration smartphone pencil' ),
					array( 'linea-basic-elaboration-smartphone-picture' => 'basic elaboration smartphone picture' ),
					array( 'linea-basic-elaboration-smartphone-refresh' => 'basic elaboration smartphone refresh' ),
					array( 'linea-basic-elaboration-smartphone-search' => 'basic elaboration smartphone search' ),
					array( 'linea-basic-elaboration-tablet-cloud' => 'basic elaboration tablet cloud' ),
					array( 'linea-basic-elaboration-tablet-heart' => 'basic elaboration tablet heart' ),
					array( 'linea-basic-elaboration-tablet-noaccess' => 'basic elaboration tablet noaccess' ),
					array( 'linea-basic-elaboration-tablet-note' => 'basic elaboration tablet note' ),
					array( 'linea-basic-elaboration-tablet-pencil' => 'basic elaboration tablet pencil' ),
					array( 'linea-basic-elaboration-tablet-picture' => 'basic elaboration tablet picture' ),
					array( 'linea-basic-elaboration-tablet-refresh' => 'basic elaboration tablet refresh' ),
					array( 'linea-basic-elaboration-tablet-search' => 'basic elaboration tablet search' ),
					array( 'linea-basic-elaboration-todolist-2' => 'basic elaboration todolist 2' ),
					array( 'linea-basic-elaboration-todolist-check' => 'basic elaboration todolist check' ),
					array( 'linea-basic-elaboration-todolist-cloud' => 'basic elaboration todolist cloud' ),
					array( 'linea-basic-elaboration-todolist-download' => 'basic elaboration todolist download' ),
					array( 'linea-basic-elaboration-todolist-flagged' => 'basic elaboration todolist flagged' ),
					array( 'linea-basic-elaboration-todolist-minus' => 'basic elaboration todolist minus' ),
					array( 'linea-basic-elaboration-todolist-noaccess' => 'basic elaboration todolist noaccess' ),
					array( 'linea-basic-elaboration-todolist-pencil' => 'basic elaboration todolist pencil' ),
					array( 'linea-basic-elaboration-todolist-plus' => 'basic elaboration todolist plus' ),
					array( 'linea-basic-elaboration-todolist-refresh' => 'basic elaboration todolist refresh' ),
					array( 'linea-basic-elaboration-todolist-remove' => 'basic elaboration todolist remove' ),
					array( 'linea-basic-elaboration-todolist-search' => 'basic elaboration todolist search' ),
					array( 'linea-basic-elaboration-todolist-star' => 'basic elaboration todolist star' ),
					array( 'linea-basic-elaboration-todolist-upload' => 'basic elaboration todolist upload' ),
				),
				esc_html__( 'Ecommerce', 'atomlab' )          => array(
					array( 'linea-ecommerce-bag' => 'ecommerce bag' ),
					array( 'linea-ecommerce-bag-check' => 'ecommerce bag check' ),
					array( 'linea-ecommerce-bag-cloud' => 'ecommerce bag cloud' ),
					array( 'linea-ecommerce-bag-download' => 'ecommerce bag download' ),
					array( 'linea-ecommerce-bag-minus' => 'ecommerce bag minus' ),
					array( 'linea-ecommerce-bag-plus' => 'ecommerce bag plus' ),
					array( 'linea-ecommerce-bag-refresh' => 'ecommerce bag refresh' ),
					array( 'linea-ecommerce-bag-remove' => 'ecommerce bag remove' ),
					array( 'linea-ecommerce-bag-search' => 'ecommerce bag search' ),
					array( 'linea-ecommerce-bag-upload' => 'ecommerce bag upload' ),
					array( 'linea-ecommerce-banknote' => 'ecommerce banknote' ),
					array( 'linea-ecommerce-banknotes' => 'ecommerce banknotes' ),
					array( 'linea-ecommerce-basket' => 'ecommerce basket' ),
					array( 'linea-ecommerce-basket-check' => 'ecommerce basket check' ),
					array( 'linea-ecommerce-basket-cloud' => 'ecommerce basket cloud' ),
					array( 'linea-ecommerce-basket-download' => 'ecommerce basket download' ),
					array( 'linea-ecommerce-basket-minus' => 'ecommerce basket minus' ),
					array( 'linea-ecommerce-basket-plus' => 'ecommerce basket plus' ),
					array( 'linea-ecommerce-basket-refresh' => 'ecommerce basket refresh' ),
					array( 'linea-ecommerce-basket-remove' => 'ecommerce basket remove' ),
					array( 'linea-ecommerce-basket-search' => 'ecommerce basket search' ),
					array( 'linea-ecommerce-basket-upload' => 'ecommerce basket upload' ),
					array( 'linea-ecommerce-bath' => 'ecommerce bath' ),
					array( 'linea-ecommerce-cart' => 'ecommerce cart' ),
					array( 'linea-ecommerce-cart-check' => 'ecommerce cart check' ),
					array( 'linea-ecommerce-cart-cloud' => 'ecommerce cart cloud' ),
					array( 'linea-ecommerce-cart-content' => 'ecommerce cart content' ),
					array( 'linea-ecommerce-cart-download' => 'ecommerce cart download' ),
					array( 'linea-ecommerce-cart-minus' => 'ecommerce cart minus' ),
					array( 'linea-ecommerce-cart-plus' => 'ecommerce cart plus' ),
					array( 'linea-ecommerce-cart-refresh' => 'ecommerce cart refresh' ),
					array( 'linea-ecommerce-cart-remove' => 'ecommerce cart remove' ),
					array( 'linea-ecommerce-cart-search' => 'ecommerce cart search' ),
					array( 'linea-ecommerce-cart-upload' => 'ecommerce cart upload' ),
					array( 'linea-ecommerce-cent' => 'ecommerce cent' ),
					array( 'linea-ecommerce-colon' => 'ecommerce colon' ),
					array( 'linea-ecommerce-creditcard' => 'ecommerce creditcard' ),
					array( 'linea-ecommerce-diamond' => 'ecommerce diamond' ),
					array( 'linea-ecommerce-dollar' => 'ecommerce dollar' ),
					array( 'linea-ecommerce-euro' => 'ecommerce euro' ),
					array( 'linea-ecommerce-franc' => 'ecommerce franc' ),
					array( 'linea-ecommerce-gift' => 'ecommerce gift' ),
					array( 'linea-ecommerce-graph1' => 'ecommerce graph1' ),
					array( 'linea-ecommerce-graph2' => 'ecommerce graph2' ),
					array( 'linea-ecommerce-graph3' => 'ecommerce graph3' ),
					array( 'linea-ecommerce-graph-decrease' => 'ecommerce graph decrease' ),
					array( 'linea-ecommerce-graph-increase' => 'ecommerce graph increase' ),
					array( 'linea-ecommerce-guarani' => 'ecommerce guarani' ),
					array( 'linea-ecommerce-kips' => 'ecommerce kips' ),
					array( 'linea-ecommerce-lira' => 'ecommerce lira' ),
					array( 'linea-ecommerce-megaphone' => 'ecommerce megaphone' ),
					array( 'linea-ecommerce-money' => 'ecommerce money' ),
					array( 'linea-ecommerce-naira' => 'ecommerce naira' ),
					array( 'linea-ecommerce-pesos' => 'ecommerce pesos' ),
					array( 'linea-ecommerce-pound' => 'ecommerce pound' ),
					array( 'linea-ecommerce-receipt' => 'ecommerce receipt' ),
					array( 'linea-ecommerce-receipt-bath' => 'ecommerce receipt bath' ),
					array( 'linea-ecommerce-receipt-cent' => 'ecommerce receipt cent' ),
					array( 'linea-ecommerce-receipt-dollar' => 'ecommerce receipt dollar' ),
					array( 'linea-ecommerce-receipt-euro' => 'ecommerce receipt euro' ),
					array( 'linea-ecommerce-receipt-franc' => 'ecommerce receipt franc' ),
					array( 'linea-ecommerce-receipt-guarani' => 'ecommerce receipt guarani' ),
					array( 'linea-ecommerce-receipt-kips' => 'ecommerce receipt kips' ),
					array( 'linea-ecommerce-receipt-lira' => 'ecommerce receipt lira' ),
					array( 'linea-ecommerce-receipt-naira' => 'ecommerce receipt naira' ),
					array( 'linea-ecommerce-receipt-pesos' => 'ecommerce receipt pesos' ),
					array( 'linea-ecommerce-receipt-pound' => 'ecommerce receipt pound' ),
					array( 'linea-ecommerce-receipt-rublo' => 'ecommerce receipt rublo' ),
					array( 'linea-ecommerce-receipt-rupee' => 'ecommerce receipt rupee' ),
					array( 'linea-ecommerce-receipt-tugrik' => 'ecommerce receipt tugrik' ),
					array( 'linea-ecommerce-receipt-won' => 'ecommerce receipt won' ),
					array( 'linea-ecommerce-receipt-yen' => 'ecommerce receipt yen' ),
					array( 'linea-ecommerce-receipt-yen2' => 'ecommerce receipt yen2' ),
					array( 'linea-ecommerce-recept-colon' => 'ecommerce recept colon' ),
					array( 'linea-ecommerce-rublo' => 'ecommerce rublo' ),
					array( 'linea-ecommerce-rupee' => 'ecommerce rupee' ),
					array( 'linea-ecommerce-safe' => 'ecommerce safe' ),
					array( 'linea-ecommerce-sale' => 'ecommerce sale' ),
					array( 'linea-ecommerce-sales' => 'ecommerce sales' ),
					array( 'linea-ecommerce-ticket' => 'ecommerce ticket' ),
					array( 'linea-ecommerce-tugriks' => 'ecommerce tugriks' ),
					array( 'linea-ecommerce-wallet' => 'ecommerce wallet' ),
					array( 'linea-ecommerce-won' => 'ecommerce won' ),
					array( 'linea-ecommerce-yen' => 'ecommerce yen' ),
					array( 'linea-ecommerce-yen2' => 'ecommerce yen2' ),
				),
				esc_html__( 'Music', 'atomlab' )              => array(
					array( 'linea-music-beginning-button' => 'music beginning button' ),
					array( 'linea-music-bell' => 'music bell' ),
					array( 'linea-music-cd' => 'music cd' ),
					array( 'linea-music-diapason' => 'music diapason' ),
					array( 'linea-music-eject-button' => 'music eject button' ),
					array( 'linea-music-end-button' => 'music end button' ),
					array( 'linea-music-fastforward-button' => 'music fastforward button' ),
					array( 'linea-music-headphones' => 'music headphones' ),
					array( 'linea-music-ipod' => 'music ipod' ),
					array( 'linea-music-loudspeaker' => 'music loudspeaker' ),
					array( 'linea-music-microphone' => 'music microphone' ),
					array( 'linea-music-microphone-old' => 'music microphone old' ),
					array( 'linea-music-mixer' => 'music mixer' ),
					array( 'linea-music-mute' => 'music mute' ),
					array( 'linea-music-note-multiple' => 'music note multiple' ),
					array( 'linea-music-note-single' => 'music note single' ),
					array( 'linea-music-pause-button' => 'music pause button' ),
					array( 'linea-music-play-button' => 'music play button' ),
					array( 'linea-music-playlist' => 'music playlist' ),
					array( 'linea-music-radio-ghettoblaster' => 'music radio ghettoblaster' ),
					array( 'linea-music-radio-portable' => 'music radio portable' ),
					array( 'linea-music-record' => 'music record' ),
					array( 'linea-music-recordplayer' => 'music recordplayer' ),
					array( 'linea-music-repeat-button' => 'music repeat button' ),
					array( 'linea-music-rewind-button' => 'music rewind button' ),
					array( 'linea-music-shuffle-button' => 'music shuffle button' ),
					array( 'linea-music-stop-button' => 'music stop button' ),
					array( 'linea-music-tape' => 'music tape' ),
					array( 'linea-music-volume-down' => 'music volume down' ),
					array( 'linea-music-volume-up' => 'music volume up' ),
				),
				esc_html__( 'Software', 'atomlab' )           => array(
					array( 'linea-software-add-vectorpoint' => 'software add vectorpoint' ),
					array( 'linea-software-box-oval' => 'software box oval' ),
					array( 'linea-software-box-polygon' => 'software box polygon' ),
					array( 'linea-software-box-rectangle' => 'software box rectangle' ),
					array( 'linea-software-box-roundedrectangle' => 'software box roundedrectangle' ),
					array( 'linea-software-character' => 'software character' ),
					array( 'linea-software-crop' => 'software crop' ),
					array( 'linea-software-eyedropper' => 'software eyedropper' ),
					array( 'linea-software-font-allcaps' => 'software font allcaps' ),
					array( 'linea-software-font-baseline-shift' => 'software font baseline shift' ),
					array( 'linea-software-font-horizontal-scale' => 'software font horizontal scale' ),
					array( 'linea-software-font-kerning' => 'software font kerning' ),
					array( 'linea-software-font-leading' => 'software font leading' ),
					array( 'linea-software-font-size' => 'software font size' ),
					array( 'linea-software-font-smallcapital' => 'software font smallcapital' ),
					array( 'linea-software-font-smallcaps' => 'software font smallcaps' ),
					array( 'linea-software-font-strikethrough' => 'software font strikethrough' ),
					array( 'linea-software-font-tracking' => 'software font tracking' ),
					array( 'linea-software-font-underline' => 'software font underline' ),
					array( 'linea-software-font-vertical-scale' => 'software font vertical scale' ),
					array( 'linea-software-horizontal-align-center' => 'software horizontal align center' ),
					array( 'linea-software-horizontal-align-left' => 'software horizontal align left' ),
					array( 'linea-software-horizontal-align-right' => 'software horizontal align right' ),
					array( 'linea-software-horizontal-distribute-center' => 'software horizontal distribute center' ),
					array( 'linea-software-horizontal-distribute-left' => 'software horizontal distribute left' ),
					array( 'linea-software-horizontal-distribute-right' => 'software horizontal distribute right' ),
					array( 'linea-software-indent-firstline' => 'software indent firstline' ),
					array( 'linea-software-indent-left' => 'software indent left' ),
					array( 'linea-software-indent-right' => 'software indent right' ),
					array( 'linea-software-lasso' => 'software lasso' ),
					array( 'linea-software-layers1' => 'software layers1' ),
					array( 'linea-software-layers2' => 'software layers2' ),
					array( 'linea-software-layout-8boxes' => 'software layout-8boxes' ),
					array( 'linea-software-layout' => 'software layout' ),
					array( 'linea-software-layout-2columns' => 'software layout 2columns' ),
					array( 'linea-software-layout-3columns' => 'software layout 3columns' ),
					array( 'linea-software-layout-4boxes' => 'software layout 4boxes' ),
					array( 'linea-software-layout-4columns' => 'software layout 4columns' ),
					array( 'linea-software-layout-4lines' => 'software layout 4lines' ),
					array( 'linea-software-layout-header' => 'software layout header' ),
					array( 'linea-software-layout-header-2columns' => 'software layout header 2columns' ),
					array( 'linea-software-layout-header-3columns' => 'software layout header 3columns' ),
					array( 'linea-software-layout-header-4boxes' => 'software layout header 4boxes' ),
					array( 'linea-software-layout-header-4columns' => 'software layout header 4columns' ),
					array( 'linea-software-layout-header-complex' => 'software layout header complex' ),
					array( 'linea-software-layout-header-complex2' => 'software layout header complex2' ),
					array( 'linea-software-layout-header-complex3' => 'software layout header complex3' ),
					array( 'linea-software-layout-header-complex4' => 'software layout header complex4' ),
					array( 'linea-software-layout-header-sideleft' => 'software layout header sideleft' ),
					array( 'linea-software-layout-header-sideright' => 'software layout header sideright' ),
					array( 'linea-software-layout-sidebar-left' => 'software layout sidebar left' ),
					array( 'linea-software-layout-sidebar-right' => 'software layout sidebar right' ),
					array( 'linea-software-magnete' => 'software magnete' ),
					array( 'linea-software-pages' => 'software pages' ),
					array( 'linea-software-paintbrush' => 'software paintbrush' ),
					array( 'linea-software-paintbucket' => 'software paintbucket' ),
					array( 'linea-software-paintroller' => 'software paintroller' ),
					array( 'linea-software-paragraph' => 'software paragraph' ),
					array( 'linea-software-paragraph-align-left' => 'software paragraph align left' ),
					array( 'linea-software-paragraph-align-right' => 'software paragraph align right' ),
					array( 'linea-software-paragraph-center' => 'software paragraph center' ),
					array( 'linea-software-paragraph-justify-all' => 'software paragraph justify all' ),
					array( 'linea-software-paragraph-justify-center' => 'software paragraph justify center' ),
					array( 'linea-software-paragraph-justify-left' => 'software paragraph justify left' ),
					array( 'linea-software-paragraph-justify-right' => 'software paragraph justify right' ),
					array( 'linea-software-paragraph-space-after' => 'software paragraph space after' ),
					array( 'linea-software-paragraph-space-before' => 'software paragraph space before' ),
					array( 'linea-software-pathfinder-exclude' => 'software pathfinder exclude' ),
					array( 'linea-software-pathfinder-intersect' => 'software pathfinder intersect' ),
					array( 'linea-software-pathfinder-subtract' => 'software pathfinder subtract' ),
					array( 'linea-software-pathfinder-unite' => 'software pathfinder unite' ),
					array( 'linea-software-pen' => 'software pen' ),
					array( 'linea-software-pen-add' => 'software pen add' ),
					array( 'linea-software-pen-remove' => 'software pen remove' ),
					array( 'linea-software-pencil' => 'software pencil' ),
					array( 'linea-software-polygonallasso' => 'software polygonallasso' ),
					array( 'linea-software-reflect-horizontal' => 'software reflect horizontal' ),
					array( 'linea-software-reflect-vertical' => 'software reflect vertical' ),
					array( 'linea-software-remove-vectorpoint' => 'software remove vectorpoint' ),
					array( 'linea-software-scale-expand' => 'software scale expand' ),
					array( 'linea-software-scale-reduce' => 'software scale reduce' ),
					array( 'linea-software-selection-oval' => 'software selection oval' ),
					array( 'linea-software-selection-polygon' => 'software selection polygon' ),
					array( 'linea-software-selection-rectangle' => 'software selection rectangle' ),
					array( 'linea-software-selection-roundedrectangle' => 'software selection roundedrectangle' ),
					array( 'linea-software-shape-oval' => 'software shape oval' ),
					array( 'linea-software-shape-polygon' => 'software shape polygon' ),
					array( 'linea-software-shape-rectangle' => 'software shape rectangle' ),
					array( 'linea-software-shape-roundedrectangle' => 'software shape roundedrectangle' ),
					array( 'linea-software-slice' => 'software slice' ),
					array( 'linea-software-transform-bezier' => 'software transform bezier' ),
					array( 'linea-software-vector-box' => 'software vector box' ),
					array( 'linea-software-vector-composite' => 'software vector composite' ),
					array( 'linea-software-vector-line' => 'software vector line' ),
					array( 'linea-software-vertical-align-bottom' => 'software vertical align bottom' ),
					array( 'linea-software-vertical-align-center' => 'software vertical align center' ),
					array( 'linea-software-vertical-align-top' => 'software vertical align top' ),
					array( 'linea-software-vertical-distribute-bottom' => 'software vertical distribute bottom' ),
					array( 'linea-software-vertical-distribute-center' => 'software vertical distribute center' ),
					array( 'linea-software-vertical-distribute-top' => 'software vertical distribute top' ),
				),
				esc_html__( 'Weather', 'atomlab' )            => array(
					array( 'linea-weather-aquarius' => 'weather aquarius' ),
					array( 'linea-weather-aries' => 'weather aries' ),
					array( 'linea-weather-cancer' => 'weather cancer' ),
					array( 'linea-weather-capricorn' => 'weather capricorn' ),
					array( 'linea-weather-cloud' => 'weather cloud' ),
					array( 'linea-weather-cloud-drop' => 'weather cloud drop' ),
					array( 'linea-weather-cloud-lightning' => 'weather cloud lightning' ),
					array( 'linea-weather-cloud-snowflake' => 'weather cloud snowflake' ),
					array( 'linea-weather-downpour-fullmoon' => 'weather downpour fullmoon' ),
					array( 'linea-weather-downpour-halfmoon' => 'weather downpour halfmoon' ),
					array( 'linea-weather-downpour-sun' => 'weather downpour sun' ),
					array( 'linea-weather-drop' => 'weather drop' ),
					array( 'linea-weather-first-quarter' => 'weather first quarter' ),
					array( 'linea-weather-fog' => 'weather fog' ),
					array( 'linea-weather-fog-fullmoon' => 'weather fog fullmoon' ),
					array( 'linea-weather-fog-halfmoon' => 'weather fog halfmoon' ),
					array( 'linea-weather-fog-sun' => 'weather fog sun' ),
					array( 'linea-weather-fullmoon' => 'weather fullmoon' ),
					array( 'linea-weather-gemini' => 'weather gemini' ),
					array( 'linea-weather-hail' => 'weather hail' ),
					array( 'linea-weather-hail-fullmoon' => 'weather hail fullmoon' ),
					array( 'linea-weather-hail-halfmoon' => 'weather hail halfmoon' ),
					array( 'linea-weather-hail-sun' => 'weather hail sun' ),
					array( 'linea-weather-last-quarter' => 'weather last quarter' ),
					array( 'linea-weather-leo' => 'weather leo' ),
					array( 'linea-weather-libra' => 'weather libra' ),
					array( 'linea-weather-lightning' => 'weather lightning' ),
					array( 'linea-weather-mistyrain' => 'weather mistyrain' ),
					array( 'linea-weather-mistyrain-fullmoon' => 'weather mistyrain fullmoon' ),
					array( 'linea-weather-mistyrain-halfmoon' => 'weather mistyrain halfmoon' ),
					array( 'linea-weather-mistyrain-sun' => 'weather mistyrain sun' ),
					array( 'linea-weather-moon' => 'weather moon' ),
					array( 'linea-weather-moondown-full' => 'weather moondown full' ),
					array( 'linea-weather-moondown-half' => 'weather moondown half' ),
					array( 'linea-weather-moonset-full' => 'weather moonset full' ),
					array( 'linea-weather-moonset-half' => 'weather moonset half' ),
					array( 'linea-weather-move2' => 'weather move2' ),
					array( 'linea-weather-newmoon' => 'weather newmoon' ),
					array( 'linea-weather-pisces' => 'weather pisces' ),
					array( 'linea-weather-rain' => 'weather rain' ),
					array( 'linea-weather-rain-fullmoon' => 'weather rain fullmoon' ),
					array( 'linea-weather-rain-halfmoon' => 'weather rain halfmoon' ),
					array( 'linea-weather-rain-sun' => 'weather rain sun' ),
					array( 'linea-weather-sagittarius' => 'weather sagittarius' ),
					array( 'linea-weather-scorpio' => 'weather scorpio' ),
					array( 'linea-weather-snow' => 'weather snow' ),
					array( 'linea-weather-snow-fullmoon' => 'weather snow fullmoon' ),
					array( 'linea-weather-snow-halfmoon' => 'weather snow halfmoon' ),
					array( 'linea-weather-snow-sun' => 'weather snow sun' ),
					array( 'linea-weather-snowflake' => 'weather snowflake' ),
					array( 'linea-weather-star' => 'weather star' ),
					array( 'linea-weather-storm-11' => 'weather storm-11' ),
					array( 'linea-weather-storm-32' => 'weather storm-32' ),
					array( 'linea-weather-storm-fullmoon' => 'weather storm fullmoon' ),
					array( 'linea-weather-storm-halfmoon' => 'weather storm halfmoon' ),
					array( 'linea-weather-storm-sun' => 'weather storm sun' ),
					array( 'linea-weather-sun' => 'weather sun' ),
					array( 'linea-weather-sundown' => 'weather sundown' ),
					array( 'linea-weather-sunset' => 'weather sunset' ),
					array( 'linea-weather-taurus' => 'weather taurus' ),
					array( 'linea-weather-tempest' => 'weather tempest' ),
					array( 'linea-weather-tempest-fullmoon' => 'weather tempest fullmoon' ),
					array( 'linea-weather-tempest-halfmoon' => 'weather tempest halfmoon' ),
					array( 'linea-weather-tempest-sun' => 'weather tempest sun' ),
					array( 'linea-weather-variable-fullmoon' => 'weather variable fullmoon' ),
					array( 'linea-weather-variable-halfmoon' => 'weather variable halfmoon' ),
					array( 'linea-weather-variable-sun' => 'weather variable sun' ),
					array( 'linea-weather-virgo' => 'weather virgo' ),
					array( 'linea-weather-waning-cresent' => 'weather waning cresent' ),
					array( 'linea-weather-waning-gibbous' => 'weather waning gibbous' ),
					array( 'linea-weather-waxing-cresent' => 'weather waxing cresent' ),
					array( 'linea-weather-waxing-gibbous' => 'weather waxing gibbous' ),
					array( 'linea-weather-wind' => 'weather wind' ),
					array( 'linea-weather-wind-E' => 'weather wind E' ),
					array( 'linea-weather-wind-N' => 'weather wind N' ),
					array( 'linea-weather-wind-NE' => 'weather wind NE' ),
					array( 'linea-weather-wind-NW' => 'weather wind NW' ),
					array( 'linea-weather-wind-S' => 'weather wind S' ),
					array( 'linea-weather-wind-SE' => 'weather wind SE' ),
					array( 'linea-weather-wind-SW' => 'weather wind SW' ),
					array( 'linea-weather-wind-W' => 'weather wind W' ),
					array( 'linea-weather-wind-fullmoon' => 'weather wind fullmoon' ),
					array( 'linea-weather-wind-halfmoon' => 'weather wind halfmoon' ),
					array( 'linea-weather-wind-sun' => 'weather wind sun' ),
					array( 'linea-weather-windgust' => 'weather windgust' ),
				),
			);

			return array_merge( $icons, $new_icons );
		}
	}

	new Atomlab_VC_Icon_Linea_SVG();
}
