<?php
$styling_tab   = esc_html__( 'Styling', 'atomlab' );
$separator_tab = esc_html__( 'Separator', 'atomlab' );
$onepage_tab   = esc_html__( 'Onepage Scroll Options', 'atomlab' );

vc_remove_param( 'vc_row', 'css' );
vc_remove_param( 'vc_row', 'gap' );

vc_add_params( 'vc_row', array_merge( Atomlab_VC::get_vc_spacing_tab(), array(
	array(
		'heading'     => esc_html__( 'Layer Index', 'atomlab' ),
		'description' => esc_html__( 'When content in row or row has negative margin then this controls layer ( z-index ) of row', 'atomlab' ),
		'type'        => 'number',
		'param_name'  => 'layer_index',
		'min'         => 0,
		'max'         => 100,
		'step'        => 1,
	),
	array(
		'heading'     => esc_html__( 'Gutter', 'atomlab' ),
		'type'        => 'number_responsive',
		'param_name'  => 'gutter',
		'min'         => 0,
		'max'         => 100,
		'step'        => 2,
		'suffix'      => 'px',
		'media_query' => array(
			'lg' => '',
			'md' => '',
			'sm' => '',
			'xs' => '',
		),
	),
	array(
		'heading'    => esc_html__( 'Column Separator', 'atomlab' ),
		'type'       => 'dropdown',
		'param_name' => 'column_separator',
		'value'      => array(
			esc_html__( 'None', 'atomlab' )     => '',
			esc_html__( 'Style 01', 'atomlab' ) => '01',

		),
		'std'        => '',
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Border Radius', 'atomlab' ),
		'description' => esc_html__( 'Ex: 5px or 50%', 'atomlab' ),
		'type'        => 'textfield',
		'param_name'  => 'border_radius',
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Box Shadow', 'atomlab' ),
		'description' => esc_html__( 'Ex: 0 20px 30px #ccc', 'atomlab' ),
		'type'        => 'textfield',
		'param_name'  => 'box_shadow',
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Row Effect', 'atomlab' ),
		'type'       => 'dropdown',
		'param_name' => 'effect',
		'value'      => array(
			esc_html__( 'None', 'atomlab' )    => '',
			esc_html__( 'Firefly', 'atomlab' ) => 'firefly',
			esc_html__( 'Wavify', 'atomlab' )  => 'wavify',
		),
		'std'        => '',
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Wavify Height', 'atomlab' ),
		'type'        => 'number_responsive',
		'param_name'  => 'wavify_height',
		'step'        => 1,
		'suffix'      => 'px',
		'media_query' => array(
			'lg' => 400,
			'md' => '',
			'sm' => '',
			'xs' => '',
		),
		'dependency'  => array(
			'element' => 'effect',
			'value'   => array( 'wavify' ),
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Wavify Items', 'atomlab' ),
		'type'       => 'param_group',
		'param_name' => 'wavify_items',
		'params'     => array_merge( array(
			array(
				'heading'     => esc_html__( 'Height', 'atomlab' ),
				'type'        => 'textfield',
				'param_name'  => 'height',
				'admin_label' => true,
				'value'       => 400,
				'min'         => 0,
				'max'         => 1000,
				'step'        => 10,
				'std'         => 400,
				'suffix'      => 'px',
			),
			array(
				'heading'    => esc_html__( 'Amplitude', 'atomlab' ),
				'type'       => 'number',
				'param_name' => 'amplitude',
				'value'      => 200,
				'min'        => 0,
				'max'        => 1000,
				'step'       => 10,
				'std'        => 200,
				'suffix'     => 'px',
			),
			array(
				'heading'    => esc_html__( 'Bones', 'atomlab' ),
				'type'       => 'number',
				'param_name' => 'bones',
				'value'      => 4,
				'min'        => 0,
				'max'        => 10,
				'step'       => 1,
				'std'        => 4,
			),
			array(
				'heading'    => esc_html__( 'Background', 'atomlab' ),
				'type'       => 'colorpicker',
				'param_name' => 'background',
			),
		) ),
		'dependency' => array(
			'element' => 'effect',
			'value'   => array( 'wavify' ),
		),
	),
	array(
		'group'            => $styling_tab,
		'heading'          => esc_html__( 'Firefly Color', 'atomlab' ),
		'type'             => 'colorpicker',
		'param_name'       => 'firefly_color',
		'dependency'       => array(
			'element' => 'effect',
			'value'   => array( 'firefly' ),
		),
		'std'              => '#fff',
		'edit_field_class' => 'vc_col-sm-3',
	),
	array(
		'group'            => $styling_tab,
		'heading'          => esc_html__( 'Firely Total', 'atomlab' ),
		'type'             => 'number',
		'param_name'       => 'firefly_total',
		'value'            => 100,
		'min'              => 0,
		'max'              => 100,
		'step'             => 1,
		'suffix'           => '%',
		'std'              => 30,
		'dependency'       => array(
			'element' => 'effect',
			'value'   => array( 'firefly' ),
		),
		'edit_field_class' => 'vc_col-sm-3',
	),
	array(
		'group'            => $styling_tab,
		'heading'          => esc_html__( 'Firely Min Width', 'atomlab' ),
		'type'             => 'number',
		'param_name'       => 'firefly_min_size',
		'value'            => 100,
		'min'              => 0,
		'max'              => 100,
		'step'             => 1,
		'suffix'           => '%',
		'std'              => 1,
		'dependency'       => array(
			'element' => 'effect',
			'value'   => array( 'firefly' ),
		),
		'edit_field_class' => 'vc_col-sm-3',
	),
	array(
		'group'            => $styling_tab,
		'heading'          => esc_html__( 'Firely Max Width', 'atomlab' ),
		'type'             => 'number',
		'param_name'       => 'firefly_max_size',
		'value'            => 100,
		'min'              => 0,
		'max'              => 100,
		'step'             => 1,
		'suffix'           => '%',
		'std'              => 3,
		'dependency'       => array(
			'element' => 'effect',
			'value'   => array( 'firefly' ),
		),
		'edit_field_class' => 'vc_col-sm-3',
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Color', 'atomlab' ),
		'type'       => 'dropdown',
		'param_name' => 'background_color',
		'value'      => array(
			esc_html__( 'None', 'atomlab' )            => '',
			esc_html__( 'Primary Color', 'atomlab' )   => 'primary',
			esc_html__( 'Secondary Color', 'atomlab' ) => 'secondary',
			esc_html__( 'Custom Color', 'atomlab' )    => 'custom',
			esc_html__( 'Gradient Color', 'atomlab' )  => 'gradient',
		),
		'std'        => '',
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Custom Background Color', 'atomlab' ),
		'type'       => 'colorpicker',
		'param_name' => 'custom_background_color',
		'dependency' => array(
			'element' => 'background_color',
			'value'   => array( 'custom' ),
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Gradient', 'atomlab' ),
		'type'       => 'gradient',
		'param_name' => 'background_gradient',
		'dependency' => array(
			'element' => 'background_color',
			'value'   => array( 'gradient' ),
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Image', 'atomlab' ),
		'type'       => 'attach_image',
		'param_name' => 'background_image',
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Hide Background Image', 'atomlab' ),
		'type'       => 'dropdown',
		'param_name' => 'hide_background_image',
		'value'      => array(
			esc_html__( 'Always show', 'atomlab' )             => '',
			esc_html__( 'Medium Device Down', 'atomlab' )      => 'md',
			esc_html__( 'Small Device Down', 'atomlab' )       => 'sm',
			esc_html__( 'Extra Small Device Down', 'atomlab' ) => 'xs',
		),
		'std'        => '',
		'dependency' => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Repeat', 'atomlab' ),
		'type'       => 'dropdown',
		'param_name' => 'background_repeat',
		'value'      => array(
			esc_html__( 'No repeat', 'atomlab' )         => 'no-repeat',
			esc_html__( 'Tile', 'atomlab' )              => 'repeat',
			esc_html__( 'Tile Horizontally', 'atomlab' ) => 'repeat-x',
			esc_html__( 'Tile Vertically', 'atomlab' )   => 'repeat-y',
		),
		'std'        => 'no-repeat',
		'dependency' => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Size', 'atomlab' ),
		'type'       => 'dropdown',
		'param_name' => 'background_size',
		'value'      => array(
			esc_html__( 'Auto', 'atomlab' )    => 'auto',
			esc_html__( 'Cover', 'atomlab' )   => 'cover',
			esc_html__( 'Contain', 'atomlab' ) => 'contain',
			esc_html__( 'Manual', 'atomlab' )  => 'manual',
		),
		'std'        => 'cover',
		'dependency' => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Background Size (Manual Setting)', 'atomlab' ),
		'description' => esc_html__( 'Ex: 50% 100%', 'atomlab' ),
		'type'        => 'textfield',
		'param_name'  => 'background_size_manual',
		'dependency'  => array(
			'element' => 'background_size',
			'value'   => 'manual',
		),
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Background Position', 'atomlab' ),
		'description' => esc_html__( 'Ex: left center', 'atomlab' ),
		'type'        => 'textfield',
		'param_name'  => 'background_position',
		'dependency'  => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Scroll Effect', 'atomlab' ),
		'type'       => 'dropdown',
		'param_name' => 'background_attachment',
		'value'      => array(
			esc_html__( 'Move with the content', 'atomlab' ) => 'scroll',
			esc_html__( 'Fixed at its position', 'atomlab' ) => 'fixed',
			esc_html__( 'Marque', 'atomlab' )                => 'marque',
		),
		'std'        => 'scroll',
		'dependency' => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Marque Direction', 'atomlab' ),
		'type'       => 'dropdown',
		'param_name' => 'marque_direction',
		'value'      => array(
			esc_html__( 'To Left', 'atomlab' )  => 'to-left',
			esc_html__( 'To Right', 'atomlab' ) => 'to-right',
		),
		'std'        => 'to-right',
		'dependency' => array(
			'element' => 'background_attachment',
			'value'   => 'marque',
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Marque Pause On Hover.', 'atomlab' ),
		'type'       => 'checkbox',
		'param_name' => 'marque_pause_on_hover',
		'value'      => array(
			esc_html__( 'Yes', 'atomlab' ) => '1',
		),
		'dependency' => array(
			'element' => 'background_attachment',
			'value'   => 'marque',
		),
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Background Overlay', 'atomlab' ),
		'description' => esc_html__( 'Choose an overlay background color.', 'atomlab' ),
		'type'        => 'dropdown',
		'param_name'  => 'overlay_background',
		'value'       => array(
			esc_html__( 'None', 'atomlab' )            => '',
			esc_html__( 'Primary Color', 'atomlab' )   => 'primary',
			esc_html__( 'Secondary Color', 'atomlab' ) => 'secondary',
			esc_html__( 'Custom Color', 'atomlab' )    => 'overlay_custom_background',
		),
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Custom Background Overlay', 'atomlab' ),
		'description' => esc_html__( 'Choose an custom background color overlay.', 'atomlab' ),
		'type'        => 'colorpicker',
		'param_name'  => 'overlay_custom_background',
		'std'         => '#000000',
		'dependency'  => array(
			'element' => 'overlay_background',
			'value'   => array( 'overlay_custom_background' ),
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Opacity', 'atomlab' ),
		'type'       => 'number',
		'param_name' => 'overlay_opacity',
		'value'      => 100,
		'min'        => 0,
		'max'        => 100,
		'step'       => 1,
		'suffix'     => '%',
		'std'        => 80,
		'dependency' => array(
			'element'   => 'overlay_background',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $separator_tab,
		'heading'    => esc_html__( 'Type', 'atomlab' ),
		'type'       => 'dropdown',
		'param_name' => 'separator_type',
		'value'      => array(
			esc_html__( 'None', 'atomlab' )               => '',
			esc_html__( 'Circle', 'atomlab' )             => 'circle',
			esc_html__( 'Curve', 'atomlab' )              => 'curve',
			esc_html__( 'Clouds', 'atomlab' )             => 'clouds',
			esc_html__( 'Waves', 'atomlab' )              => 'waves',
			esc_html__( 'Tilt Left', 'atomlab' )          => 'tilt_left',
			esc_html__( 'Tilt Right', 'atomlab' )         => 'tilt_right',
			esc_html__( 'Triangle', 'atomlab' )           => 'triangle',
			esc_html__( 'Big Triangle', 'atomlab' )       => 'big_triangle',
			esc_html__( 'Big Triangle Alt', 'atomlab' )   => 'big_triangle_alt',
			esc_html__( 'Big Triangle Left', 'atomlab' )  => 'big_triangle_left',
			esc_html__( 'Big Triangle Right', 'atomlab' ) => 'big_triangle_right',
		),
		'std'        => '',
	),
	array(
		'group'       => $separator_tab,
		'heading'     => esc_html__( 'Height', 'atomlab' ),
		'type'        => 'number_responsive',
		'param_name'  => 'separator_height',
		'step'        => 1,
		'suffix'      => 'px',
		'media_query' => array(
			'lg' => 100,
			'md' => '',
			'sm' => '',
			'xs' => '',
		),
		'dependency'  => array(
			'element'   => 'separator_type',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $separator_tab,
		'heading'    => esc_html__( 'Position', 'atomlab' ),
		'type'       => 'dropdown',
		'param_name' => 'separator_position',
		'value'      => array(
			esc_html__( 'Top', 'atomlab' )    => 'top',
			esc_html__( 'Bottom', 'atomlab' ) => 'bottom',
		),
		'std'        => 'bottom',
		'dependency' => array(
			'element'   => 'separator_type',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $separator_tab,
		'heading'    => esc_html__( 'Separator Color', 'atomlab' ),
		'type'       => 'dropdown',
		'param_name' => 'separator_color',
		'value'      => array(
			esc_html__( 'Primary Color', 'atomlab' ) => 'primary_color',
			esc_html__( 'Custom Color', 'atomlab' )  => 'custom',
		),
		'std'        => 'custom',
		'dependency' => array(
			'element'   => 'separator_type',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $separator_tab,
		'heading'    => esc_html__( 'Custom Separator Color', 'atomlab' ),
		'type'       => 'colorpicker',
		'param_name' => 'custom_separator_color',
		'dependency' => array(
			'element' => 'separator_color',
			'value'   => array( 'custom' ),
		),
		'std'        => '#fff',
	),
	array(
		'group'       => $onepage_tab,
		'heading'     => esc_html__( 'Skin', 'atomlab' ),
		'description' => esc_html__( 'Controls the skin of pagination when view this section.', 'atomlab' ),
		'type'        => 'dropdown',
		'param_name'  => 'onepage_skin',
		'value'       => array(
			esc_html__( 'Dark', 'atomlab' )  => 'dark',
			esc_html__( 'Light', 'atomlab' ) => 'light',
		),
		'std'         => 'dark',
	),
	array(
		'group'       => $onepage_tab,
		'heading'     => esc_html__( 'Title', 'atomlab' ),
		'description' => esc_html__( 'Controls the text of this section.', 'atomlab' ),
		'type'        => 'textfield',
		'param_name'  => 'onepage_title',
	),
	array(
		'group'       => $onepage_tab,
		'heading'     => esc_html__( 'Anchor', 'atomlab' ),
		'description' => esc_html__( 'Add the unique anchor name. The anchor can used for anchor navigation in menu.', 'atomlab' ),
		'type'        => 'textfield',
		'param_name'  => 'onepage_anchor',
	),
) ) );
