<?php
/**
 * Cross-sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cross-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.6.0
 */

defined( 'ABSPATH' ) || exit;

if ( $cross_sells ) : ?>

	<div class="cross-sells products">
		<?php
		$heading = apply_filters( 'woocommerce_product_cross_sells_products_heading', __( 'You may be interested in&hellip;', 'atomlab' ) );

		if ( $heading ) :
			?>
			<h2><?php echo esc_html( $heading ); ?></h2>
		<?php endif; ?>

		<div class="tm-swiper tm-product style-grid equal-height equal-thumbnail-height"
		     data-lg-items="4"
		     data-md-items="3"
		     data-sm-items="2"
		     data-xs-items="1"
		     data-nav="1"
		     data-loop="1"
		>
			<div class="swiper-container">
				<div class="swiper-wrapper">

					<?php foreach ( $cross_sells as $cross_sell ) : ?>
						<div class="swiper-slide">
							<?php
							$post_object = get_post( $cross_sell->get_id() );

							setup_postdata( $GLOBALS['post'] = $post_object ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found

							wc_get_template_part( 'content', 'product' );
							?>
						</div>
					<?php endforeach; ?>

				</div>
			</div>
		</div>

	</div>

<?php endif;

wp_reset_postdata();

