<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Enqueue child scripts
 */
if ( ! function_exists( 'atomlab_child_enqueue_scripts' ) ) {
	function atomlab_child_enqueue_scripts() {
		$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG == true ? '' : '.min';

		if ( is_rtl() ) {
			wp_enqueue_style( 'atomlab-style', get_template_directory_uri() . "/style-rtl{$min}.css" );
		} else {
			wp_enqueue_style( 'atomlab-style', get_template_directory_uri() . "/style{$min}.css" );
		}

		wp_enqueue_style( 'atomlab-child-style', get_stylesheet_directory_uri() . '/style.css', array( 'atomlab-style' ), wp_get_theme()->get( 'Version' ) );
	}
}
add_action( 'wp_enqueue_scripts', 'atomlab_child_enqueue_scripts' );
