<?php

use Detection\Exception\MobileDetectException;
use Detection\MobileDetectStandalone;

define( 'MOBBLE_PATH', dirname( __FILE__ ) );
require_once MOBBLE_PATH . '/Mobile-Detect/standalone/autoloader.php';
require_once MOBBLE_PATH . '/Mobile-Detect/src/MobileDetectStandalone.php';

if ( ! class_exists( 'Mobile_Detect' ) ) {
	class Mobile_Detect {
		private static $instance = null;

		public static function instance() {
			if ( self::$instance === null ) {
				self::$instance = new MobileDetectStandalone();
			}

			return self::$instance;
		}

		public function __call( string $name, array $arguments ) {
			try {
				return call_user_func_array( [ self::instance(), $name ], $arguments );
			} catch ( MobileDetectException $e ) {
			}
		}

		public static function __callStatic( string $name, array $arguments ) {
			try {
				return call_user_func_array( [ self::instance(), $name ], $arguments );
			} catch ( MobileDetectException $e ) {
			}
		}
	}
}
