# Avada Translations

In this repository, you can find translations for all components of the [Avada Website Builder](https://avada.com/) products, and contribute translations for your language.

## Who maintains this repository

Our translations are community-driven. Anyone can contribute translations for their own language. This repository hosts both the translation files and our Translations-API, so translation file updates are automatically distributed to all sites.

You can find a list of contributors on [this page](https://github.com/Theme-Fusion/Localization-l10n/graphs/contributors).

## How to Contribute

If you find that some strings are not translated for your language, you can use software like [Poedit](https://poedit.net/) which is free and cross-platform to translate them, and then submit your updated files so we can include them.  
**IMPORTANT**: Make sure you are using the latest files for your locale _before_ you start translating them.

You can find instructions on how to fork the repository and contribute back in this [GitHub guide](https://guides.github.com/activities/forking/#making-a-pull-request).

If you are not comfortable using GitHub for your translations you can also submit them by sending an email to our support team, and we will submit the updated translations for you > support@avada.com

There is no need to submit `.mo` or `.zip` files, we automatically generate these after your translations are merged. The only thing that should be included in your pull request is an updated `.po` file for your locale.

## Review Process

Once you submit your translations, our team will check your translations and after they pass our inspection they will get merged. While we can not check the correctness of submitted translations for all locales, we check for abusive language and malintent such as spam links. If a member of our team is a native speaker of the submitted language then we also conduct a second check for the correctness of the submitted translations.
We urge you to be patient. The above checks can take from a few hours to a few days depending on the locale and number of translated strings.
