<?php
/**
 * Related Posts Section
 * 
 * @package tx
 * @author theme-x
 * @link https://theme-x.org/
 */

$related_count = (int) tx_get_option( 'related_posts_count', 8 );
$related_text  = tx_get_option( 'related-posts_text', esc_html__( 'Related Posts', 'avas' ) );
$related_style = tx_get_option( 'related_posts_style', 'rp_style_1' );

$rp_query = new WP_Query( [
    'category__in'        => wp_get_post_categories( get_the_ID() ),
    'posts_per_page'      => $related_count ?: 8,
    'post__not_in'        => [ get_the_ID() ],
    'ignore_sticky_posts' => true,
    'no_found_rows'       => true,
] );

if ( $rp_query->have_posts() ) :

    // Enqueue Owl assets ONLY when needed
    wp_enqueue_style(  'tx-owl-carousel' );
    wp_enqueue_script( 'tx-owl-carousel' );

    // Ensure the init script is added only once per request
    static $tx_related_owl_inited = false;
    if ( ! $tx_related_owl_inited ) {
        $tx_related_owl_inited = true;

        $init_js = <<<JS
        jQuery(function($){
          $('.related-posts-loop.owl-carousel').each(function(){
            var \$el = $(this);
            if (\$el.data('owl-initialized')) return;
            \$el.data('owl-initialized', true).owlCarousel({
              loop: true,
              margin: 20,
              nav: true,
              dots: false,
              autoplay: true,
              autoplayTimeout: 3000,
              smartSpeed: 600,
              navText: ['<i class="fa fa-angle-left"></i>','<i class="fa fa-angle-right"></i>'],
              responsive: {
                0:    { items: 1 },
                600:  { items: 2 },
                768:  { items: 2 },
                1000: { items: 3 } // ✅ 3 items on desktop
              }
            });
          });
        });
        JS;

        // Attach after Owl so the constructor exists
        wp_add_inline_script( 'tx-owl-carousel', $init_js, 'after' );
    }
    ?>
    <div class="related-posts">
        <h3 class="related-posts-title"><?php echo wp_kses_post( $related_text ); ?></h3>

        <div class="related-posts-loop owl-carousel">
            <?php while ( $rp_query->have_posts() ) : $rp_query->the_post(); ?>
                <?php if ( $related_style === 'rp_style_1' ) : ?>
                    <div class="related-posts-item">
                        <a rel="external" href="<?php the_permalink(); ?>">
                            <?php if ( has_post_thumbnail() ) {
                                the_post_thumbnail( 'tx-r-thumb' );
                            } else { ?>
                                <img src="<?php echo esc_url( TX_IMAGES . 'related-posts.png' ); ?>" alt="<?php the_title_attribute(); ?>">
                            <?php } ?>
                        </a>
                        <div class="overlay">
                            <?php the_title( sprintf(
                                '<h6 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() )
                            ), '</a></h6>' ); ?>
                        </div>
                    </div>
                <?php else : // rp_style_2 ?>
                    <div class="related-posts-item">
                        <a rel="external" href="<?php the_permalink(); ?>">
                            <?php if ( has_post_thumbnail() ) { the_post_thumbnail( 'tx-r-thumb' ); } ?>
                            <?php the_title( '<h5 class="entry-title">', '</h5>' ); ?>
                        </a>
                    </div>
                <?php endif; ?>
            <?php endwhile; wp_reset_postdata(); ?>
        </div><!-- /.related-posts-loop -->
    </div><!-- /.related-posts -->
<?php endif;