/*global jQuery, document, window, google*/
/* ==========================================================================
Document Ready Function
========================================================================== */
jQuery(document).ready(function () {

    'use strict';

    var switcher_variations;


    /* ==========================================================================
    Open / Close Switcher
    ========================================================================== */
    jQuery('a.switcher-open-colse-btn').on('click', function (e) {
        e.preventDefault();
        jQuery('#StyleSwitcher').toggleClass('switcher-open-close');
        jQuery('a.switcher-open-colse-btn').toggleClass('switcher-open-close');
    });


    /* ==========================================================================
    Show Breadcrumb Options
    ========================================================================== */
    if (jQuery('.breadcrumb-section').length) {
        jQuery('.switcher-bread').addClass('remove-switcher-bread');
    }


    /* ==========================================================================
    Show Google Map Options
    ========================================================================== */
    if (jQuery('.google-map').length) {
        jQuery('.switcher-map').addClass('remove-switcher-map');
    }


    /* ==========================================================================
    Switcher Button
    ========================================================================== */
    jQuery('a.switcher-button').on('click', function (e) {
        e.preventDefault();
    });

    jQuery('a.switcher-small-button').on('click', function (e) {
        e.preventDefault();
    });


    /* ==========================================================================
    Variations
    ========================================================================== */
    jQuery('a.switcher-full-width').on('click', function () {
        jQuery('body').removeClass('boxed-style-1');
        jQuery('body').removeClass('boxed-style-2');
        jQuery('.switcher-full-width').addClass('switcher-button-active');
        jQuery('.switcher-boxed-style-1').removeClass('switcher-button-active');
        jQuery('.switcher-boxed-style-2').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-boxed-style-1').on('click', function () {
        jQuery('body').addClass('boxed-style-1');
        jQuery('body').removeClass('boxed-style-2');
        jQuery('.switcher-full-width').removeClass('switcher-button-active');
        jQuery('.switcher-boxed-style-1').addClass('switcher-button-active');
        jQuery('.switcher-boxed-style-2').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-boxed-style-2').on('click', function () {
        jQuery('body').removeClass('boxed-style-1');
        jQuery('body').addClass('boxed-style-2');
        jQuery('.switcher-full-width').removeClass('switcher-button-active');
        jQuery('.switcher-boxed-style-1').removeClass('switcher-button-active');
        jQuery('.switcher-boxed-style-2').addClass('switcher-button-active');
    });


    /* ==========================================================================
    Top Header
    ========================================================================== */
    jQuery('a.switcher-top-header-light').on('click', function () {
        jQuery('header').addClass('top-header-light');
        jQuery('header').removeClass('top-header-grey');
        jQuery('header').removeClass('top-header-dark');
        jQuery('header').removeClass('top-header-base-color');
        jQuery('.switcher-top-header-light').addClass('switcher-button-active');
        jQuery('.switcher-top-header-grey').removeClass('switcher-button-active');
        jQuery('.switcher-top-header-dark').removeClass('switcher-button-active');
        jQuery('.switcher-top-header-base-color').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-top-header-grey').on('click', function () {
        jQuery('header').removeClass('top-header-light');
        jQuery('header').addClass('top-header-grey');
        jQuery('header').removeClass('top-header-dark');
        jQuery('header').removeClass('top-header-base-color');
        jQuery('.switcher-top-header-light').removeClass('switcher-button-active');
        jQuery('.switcher-top-header-grey').addClass('switcher-button-active');
        jQuery('.switcher-top-header-dark').removeClass('switcher-button-active');
        jQuery('.switcher-top-header-base-color').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-top-header-dark').on('click', function () {
        jQuery('header').removeClass('top-header-light');
        jQuery('header').removeClass('top-header-grey');
        jQuery('header').addClass('top-header-dark');
        jQuery('header').removeClass('top-header-base-color');
        jQuery('.switcher-top-header-light').removeClass('switcher-button-active');
        jQuery('.switcher-top-header-grey').removeClass('switcher-button-active');
        jQuery('.switcher-top-header-dark').addClass('switcher-button-active');
        jQuery('.switcher-top-header-base-color').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-top-header-base-color').on('click', function () {
        jQuery('header').removeClass('top-header-light');
        jQuery('header').removeClass('top-header-grey');
        jQuery('header').removeClass('top-header-dark');
        jQuery('header').addClass('top-header-base-color');
        jQuery('.switcher-top-header-light').removeClass('switcher-button-active');
        jQuery('.switcher-top-header-grey').removeClass('switcher-button-active');
        jQuery('.switcher-top-header-dark').removeClass('switcher-button-active');
        jQuery('.switcher-top-header-base-color').addClass('switcher-button-active');
    });


    /* ==========================================================================
    Header Menu
    ========================================================================== */
    jQuery('a.switcher-header-menu-light').on('click', function () {
        jQuery('header').addClass('header-menu-light');
        jQuery('header').removeClass('header-menu-grey');
        jQuery('header').removeClass('header-menu-dark');
        jQuery('header').removeClass('header-menu-base-color');
        jQuery('.navbar-brand img').attr('src', 'images/logo.png');
        jQuery('.switcher-header-menu-light').addClass('switcher-button-active');
        jQuery('.switcher-header-menu-grey').removeClass('switcher-button-active');
        jQuery('.switcher-header-menu-dark').removeClass('switcher-button-active');
        jQuery('.switcher-header-menu-base-color').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-header-menu-grey').on('click', function () {
        jQuery('header').removeClass('header-menu-light');
        jQuery('header').addClass('header-menu-grey');
        jQuery('header').removeClass('header-menu-dark');
        jQuery('header').removeClass('header-menu-base-color');
        jQuery('.navbar-brand img').attr('src', 'images/logo.png');
        jQuery('.switcher-header-menu-light').removeClass('switcher-button-active');
        jQuery('.switcher-header-menu-grey').addClass('switcher-button-active');
        jQuery('.switcher-header-menu-dark').removeClass('switcher-button-active');
        jQuery('.switcher-header-menu-base-color').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-header-menu-dark').on('click', function () {
        jQuery('header').removeClass('header-menu-light');
        jQuery('header').removeClass('header-menu-grey');
        jQuery('header').addClass('header-menu-dark');
        jQuery('header').removeClass('header-menu-base-color');
        jQuery('.navbar-brand img').attr('src', 'images/logo-light.png');
        jQuery('.switcher-header-menu-light').removeClass('switcher-button-active');
        jQuery('.switcher-header-menu-grey').removeClass('switcher-button-active');
        jQuery('.switcher-header-menu-dark').addClass('switcher-button-active');
        jQuery('.switcher-header-menu-base-color').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-header-menu-base-color').on('click', function () {
        jQuery('header').removeClass('header-menu-light');
        jQuery('header').removeClass('header-menu-grey');
        jQuery('header').removeClass('header-menu-dark');
        jQuery('header').addClass('header-menu-base-color');
        jQuery('.navbar-brand img').attr('src', 'images/logo-light.png');
        jQuery('.switcher-header-menu-light').removeClass('switcher-button-active');
        jQuery('.switcher-header-menu-grey').removeClass('switcher-button-active');
        jQuery('.switcher-header-menu-dark').removeClass('switcher-button-active');
        jQuery('.switcher-header-menu-base-color').addClass('switcher-button-active');
    });


    /* ==========================================================================
    Sub Menu
    ========================================================================== */
    jQuery('a.switcher-submenu-light').on('click', function () {
        jQuery('header').addClass('submenu-light');
        jQuery('header').removeClass('submenu-grey');
        jQuery('header').removeClass('submenu-dark');
        jQuery('header').removeClass('submenu-base-color');
        jQuery('.switcher-submenu-light').addClass('switcher-button-active');
        jQuery('.switcher-submenu-grey').removeClass('switcher-button-active');
        jQuery('.switcher-submenu-dark').removeClass('switcher-button-active');
        jQuery('.switcher-submenu-base-color').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-submenu-grey').on('click', function () {
        jQuery('header').removeClass('submenu-light');
        jQuery('header').addClass('submenu-grey');
        jQuery('header').removeClass('submenu-dark');
        jQuery('header').removeClass('submenu-base-color');
        jQuery('.switcher-submenu-light').removeClass('switcher-button-active');
        jQuery('.switcher-submenu-grey').addClass('switcher-button-active');
        jQuery('.switcher-submenu-dark').removeClass('switcher-button-active');
        jQuery('.switcher-submenu-base-color').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-submenu-dark').on('click', function () {
        jQuery('header').removeClass('submenu-light');
        jQuery('header').removeClass('submenu-grey');
        jQuery('header').addClass('submenu-dark');
        jQuery('header').removeClass('submenu-base-color');
        jQuery('.switcher-submenu-light').removeClass('switcher-button-active');
        jQuery('.switcher-submenu-grey').removeClass('switcher-button-active');
        jQuery('.switcher-submenu-dark').addClass('switcher-button-active');
        jQuery('.switcher-submenu-base-color').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-submenu-base-color').on('click', function () {
        jQuery('header').removeClass('submenu-light');
        jQuery('header').removeClass('submenu-grey');
        jQuery('header').removeClass('submenu-dark');
        jQuery('header').addClass('submenu-base-color');
        jQuery('.switcher-submenu-light').removeClass('switcher-button-active');
        jQuery('.switcher-submenu-grey').removeClass('switcher-button-active');
        jQuery('.switcher-submenu-dark').removeClass('switcher-button-active');
        jQuery('.switcher-submenu-base-color').addClass('switcher-button-active');
    });


    /* ==========================================================================
    Breadcrumb Variation
    ========================================================================== */
    jQuery('a.switcher-breadcrumb-default').on('click', function () {
        jQuery('.breadcrumb-section').removeClass('breadcrumb-grey');
        jQuery('.switcher-breadcrumb-default').addClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-grey').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-breadcrumb-grey').on('click', function () {
        jQuery('.breadcrumb-section').addClass('breadcrumb-grey');
        jQuery('.switcher-breadcrumb-default').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-grey').addClass('switcher-button-active');
    });


    /* ==========================================================================
    Breadcrumb Styles
    ========================================================================== */
    jQuery('a.switcher-breadcrumb-style-1').on('click', function () {
        jQuery('.breadcrumb-section').addClass('breadcrumb-style-1');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-2');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-3');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-4');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-5');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-6');
        jQuery('.switcher-breadcrumb-style-1').addClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-2').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-3').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-4').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-5').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-6').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-breadcrumb-style-2').on('click', function () {
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-1');
        jQuery('.breadcrumb-section').addClass('breadcrumb-style-2');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-3');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-4');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-5');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-6');
        jQuery('.switcher-breadcrumb-style-1').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-2').addClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-3').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-4').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-5').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-6').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-breadcrumb-style-3').on('click', function () {
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-1');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-2');
        jQuery('.breadcrumb-section').addClass('breadcrumb-style-3');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-4');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-5');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-6');
        jQuery('.switcher-breadcrumb-style-1').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-2').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-3').addClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-4').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-5').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-6').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-breadcrumb-style-4').on('click', function () {
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-1');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-2');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-3');
        jQuery('.breadcrumb-section').addClass('breadcrumb-style-4');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-5');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-6');
        jQuery('.switcher-breadcrumb-style-1').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-2').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-3').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-4').addClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-5').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-6').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-breadcrumb-style-5').on('click', function () {
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-1');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-2');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-3');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-4');
        jQuery('.breadcrumb-section').addClass('breadcrumb-style-5');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-6');
        jQuery('.switcher-breadcrumb-style-1').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-2').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-3').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-4').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-5').addClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-6').removeClass('switcher-button-active');
    });

    jQuery('a.switcher-breadcrumb-style-6').on('click', function () {
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-1');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-2');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-3');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-4');
        jQuery('.breadcrumb-section').removeClass('breadcrumb-style-5');
        jQuery('.breadcrumb-section').addClass('breadcrumb-style-6');
        jQuery('.switcher-breadcrumb-style-1').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-2').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-3').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-4').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-5').removeClass('switcher-button-active');
        jQuery('.switcher-breadcrumb-style-6').addClass('switcher-button-active');
    });


    /* ==========================================================================
    Google Maps
    ========================================================================== */
    jQuery('a.switcher-google-maps-style-1').click(function () {

        jQuery('.switcher-google-maps-style-1').addClass('switcher-button-active');
        jQuery('.switcher-google-maps-style-2').removeClass('switcher-button-active');

        var map_Lat_lng, map_options, map_element, google_map, map_marker_image, map_marker;

        map_Lat_lng = new google.maps.LatLng(47.605798, -122.325258);
        map_options = {
            zoom: 16,
            panControl: false,
            scrollwheel: false,
            mapTypeControl: true,
            center: map_Lat_lng
        };
        map_element = document.getElementById('gmap-style-1');
        google_map = new google.maps.Map(map_element, map_options);
        map_marker_image = 'images/marker.png';
        map_marker = new google.maps.Marker({
            position: map_Lat_lng,
            map: google_map,
            icon: map_marker_image
        });
        google_map.panBy(0, 0);
        google.maps.event.trigger(google_map, 'resize');

    });

    jQuery('a.switcher-google-maps-style-2').click(function () {

        jQuery('.switcher-google-maps-style-1').removeClass('switcher-button-active');
        jQuery('.switcher-google-maps-style-2').addClass('switcher-button-active');

        var map_Lat_lng, map_options, map_element, google_map, map_marker_image, map_marker, map_style;

        map_Lat_lng = new google.maps.LatLng(47.605798, -122.325258);
        map_style = [
            {
                "featureType": "landscape",
                "stylers": [
                    {"saturation": -100},
                    {"lightness": 65},
                    {"visibility": "on"}
                ]
            }, {
                "featureType": "poi",
                "stylers": [
                    {"saturation": -100},
                    {"lightness": 51},
                    {"visibility": "simplified"}
                ]
            }, {
                "featureType": "road.highway",
                "stylers": [
                    {"saturation": -100},
                    {"visibility": "simplified"}
                ]
            }, {
                "featureType": "road.arterial",
                "stylers": [
                    {"saturation": -100},
                    {"lightness": 30},
                    {"visibility": "on"}
                ]
            }, {
                "featureType": "road.local",
                "stylers": [
                    {"saturation": -100},
                    {"lightness": 40},
                    {"visibility": "on"}
                ]
            }, {
                "featureType": "transit",
                "stylers": [
                    {"saturation": -100},
                    {"visibility": "simplified"}
                ]
            }, {
                "featureType": "administrative.province",
                "stylers": [
                    {"visibility": "off"}
                ]
            }, {
                "featureType": "water",
                "elementType": "labels",
                "stylers": [
                    {"visibility": "on"},
                    {"lightness": -25},
                    {"saturation": -100}
                ]
            }, {
                "featureType": "water",
                "elementType": "geometry",
                "stylers": [
                    {"hue": "#ffff00"},
                    {"lightness": -25},
                    {"saturation": -97}
                ]
            }
        ];

        map_options = {
            zoom: 16,
            panControl: false,
            scrollwheel: false,
            mapTypeControl: true,
            center: map_Lat_lng,
            styles: map_style
        };
        map_element = document.getElementById('gmap-style-1');
        google_map = new google.maps.Map(map_element, map_options);
        map_marker_image = 'images/marker.png';
        map_marker = new google.maps.Marker({
            position: map_Lat_lng,
            map: google_map,
            icon: map_marker_image
        });
        google_map.panBy(0, 0);
        google.maps.event.trigger(google_map, 'resize');

    });


    /* ==========================================================================
    Body Background Color
    ========================================================================== */
    jQuery('a.body-background-color-1').click(function () {
        jQuery('body').removeClass('background-image-style');
        jQuery('body').removeClass('background-pattern-style');
        jQuery('body').css({backgroundColor: '#0dc0c0'});
        jQuery('body').css({backgroundImage: 'none'});
    });
    jQuery('a.body-background-color-2').click(function () {
        jQuery('body').removeClass('background-image-style');
        jQuery('body').removeClass('background-pattern-style');
        jQuery('body').css({ backgroundColor: '#609ddb'});
        jQuery('body').css({backgroundImage: 'none'});
    });
    jQuery('a.body-background-color-3').click(function () {
        jQuery('body').removeClass('background-image-style');
        jQuery('body').removeClass('background-pattern-style');
        jQuery('body').css({ backgroundColor: '#18ba60'});
        jQuery('body').css({backgroundImage: 'none'});
    });
    jQuery('a.body-background-color-4').click(function () {
        jQuery('body').removeClass('background-image-style');
        jQuery('body').removeClass('background-pattern-style');
        jQuery('body').css({ backgroundColor: '#86ba41'});
        jQuery('body').css({backgroundImage: 'none'});
    });
    jQuery('a.body-background-color-5').click(function () {
        jQuery('body').removeClass('background-image-style');
        jQuery('body').removeClass('background-pattern-style');
        jQuery('body').css({ backgroundColor: '#f58b3c'});
        jQuery('body').css({backgroundImage: 'none'});
    });
    jQuery('a.body-background-color-6').click(function () {
        jQuery('body').removeClass('background-image-style');
        jQuery('body').removeClass('background-pattern-style');
        jQuery('body').css({ backgroundColor: '#e86343'});
        jQuery('body').css({backgroundImage: 'none'});
    });
    jQuery('a.body-background-color-7').click(function () {
        jQuery('body').removeClass('background-image-style');
        jQuery('body').removeClass('background-pattern-style');
        jQuery('body').css({ backgroundColor: '#8f5340'});
        jQuery('body').css({backgroundImage: 'none'});
    });
    jQuery('a.body-background-color-8').click(function () {
        jQuery('body').removeClass('background-image-style');
        jQuery('body').removeClass('background-pattern-style');
        jQuery('body').css({ backgroundColor: '#8463a9'});
        jQuery('body').css({backgroundImage: 'none'});
    });


    /* ==========================================================================
    Body Background Image
    ========================================================================== */
    jQuery('a.body-background-image-1').click(function () {
        jQuery('body').addClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/background/general-bg.jpg')"});
    });
    jQuery('a.body-background-image-2').click(function () {
        jQuery('body').addClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/background/main-bg.jpg')"});
    });
    jQuery('a.body-background-image-3').click(function () {
        jQuery('body').addClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/background/testimonials-bg.jpg')"});
    });
    jQuery('a.body-background-image-4').click(function () {
        jQuery('body').addClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/background/video-bg.jpg')"});
    });


    /* ==========================================================================
    Body Background Pattern
    ========================================================================== */
    jQuery('a.body-background-pattern-1').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg1.png')"});
    });
    jQuery('a.body-background-pattern-2').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg2.png')"});
    });
    jQuery('a.body-background-pattern-3').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg3.png')"});
    });
    jQuery('a.body-background-pattern-4').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg4.png')"});
    });
    jQuery('a.body-background-pattern-5').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg5.png')"});
    });
    jQuery('a.body-background-pattern-6').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg6.png')"});
    });
    jQuery('a.body-background-pattern-7').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg7.png')"});
    });
    jQuery('a.body-background-pattern-8').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg8.png')"});
    });
    jQuery('a.body-background-pattern-9').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg9.png')"});
    });
    jQuery('a.body-background-pattern-10').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg10.png')"});
    });
    jQuery('a.body-background-pattern-11').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg11.png')"});
    });
    jQuery('a.body-background-pattern-12').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg12.png')"});
    });
    jQuery('a.body-background-pattern-13').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg13.png')"});
    });
    jQuery('a.body-background-pattern-14').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg14.png')"});
    });
    jQuery('a.body-background-pattern-15').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg15.png')"});
    });
    jQuery('a.body-background-pattern-16').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg16.png')"});
    });
    jQuery('a.body-background-pattern-17').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg17.png')"});
    });
    jQuery('a.body-background-pattern-18').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg18.png')"});
    });
    jQuery('a.body-background-pattern-19').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg19.png')"});
    });
    jQuery('a.body-background-pattern-20').click(function () {
        jQuery('body').addClass('background-pattern-style');
        jQuery('body').removeClass('background-image-style');
        jQuery('body').css({backgroundImage: "url('images/patterns/bg20.png')"});
    });


});