<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains comments and the comment form.
/*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() )
    return;
?>
<?php  ?>

<div class="row">
 <div class="col-md-12">
<!-- post-comments-wrapper -->
  <div class="post-comments-wrapper">


      <!-- post-comments-title -->
      <div class="post-comments-title">
          <h4><?php comments_popup_link(__('0 comment','avaxy'),__('1 comments','avaxy'),__('% comments','avaxy')); ?></h4>
      </div><!-- /post-comments-title -->


      <!-- post-comments -->
      <div class="post-comments">

      <?php if ( have_comments() ) : ?>
                 <?php wp_list_comments('callback=avaxy_theme_comment'); ?>

                 <?php
                    // Are there comments to navigate through?
                    if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
                ?>
                    <nav class="navigation comment-navigation" role="navigation">          
                        <div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'avaxy' ) ); ?></div>
                        <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'avaxy' ) ); ?></div>
                    </nav><!-- .comment-navigation -->
                <?php endif; // Check for comment navigation ?>

                <?php if ( ! comments_open() && get_comments_number() ) : ?>
                    <p class="no-comments"><?php esc_html_e(  'Comments are closed.' , 'avaxy' ); ?></p>
                <?php endif; ?> 
                  <?php endif; ?> 


      </div><!-- /post-comments -->
  </div><!-- /post-comments-wrapper -->
  </div>
  </div>

<!-- row -->
<div class="row">
    <!-- col-md-12 -->
    <div class="col-md-12">

        <!-- post-add-comment -->
        <div class="post-add-comment">
            <!-- row -->
            <div class="row">
              <!-- col-md-12 -->
                  <div class="col-md-12">

                      <!-- post-add-comment-title -->
                      <div class="post-add-comment-title">
                          <h4>leave a comment</h4>
                      </div><!-- /post-add-comment-title -->

                  </div><!-- /col-md-12 -->




                    <?php
                if ( is_singular() ) wp_enqueue_script( "comment-reply" );
                    $aria_req = ( $req ? " aria-required='true'" : '' );
                    $comment_args = array(
                            'id_form' => 'commentform', 
                            'class_form' => 'blog-comment-form',                                
                            'title_reply'=> '',
                            'fields' => apply_filters( 'comment_form_default_fields', array(
                                'author' => '<div class="col-md-6"><div class="form-group">
                                           <input type="text" class="form-control" placeholder="'.esc_attr__('Your Name', 'avaxy').'" id="blog-comment-name"></div>
                                            ',
                                'email' => '<div class="form-group"><input type="text" class="form-control" placeholder="'.esc_attr__('Your Email', 'avaxy').'" id="blog-comment-email"></div>
                                            ', 
                                'site' =>'<div class="form-group"><input type="text" class="form-control" placeholder="'.esc_attr__('Your Website', 'avaxy').'" id="blog-comment-website"></div></div>',    
                                                                                                       
                            ) ),  
                             
                            'comment_field' => '<div class="col-md-6"><div class="form-group"><textarea rows="10" class="form-control" placeholder="'.esc_attr__('Your Comment', 'avaxy').'" id="blog-comment-message" name="comment"'.$aria_req.'></textarea></div></div>
                                                ',                    
                             
                             'label_submit' => 'Add comment',


                             'comment_notes_before' => '',
                             'comment_notes_after' => '',               
                    )
                ?>
                <?php comment_form($comment_args); ?>

                    <!-- col-md-12 -->
                    <div class="col-md-12">

                        <!-- blog-comment-message -->
                        <div class="blog-comment-message"></div>

                    </div><!-- /col-md-12 -->



            </div><!-- /row -->
        </div><!-- /post-add-comment -->

    </div><!-- /col-md-12 -->
</div><!-- /row -->


