<?php 
//Define Text Doimain
$avaxy_redux_demo = get_option('redux_demo');
$lang = get_template_directory_uri() . '/languages';
load_theme_textdomain('avaxy', $lang);

require_once get_template_directory() . '/framework/wp_bootstrap_navwalker.php';
require_once get_template_directory() . '/framework/class-ocdi-importer.php';


function avaxy_theme_scripts_styles() {
	
	$protocol = is_ssl() ? 'https' : 'http';
    wp_enqueue_style( 'bootstrap.min.css', get_template_directory_uri().'/js/vendor/bootstrap/css/bootstrap.min.css');
    wp_enqueue_style('googlefonts', 'http://fonts.googleapis.com/css?family=Ubuntu:400,500,700', array(), null );
    wp_enqueue_style('googlefonts-2', 'http://fonts.googleapis.com/css?family=Lato:400,700', array(), null );
    wp_enqueue_style( 'font-awesome', get_template_directory_uri().'/fonts/fontawesome/css/font-awesome.min.css');
    wp_enqueue_style( 'social-icons', get_template_directory_uri().'/css/social-icons.css');
    wp_enqueue_style( 'animate', get_template_directory_uri().'/js/plugins/animate/animate.min.css');
    wp_enqueue_style( 'owl-carousel', get_template_directory_uri().'/js/plugins/owl-carousel/owl.carousel.css');
    wp_enqueue_style( 'owl-theme', get_template_directory_uri().'/js/plugins/owl-carousel/owl.theme.css');
    wp_enqueue_style( 'jquery-fancybox', get_template_directory_uri().'/js/plugins/fancybox/jquery.fancybox.css');
    wp_enqueue_style( 'chosen', get_template_directory_uri().'/js/plugins/chosen/css/chosen.min.css');
    wp_enqueue_style( 'ion-rangeSlider', get_template_directory_uri().'/js/plugins/ion-rangeSlider/css/ion.rangeSlider.css');
    wp_enqueue_style( 'rangeSlider-skinFlat', get_template_directory_uri().'/js/plugins/ion-rangeSlider/css/ion.rangeSlider.skinFlat.css');
    wp_enqueue_style( 'YTPlayer', get_template_directory_uri().'/js/plugins/YTPlayer/css/YTPlayer.css');
    wp_enqueue_style( 'settings', get_template_directory_uri().'/js/plugins/rs-plugin/css/settings.css');
    wp_enqueue_style( 'supersized', get_template_directory_uri().'/js/plugins/supersized/css/supersized.css');
    wp_enqueue_style( 'avaxy-css', get_template_directory_uri().'/css/style.css');
    wp_enqueue_style( 'avaxy-switcher', get_template_directory_uri().'/StyleSwitcher/switcher.css');
    wp_enqueue_style( 'avaxy-style', get_stylesheet_uri(), array(), '2016-03-26' );



    wp_enqueue_script("modernizr.custom.js", get_template_directory_uri()."/js/vendor/modernizr.custom.js",array(),false,true);
    wp_enqueue_script( 'ajax.googleapis.com', "http://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js",array(),false,true);
    wp_enqueue_script("maps.google.com","http://maps.google.com/maps/api/js?sensor=true",array(),false,true);
    wp_enqueue_script("bootstrap", get_template_directory_uri()."/js/vendor/bootstrap/js/bootstrap.min.js",array(),false,true);
    wp_enqueue_script("jquery-placeholder", get_template_directory_uri()."/js/plugins/placeholder/jquery.placeholder.min.js",array(),false,true);
    wp_enqueue_script("jquery-easing", get_template_directory_uri()."/js/plugins/easing/jquery.easing.1.3.js",array(),false,true);
    wp_enqueue_script("jquery-parallax", get_template_directory_uri()."/js/plugins/parallax/jquery.parallax-1.1.3.js",array(),false,true);
    wp_enqueue_script("jquery-waypoints", get_template_directory_uri()."/js/plugins/waypoints/jquery.waypoints.min.js",array(),false,true);
    wp_enqueue_script("sticky", get_template_directory_uri()."/js/plugins/waypoints/sticky.min.js",array(),false,true);
    wp_enqueue_script("owl-carousel", get_template_directory_uri()."/js/plugins/owl-carousel/owl.carousel.min.js",array(),false,true);
    wp_enqueue_script("jquery-fitvids", get_template_directory_uri()."/js/plugins/fitvids/jquery.fitvids.js",array(),false,true);
    wp_enqueue_script("tweetie", get_template_directory_uri()."/js/plugins/twitter/tweetie.min.js",array(),false,true);
    wp_enqueue_script("jquery-jribbble-1.0.1", get_template_directory_uri()."/js/plugins/dribbble/jquery.jribbble-1.0.1.ugly.js",array(),false,true);
    wp_enqueue_script("jflickrfeed", get_template_directory_uri()."/js/plugins/flickr/jflickrfeed.min.js",array(),false,true);
    wp_enqueue_script("jquery-fancybox", get_template_directory_uri()."/js/plugins/fancybox/jquery.fancybox.pack.js",array(),false,true);
    wp_enqueue_script("jquery-fancybox-media", get_template_directory_uri()."/js/plugins/fancybox/helpers/jquery.fancybox-media.js",array(),false,true);
    wp_enqueue_script("jquery-ajaxchimp", get_template_directory_uri()."/js/plugins/ajaxchimp/jquery.ajaxchimp.min.js",array(),false,true);
    wp_enqueue_script("isotope-pkgd", get_template_directory_uri()."/js/plugins/isotope/isotope.pkgd.min.js",array(),false,true);
    wp_enqueue_script("jquery-lwtCountdown", get_template_directory_uri()."/js/plugins/lwtCountdown/jquery.lwtCountdown-1.0.js",array(),false,true);
    wp_enqueue_script("chosen-jquery", get_template_directory_uri()."/js/plugins/chosen/js/chosen.jquery.min.js",array(),false,true);
    wp_enqueue_script("ion-rangeSlider", get_template_directory_uri()."/js/plugins/ion-rangeSlider/js/ion.rangeSlider.min.js",array(),false,true);
    wp_enqueue_script("blog-comments", get_template_directory_uri()."/js/plugins/extra/blog-comments.js",array(),false,true);
    wp_enqueue_script("shop-itrem-review", get_template_directory_uri()."/js/plugins/extra/shop-itrem-review.js",array(),false,true);
    wp_enqueue_script("jquery-mb-YTPlayer", get_template_directory_uri()."/js/plugins/YTPlayer/jquery.mb.YTPlayer.min.js",array(),false,true);
    wp_enqueue_script("jquery-countTo", get_template_directory_uri()."/js/plugins/countTo/jquery.countTo.js",array(),false,true);
    wp_enqueue_script("jquery-themepunch-tools", get_template_directory_uri()."/js/plugins/rs-plugin/js/jquery.themepunch.tools.min.js",array(),false,true);
    wp_enqueue_script("jquery-themepunch-revolution", get_template_directory_uri()."/js/plugins/rs-plugin/js/jquery.themepunch.revolution.min.js",array(),false,true);
    wp_enqueue_script("smooth-scroll", get_template_directory_uri()."/js/plugins/smooth-scroll/smooth-scroll.min.js",array(),false,true);
    wp_enqueue_script("supersized", get_template_directory_uri()."/js/plugins/supersized/js/supersized.3.2.7.min.js",array(),false,true);
    wp_enqueue_script("scripts11432.js", get_template_directory_uri()."/js/scripts.js",array(),false,true, '1.2.2');
    wp_enqueue_script("switcher.js", get_template_directory_uri()."/StyleSwitcher/switcher.js",array(),false,true);
}
add_action( 'wp_enqueue_scripts', 'avaxy_theme_scripts_styles' );

function avaxy_theme_setup() {
    /*
     * This theme uses a custom image size for featured images, displayed on
     * "standard" posts and pages.
     */
    
    add_theme_support( "title-tag" );
    add_theme_support( 'post-thumbnails' );

    add_theme_support( 'automatic-feed-links' );
    add_theme_support( 'custom-header' ); 
    add_theme_support( 'custom-background' );
    /* Post Format */
    add_theme_support( 'post-formats', array(
      'image',
      'video',
      'gallery',
      'link'
    ) );
    
// This theme uses wp_nav_menu() in one location.
    register_nav_menus( array(
        'primary' => esc_html__( 'Primary Navigation Menu: Chosen menu in Home page, single, blog, pages ...', 'avaxy' ),
        'secondary' => esc_html__( 'Footer Menu', 'avaxy' ),
        'one_page' => esc_html__( 'Menu One page', 'avaxy' ),
    ) );
}
add_action( 'after_setup_theme', 'avaxy_theme_setup' );
if ( ! isset( $content_width ) ) $content_width = 900;
// Widget Sidebar
function avaxy_widgets_init() {
// Widget Sidebar
    register_sidebar( array(
        'name'          => esc_html__( 'Primary Sidebar', 'avaxy' ),
        'id'            => 'sidebar-1',        
        'description'   => esc_html__( 'Appears in the sidebar blog section of the site.', 'avaxy' ),        
        'before_widget' => '<div id="%1$s" class="widget %2$s">',        
        'after_widget'  => '</div>',        
        'before_title'  => '<div class="widget-title"><h4>',        
        'after_title'   => '</h4></div>'
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Portfolio Sidebar', 'avaxy' ),
        'id'            => 'sidebar-2',        
        'description'   => esc_html__( 'Appears in the sidebar portfolio section of the site.', 'avaxy' ),        
        'before_widget' => '<div id="%1$s" class="widget %2$s">',        
        'after_widget'  => '</div>',        
        'before_title'  => '<div class="widget-title"><h4>',        
        'after_title'   => '</h4></div>'
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Other Sidebar', 'avaxy' ),
        'id'            => 'sidebar-3',        
        'description'   => esc_html__( 'Appears in the sidebar Other section of the site.', 'avaxy' ),        
        'before_widget' => '<div id="%1$s" class="widget %2$s">',        
        'after_widget'  => '</div>',        
        'before_title'  => '<div class="widget-title"><h4>',        
        'after_title'   => '</h4></div>'
    ) );

    register_sidebar( array(
    'name'          => esc_html__( 'Footer One Widget Area', 'avaxy' ),
    'id'            => 'footer-area-1',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'avaxy' ),
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<div class="widget-title"><h4>',
    'after_title'   => '</h4></div>',
  ) );
  
  register_sidebar( array(
    'name'          => esc_html__( 'Footer two Widget Area', 'avaxy' ),
    'id'            => 'footer-area-2',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'avaxy' ),
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<div class="widget-title"><h4>',
    'after_title'   => '</h4></div>',
  ) );
  register_sidebar( array(
    'name'          => esc_html__( 'Footer Three Widget Area', 'avaxy' ),
    'id'            => 'footer-area-3',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'avaxy' ),
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<div class="widget-title"><h4>',
    'after_title'   => '</h4></div>',
  ) );
  register_sidebar( array(
    'name'          => esc_html__( 'Footer Four Widget Area', 'avaxy' ),
    'id'            => 'footer-area-4',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'avaxy' ),
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<div class="widget-title"><h4>',
    'after_title'   => '</h4></div>',
  ) );
  register_sidebar( array(
    'name'          => esc_html__( 'Footer Five Widget Area', 'avaxy' ),
    'id'            => 'footer-area-5',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'avaxy' ),
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<div class="widget-title"><h4>',
    'after_title'   => '</h4></div>',
  ) );
}
add_action( 'widgets_init', 'avaxy_widgets_init' );

function avaxy_excerpt() {
  $avaxy_redux_demo = get_option('redux_demo');
  if(isset($avaxy_redux_demo['blog_excerpt'])){
    $limit = $avaxy_redux_demo['blog_excerpt'];
  }else{
    $limit = 30;
  }
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}

function avaxy_pagination($prev = '<', $next = '>', $pages='') {
    global $wp_query, $wp_rewrite;
    $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
    if($pages==''){
        global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
    }
    $pagination = array(
        'base'          => str_replace( 999999999, '%#%', get_pagenum_link( 999999999 ) ),
        'format'        => '',
        'current'       => max( 1, get_query_var('paged') ),
        'total'         => $pages,
        'prev_text' => $prev,
        'next_text' => $next,
        'type'          => 'list',
        'end_size'      => 3,
        'mid_size'      => 3
);
    $return =  paginate_links( $pagination );
    echo str_replace( "<ul class='page-numbers'>", '<ul class="pagination">', $return );
}


function avaxy_theme_comment($comment, $args, $depth) {
    //echo 's';
   $GLOBALS['comment'] = $comment; ?>

    <!-- comment-box -->
  <div class="comment-box">

      <!-- comment-avatar -->
      <div class="comment-avatar">

          <?php echo get_avatar($comment,$size='80'); ?>

          <!-- replay-button -->
          <div class="replay-button btn btn-nesto"><?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
          </div><!-- /replay-button -->

      </div><!-- /comment-avatar -->

      <!-- comment-content -->
      <div class="comment-content">

          <!-- comment-header -->
          <div class="comment-header">

              <!-- comment-author -->
              <div class="comment-author">
                  <h5><?php printf(__('%s','avaxy'), get_comment_author_link()) ?></h5>
              </div><!-- /comment-author -->

              <!-- comment-date -->
              <div class="comment-date">
                  <?php the_time('F j, Y'); ?> - <?php the_time('g:i a'); ?>
              </div><!-- /comment-date -->

          </div><!-- /comment-header -->

          <!-- comment-footer -->
          <div class="comment-footer">

              <!-- comment-details -->
              <div class="comment-details">
                  <p><?php comment_text() ?></p>
              </div><!-- /comment-details -->

          </div><!-- /comment-footer -->

      </div><!-- /comment-content -->

  </div><!-- /comment-box -->



<?php       
}

//function tag widgets
function avaxy_tag_cloud_widget($args) {
  $args['number'] = 0; //adding a 0 will display all tags
  $args['largest'] = 18; //largest tag
  $args['smallest'] = 11; //smallest tag
  $args['unit'] = 'px'; //tag font unit
  $args['exclude'] = array(20, 80, 92); //exclude tags by ID
  return $args;
}
add_filter( 'widget_tag_cloud_args', 'avaxy_tag_cloud_widget' );



//Code Visual Compurso.
//if(class_exists('WPBakeryVisualComposerSetup')){
function avaxy_custom_css_classes_for_vc_row_and_vc_column($class_string, $tag) {
    if($tag=='vc_row' || $tag=='vc_row_inner') {
        $class_string = str_replace('vc_row-fluid', '', $class_string);
    }
    if($tag=='vc_column' || $tag=='vc_column_inner') {
    $class_string = preg_replace('/vc_col-sm-12/', 'col-md-12', $class_string);
    $class_string = preg_replace('/vc_col-sm-6/', 'col-md-6', $class_string);
    $class_string = preg_replace('/vc_col-sm-4/', 'col-md-4', $class_string);
    $class_string = preg_replace('/vc_col-sm-3/', 'col-md-3', $class_string);
    $class_string = preg_replace('/vc_col-sm-5/', 'col-md-5', $class_string);
    $class_string = preg_replace('/vc_col-sm-7/', 'col-md-7', $class_string);
    $class_string = preg_replace('/vc_col-sm-8/', 'col-md-8', $class_string);
    $class_string = preg_replace('/vc_col-sm-9/', 'col-md-9', $class_string);
    $class_string = preg_replace('/vc_col-sm-10/', 'col-md-10', $class_string);
    $class_string = preg_replace('/vc_col-sm-11/', 'col-md-11', $class_string);
    $class_string = preg_replace('/vc_col-sm-1/', 'col-md-1', $class_string);
    $class_string = preg_replace('/vc_col-sm-2/', 'col-md-2', $class_string);
    }
    return $class_string;
}
// Filter to Replace default css class for vc_row shortcode and vc_column
add_filter('vc_shortcodes_css_class', 'avaxy_custom_css_classes_for_vc_row_and_vc_column', 10, 2); 
// Add new Param in Row
if(function_exists('vc_add_param')){

vc_add_param('vc_row',array(
                              "type" => "textfield",
                              "heading" => esc_html__('Section Title', 'avaxy'),
                              "param_name" => "ses_title",
                              "value" => "",
                              "description" => esc_html__("Title of Section, Leave a blank do not show frontend.", "avaxy"),   
    )); 

vc_add_param('vc_row',array(
                             'type' => 'dropdown',
                             'heading' => esc_html__( 'Chosen type row', 'avaxy' ),
                             'param_name' => 'type_row',
                             'value' => array(
                                esc_html__( 'None Section', 'avaxy' ) => 'type2',
                                esc_html__( 'Wellcome', 'avaxy' ) => 'wellcome',
                                esc_html__( 'Grey without title', 'avaxy' ) => 'grey_nonetitle',
                                esc_html__( 'Grey', 'avaxy' ) => 'grey_row',
                                esc_html__( 'Light', 'avaxy' ) => 'light_row',
                               esc_html__( 'Background Images', 'avaxy' ) => 'bg_image',
                               esc_html__( 'Parallax Images', 'avaxy' ) => 'parallax',
                                esc_html__( 'Parallax 2 Images', 'avaxy' ) => 'parallax2',
                               esc_html__( 'Text top', 'avaxy' ) => 'row_top',
                               esc_html__( 'Slider', 'avaxy' ) => 'slider',
                               esc_html__( 'Testimonials Slider2', 'avaxy' ) => 'testimonials_slider',
                               esc_html__( 'Faq 1', 'avaxy' ) => 'faq1',
                             ),
                             'description' => esc_html__( 'Select type row', 'avaxy' )
      )); 
vc_add_param('vc_row',array(
                              "type" => "textarea",
                              "heading" => esc_html__('Section Desc', 'avaxy'),
                              "param_name" => "ses_desc",
                              "value" => "",
                              "description" => esc_html__("Section Desc, Leave a blank do not show frontend.", "avaxy"),   
    ));
vc_add_param('vc_row',array(
                              "type" => "textarea_html",
                              "heading" => esc_html__('Section Sub Title', 'avaxy'),
                              "param_name" => "ses_sub_title",
                              "value" => "",
                              "description" => esc_html__("Section Sub Title, Leave a blank do not show frontend.", "avaxy"),   
    ));
vc_add_param('vc_row',array(
                             'type' => 'attach_image',
                             'heading' => esc_html__( 'Image Background', 'avaxy' ),
                             'param_name' => 'ses_image',
                             'value' => '',
                             'description' => esc_html__( 'Select image from media library to do your signature.', 'avaxy' )
      )); 
vc_add_param('vc_row',array(
                              "type" => "textfield",
                              "heading" => esc_html__('ID Section', 'avaxy'),
                              "param_name" => "ses_id",
                              "value" => "",
                              "description" => esc_html__("ID of Section, Leave a blank do not show frontend.", "avaxy"),   
    )); 



// Add new Param in Column  

vc_add_param('vc_column',array(
                             'type' => 'dropdown',
                             'heading' => esc_html__( 'Type', 'avaxy' ),
                             'param_name' => 'type',
                             'value' => array(
                                esc_html__( 'None', 'avaxy' ) => 'none',
                                esc_html__( 'Column', 'avaxy' ) => 'column',

                             ),
                             'description' => esc_html__( 'Select type section content', 'avaxy' )
      )); 
vc_add_param('vc_column',array(
                              "type" => "textfield",
                              "heading" => esc_html__('Column title', 'avaxy'),
                              "param_name" => "column_title",
                              "value" => "",
                              "description" => esc_html__("Column title", "avaxy"),   
    ));  
}




/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1
 * @author     Thomas Griffin <thomasgriffinmedia.com>
 * @author     Gary Jones <gamajo.com>
 * @copyright  Copyright (c) 2014, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
 */
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/framework/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'avaxy_theme_register_required_plugins' );
/**
 * Register the required plugins for this theme.
 *
 * In this example, we register two plugins - one included with the TGMPA library
 * and one from the .org repo.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
 
 
function avaxy_theme_register_required_plugins() {
    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
             // This is an example of how to include a plugin from a private repo in your theme.
        array(
            'name'               => esc_html__( 'WPBakery Visual Composer', 'avaxy' ), // The plugin name.
            'slug'               => 'js_composer', // The plugin slug (typically the folder name).
            'source'             => get_template_directory_uri() . '/framework/plugins/js_composer.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
        ),    
        // This is an example of how to include a plugin from the WordPress Plugin Repository.
        array(
            'name'               => esc_html__( 'Revolution Slider', 'avaxy' ), // The plugin name.
            'slug'               => 'revslider', // The plugin slug (typically the folder name).
            'source'             => get_template_directory_uri() . '/framework/plugins/revslider.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
        ),  
        
        // This is an example of how to include a plugin from the WordPress Plugin Repository.
        array(
            'name'      => esc_html__( 'Contact Form 7', 'avaxy' ),
            'slug'      => 'contact-form-7',
            'required'  => true,
        ), 
        array(
            'name'      => esc_html__( 'One Click Demo Import', 'avaxy' ),
            'slug'      => 'one-click-demo-import',
            'required'  => true,
        ), 
        array(
            'name'      => esc_html__( 'Classic Editor', 'avaxy' ),
            'slug'      => 'classic-editor',
            'required'  => true,
        ), 
        array(
            'name'      => esc_html__( 'Classic Widgets', 'avaxy' ),
            'slug'      => 'classic-widgets',
            'required'  => true,
        ),
        array(
            'name'      => esc_html__( 'Widget Importer & Exporter', 'avaxy' ),
            'slug'      => 'widget-importer-&-exporter',
            'required'  => true,
        ), 
        array(
            'name'      => esc_html__( 'WP Maximum Execution Time Exceeded', 'avaxy' ),
            'slug'      => 'wp-maximum-execution-time-exceeded',
            'required'  => true,
        ), 
        array(
            'name'                     => esc_html__( 'Avaxy Common', 'avaxy' ),
            'slug'                     => 'avaxy-common',
            'required'                 => true,
            'source'                   => get_template_directory_uri() . '/framework/plugins/avaxy-common.zip',
        )
    );
    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'      => array(
            'page_title'                      => esc_html__( 'Install Required Plugins', 'avaxy' ),
            'menu_title'                      => esc_html__( 'Install Plugins', 'avaxy' ),
            'installing'                      => esc_html__( 'Installing Plugin: %s', 'avaxy' ), // %s = plugin name.
            'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'avaxy' ),
            'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'avaxy' ), // %1$s = plugin name(s).
            'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'avaxy' ), // %1$s = plugin name(s).
            'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'avaxy' ), // %1$s = plugin name(s).
            'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'avaxy' ), // %1$s = plugin name(s).
            'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'avaxy' ), // %1$s = plugin name(s).
            'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'avaxy' ), // %1$s = plugin name(s).
            'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'avaxy' ), // %1$s = plugin name(s).
            'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'avaxy' ), // %1$s = plugin name(s).
            'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'avaxy' ),
            'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins', 'avaxy' ),
            'return'                          => esc_html__( 'Return to Required Plugins Installer', 'avaxy' ),
            'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'avaxy' ),
            'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'avaxy' ), // %s = dashboard link.
            'nag_type'                        => 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
        )
    );
    tgmpa( $plugins, $config );
}
?>