<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
    <?php 
    $avaxy_redux_demo = get_option('redux_demo'); ?>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {
        ?>
        <link rel="shortcut icon" href="<?php $avaxy_redux_demo = get_option('redux_demo'); if(isset($avaxy_redux_demo['favicon']['url'])){?><?php echo esc_url($avaxy_redux_demo['favicon']['url']); ?><?php }?>" />
        <?php }?>
        <?php wp_head();?>
    </head>
    <?php  $sidebar = get_post_meta(get_the_ID(),'_cmb_sidebar_page', true); ?>
    <?php  $columns = get_post_meta(get_the_ID(),'_cmb_columns_page', true); ?>
    <body class="background-image-slider">
        <div id="to-top">
            <a href="#" ><i class="fa fa-angle-up"></i></a>
        </div>
        <div id="main-wrapper">
            <header class="header top-header-dark header-menu-light submenu-light">
                <div class="top-header">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="left-wrapper">
                                    <div class="content-info">
                                        <span><?php if(isset($avaxy_redux_demo['header_phone'])){?>
                                                <?php echo esc_attr($avaxy_redux_demo['header_phone']); ?>
                                                <?php }else{?>
                                                <?php echo esc_html__( 'Phone :', 'avaxy' );
                                                }
                                                ?></span>
                                        <span>
                                            <a href="tel:<?php if(isset($avaxy_redux_demo['header_number'])){?>
                                                <?php echo esc_attr($avaxy_redux_demo['header_number']); ?>
                                                <?php }else{?>
                                                <?php echo esc_html__( '+1 (123) 456-7890', 'avaxy' );
                                                }
                                                ?>" ><?php if(isset($avaxy_redux_demo['header_number'])){?>
                                                <?php echo esc_attr($avaxy_redux_demo['header_number']); ?>
                                                <?php }else{?>
                                                <?php echo esc_html__( '+1 (123) 456-7890', 'avaxy' );
                                                }
                                                ?></a>
                                        </span>
                                    </div>
                                    <div class="content-info">
                                        <span><?php if(isset($avaxy_redux_demo['header_mail'])){?>
                                                <?php echo esc_attr($avaxy_redux_demo['header_mail']); ?>
                                                <?php }else{?>
                                                <?php echo esc_html__( 'Email :', 'avaxy' );
                                                }
                                                ?></span>
                                        <span>
                                            <a href="mailto:<?php if(isset($avaxy_redux_demo['header_your_mail'])){?>
                                                <?php echo esc_attr($avaxy_redux_demo['header_your_mail']); ?>
                                                <?php }else{?>
                                                <?php echo esc_html__( 'Support@Example.com', 'avaxy' );
                                                }
                                                ?>" ><?php if(isset($avaxy_redux_demo['header_your_mail'])){?>
                                                <?php echo esc_attr($avaxy_redux_demo['header_your_mail']); ?>
                                                <?php }else{?>
                                                <?php echo esc_html__( 'Support@Example.com', 'avaxy' );
                                                }
                                                ?></a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="right-wrapper">
                                    <div class="content-info">
                                        <div class="social-icons double-icons">
                                            <ul>
                                                <li>
                                                    <a href="<?php echo esc_attr($avaxy_redux_demo['header_link_facebook']);?>"><i class="fa fa-facebook"></i></a>
                                                </li>
                                                <li>
                                                    <a href="<?php echo esc_attr($avaxy_redux_demo['header_link_twitter']);?>"><i class="fa fa-twitter"></i></a>
                                                </li>
                                                <li>
                                                    <a href="<?php echo esc_attr($avaxy_redux_demo['header_link_google']);?>"><i class="fa fa-google-plus"></i></a>
                                                </li>
                                                <li>
                                                    <a href="<?php echo esc_attr($avaxy_redux_demo['header_link_youtube']);?>"><i class="fa fa-youtube-play"></i></a>
                                                </li>
                                                <li>
                                                    <a href="<?php echo esc_attr($avaxy_redux_demo['header_link_behance']);?>"><i class="fa fa-behance"></i></a>
                                                </li>
                                                <li>
                                                    <a href="<?php echo esc_attr($avaxy_redux_demo['header_link_pinterest']);?>"><i class="fa fa-pinterest"></i></a>
                                                </li>
                                                <li>
                                                    <a href="<?php echo esc_attr($avaxy_redux_demo['header_link_dribbble']);?>"><i class="fa fa-dribbble"></i></a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div><!-- /row -->
                    </div>
                </div>
                <div class="header-menu-wrapper">
                    <div class="header-menu">
                        <nav class="navbar" role="navigation">
                            <div class="container">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="navbar-header">
                                            <a href="<?php echo esc_url(home_url('/')); ?>" class="navbar-brand" >
                                            <?php $avaxy_redux_demo = get_option('redux_demo'); if(isset($avaxy_redux_demo['logo']['url'])){?>
                                            <?php  if($avaxy_redux_demo['logo']['url'] != ''){ ?><img alt="<?php bloginfo( 'name' ); ?>" src="<?php echo esc_url($avaxy_redux_demo['logo']['url']); ?>" /><?php }else{ ?>
                                            <img src="<?php echo esc_url(get_template_directory_uri());?>/images/logo.png" alt="<?php bloginfo( 'name' ); ?>">
                                
                                            <?php }}?>
                                        </a>
                                            <span class="site-slogan"><?php if(isset($avaxy_redux_demo['header_slogan'])){?>
                                                <?php echo esc_attr($avaxy_redux_demo['header_slogan']); ?>
                                                <?php }else{?>
                                                <?php echo esc_html__( 'Multipurpose HTML5 Template', 'avaxy' );
                                                }
                                                ?></span>

                                        </div>
                                        <div class="menu-buttons">
                                            <ul>
                                                <li>
                                                    <a href="#"  class="btn-icon btn-search">
                                                        <i class="fa fa-search"></i>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="#"  class="btn-icon btn-cart">
                                                        <i class="fa fa-shopping-cart"></i>
                                                        <span class="badge">3</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target=".navbar-collapse">
                                            <?php echo esc_attr($avaxy_redux_demo['header_menu_text']);?><i class="fa fa-bars"></i>
                                        </button>
                                        <div class="collapse navbar-collapse">
                                            <?php 
                                              wp_nav_menu( 
                                              array( 
                                                    'theme_location' => 'primary',
                                                    'container' => '',
                                                    'menu_class' => '', 
                                                    'menu_id' => '',
                                                    'menu'            => '',
                                                    'container_class' => '',
                                                    'container_id'    => '',
                                                    'echo'            => true,
                                                     'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                                                     'walker'            => new wp_bootstrap_navwalker(),
                                                    'before'          => '',
                                                    'after'           => '',
                                                    'link_before'     => '',
                                                    'link_after'      => '',
                                                    'items_wrap'      => '<ul class="nav navbar-nav navbar-right  %2$s">%3$s</ul>',
                                                    'depth'           => 0,        
                                                )
                                             ); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </nav>
                    </div>
                </div>
                <div class="menu-search-form">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12">
                                <form  method="get" class="search-form" action="#" novalidate="">
                                    <div class="input-group">
                                        <input type="search" class="form-control" placeholder="<?php echo esc_attr($avaxy_redux_demo['header_search']);?>" value="" name="Search">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </header>