<?php 
/*
 * Template Name: FAQ Page
 * Description: A Page Template with a Page Builder design.
 */

   $avaxy_redux_demo = get_option('redux_demo');
   
   get_header();?>  

   <!-- =========================================
            Breadcrumb Section
            ========================================== -->
            <!-- breadcrumb-section -->
            <?php if(isset($avaxy_redux_demo['faq_image']['url']) && $avaxy_redux_demo['faq_image']['url'] != ''){?>
            <div class="breadcrumb-section breadcrumb-style-3" style="background-image: url('<?php echo esc_url($avaxy_redux_demo['faq_image']['url']);?>');">
            <?php }else{?>
            <div class="breadcrumb-section breadcrumb-style-3">
            <?php }?> 

                <!-- main-section -->
                <div class="main-section">
                    <!-- section-container -->
                    <div class="section-container">


                        <!-- container -->
                        <div class="container">
                            <!-- row -->
                            <div class="row">


                                <!-- col-md-12 -->
                                <div class="col-md-12">


                                    <!-- breadcrumb-head -->
                                    <div class="breadcrumb-head">

                                        <!-- breadcrumb-sub-title -->
                                        <div class="breadcrumb-sub-title">
                                            <h5><?php if(isset($avaxy_redux_demo['faq_text_top'])){?>
                                                                        <?php echo esc_attr($avaxy_redux_demo['faq_text_top']); ?>
                                                                        <?php }else{?>
                                                                        <?php echo esc_html__( 'Rules', 'avaxy' );
                                                                        }
                                                                        ?></h5>
                                        </div><!-- /breadcrumb-sub-title -->

                                        <!-- breadcrumb-title -->
                                        <div class="breadcrumb-title">
                                            <h1><?php if(isset($avaxy_redux_demo['faq_title'])){?>
                                                                        <?php echo esc_attr($avaxy_redux_demo['faq_title']); ?>
                                                                        <?php }else{?>
                                                                        <?php echo esc_html__( 'FAQ', 'avaxy' );
                                                                        }
                                                                        ?></h1>
                                        </div><!-- /breadcrumb-title -->

                                    </div><!-- /breadcrumb-head -->


                                    <!-- breadcrumb -->
                                    <ol class="breadcrumb">
                                        <li><a href="<?php echo esc_url(home_url('/')); ?>" title="Home"><?php echo esc_html__( 'Home', 'avaxy' ); ?></a></li>
                                        <li class="active"><?php if(isset($avaxy_redux_demo['faq_title'])){?>
                                                                        <?php echo esc_attr($avaxy_redux_demo['faq_title']); ?>
                                                                        <?php }else{?>
                                                                        <?php echo esc_html__( 'FAQ', 'avaxy' );
                                                                        }
                                                                        ?></li>
                                    </ol><!-- /breadcrumb -->


                                </div><!-- /col-md-12 -->


                            </div><!-- /row -->
                        </div><!-- /container -->


                    </div><!-- /section-container -->
                </div><!-- /main-section -->

            </div><!-- /breadcrumb-section -->




            <!-- =========================================
            Light Section
            ========================================== -->
            <!-- light-section -->
            <div class="light-section">

                <!-- main-section -->
                <div class="main-section">
                    <!-- section-container -->
                    <div class="section-container">


                        <!-- container -->
                        <div class="container">
                            <!-- row -->
                            <div class="row">
                            <div class="col-md-9 main-content">


                                    <!-- row -->
                                    <div class="row">
                                        <!-- col-md-12 -->
                                        



                              

                                            <?php if (have_posts()){ ?>
                    
                        <?php while (have_posts()) : the_post()?>
                            <?php the_content(); ?>
                        <?php endwhile; ?>
                    
                    <?php }else {
                        echo 'Page Canvas For Page Builder'; 
                    }?>
                                        
                                    </div>
                                </div>


                                <!-- col-md-3 sidebar -->
                                <div class="col-md-3 sidebar">


                                     <?php get_sidebar('other');?>


                                </div><!-- /col-md-3 sidebar -->



                            </div><!-- /row -->
                        </div><!-- /container -->


                    </div><!-- /section-container -->
                </div><!-- /main-section -->

            </div><!-- /light-section -->

   <?php get_footer('portfolio');?>  
