<?php 
/*
 * Template Name: Portfolio Page
 * Description: A Page Template with a Page Builder design.
 */
   $avaxy_redux_demo = get_option('redux_demo');
   
   get_header('portfolio');?>  
            <?php if(isset($avaxy_redux_demo['portfolio_image']['url']) && $avaxy_redux_demo['portfolio_image']['url'] != ''){?>
            <div class="breadcrumb-section breadcrumb-style-3" style="background-image: url('<?php echo esc_url($avaxy_redux_demo['portfolio_image']['url']);?>');">
            <?php }else{?>
            <div class="breadcrumb-section breadcrumb-style-3">
            <?php }?> 

                <!-- main-section -->
                <div class="main-section">
                    <!-- section-container -->
                    <div class="section-container">


                        <!-- container -->
                        <div class="container">
                            <!-- row -->
                            <div class="row">


                                <!-- col-md-12 -->
                                <div class="col-md-12">


                                    <!-- breadcrumb-head -->
                                    <div class="breadcrumb-head">

                                        <!-- breadcrumb-sub-title -->
                                        <div class="breadcrumb-sub-title">
                                            <h5><?php if(isset($avaxy_redux_demo['portfolio_text_top'])){?>
                                                                        <?php echo esc_attr($avaxy_redux_demo['portfolio_text_top']); ?>
                                                                        <?php }else{?>
                                                                        <?php echo esc_html__( 'Creatvie', 'avaxy' );
                                                                        }
                                                                        ?></h5>
                                        </div><!-- /breadcrumb-sub-title -->

                                        <!-- breadcrumb-title -->
                                        <div class="breadcrumb-title">
                                            <h1><?php if(isset($avaxy_redux_demo['portfolio_title'])){?>
                                                                        <?php echo esc_attr($avaxy_redux_demo['portfolio_title']); ?>
                                                                        <?php }else{?>
                                                                        <?php echo esc_html__( 'Portfolio', 'avaxy' );
                                                                        }
                                                                        ?></h1>
                                        </div><!-- /breadcrumb-title -->

                                    </div><!-- /breadcrumb-head -->


                                    <!-- breadcrumb -->
                                    <ol class="breadcrumb">
                                        <li><a href="<?php echo esc_url(home_url('/')); ?>" title="Home"><?php echo esc_html__( 'Home', 'avaxy' ); ?></a></li>
                                        <li class="active"><?php if(isset($avaxy_redux_demo['portfolio_title'])){?>
                                                                        <?php echo esc_attr($avaxy_redux_demo['portfolio_title']); ?>
                                                                        <?php }else{?>
                                                                        <?php echo esc_html__( 'Portfolio', 'avaxy' );
                                                                        }
                                                                        ?></li>
                                    </ol><!-- /breadcrumb -->


                                </div><!-- /col-md-12 -->


                            </div><!-- /row -->
                        </div><!-- /container -->


                    </div><!-- /section-container -->
                </div><!-- /main-section -->

            </div><!-- /breadcrumb-section -->




            <!-- =========================================
            Light Section
            ========================================== -->
            <!-- light-section -->
            <div class="light-section">

                <!-- main-section -->
                <div class="main-section">
                    <!-- section-container -->
                    <div class="section-container">


                        <!-- container -->
                        <div class="container">
                            <!-- row -->
                            <div class="row">



                                <!-- col-md-9 main-content -->
                                <div class="col-md-9 main-content">


                                    <!-- row -->
                                    <div class="row">
                                        <!-- col-md-12 -->
                                        <div class="col-md-12">

                                            <!-- spinner-loader -->
                                            <div class="spinner-loader">
                                                <i class="fa fa-spinner fa-pulse"></i>
                                            </div><!-- /spinner-loader -->

                                        </div><!-- /col-md-12 -->
                                    </div><!-- /row -->


                                    <!-- row -->
                                    <div class="row">
                                        <!-- col-md-12 -->
                                        <div class="col-md-12">

                                            <!-- filter-section -->
                                            <div class="filter-section">


                                                <h5><?php if(isset($avaxy_redux_demo['portfolio_filter'])){?>
                                                                        <?php echo esc_attr($avaxy_redux_demo['portfolio_filter']); ?>
                                                                        <?php }else{?>
                                                                        <?php echo esc_html__( 'Filter :', 'avaxy' );
                                                                        }
                                                                        ?></h5>


                                                <!-- select-input -->
                                                <div class="select-input">

                                                    <!-- portfolio-filter-container -->
                                                    <div id="portfolio-filter-container">

                                                        <select>
                                                            <option data-filter="*" selected="selected">
                                                                <?php if(isset($avaxy_redux_demo['all'])){?>
                                                                <?php echo esc_attr($avaxy_redux_demo['all']); ?>
                                                                <?php }else{?>
                                                                <?php echo esc_html__( 'All', 'avaxy' );
                                                                }
                                                                ?></option>
                                                            <?php 
                                                                $categories = get_terms('type');   
                                                                 foreach( (array)$categories as $categorie){
                                                                    $cat_name = $categorie->name;
                                                                    $cat_slug = $categorie->slug;
                                                            ?>
                                                            <option data-filter=".<?php echo esc_attr($cat_slug);?>"><?php echo esc_html($cat_name);?></option>
                                                            <?php } ?>
                                                        </select>

                                                    </div><!-- /portfolio-filter-container -->

                                                </div><!-- /select-input -->


                                            </div><!-- /filter-section -->

                                        </div><!-- /col-md-12 -->
                                    </div><!-- /row -->


                                    <!-- row -->
                                    <div class="row">
                                        <!-- col-md-12 -->
                                        <div class="col-md-12">
                                        <?php  $wide_portfolio = get_post_meta(get_the_ID(),'_cmb_wide_page_portfolio', true); ?>
                                        <?php  $margin_portfolio = get_post_meta(get_the_ID(),'_cmb_margin_page_portfolio', true); ?>
                                        

                                            <!-- portfolio-blocks-wrapper -->
                                            <div class="portfolio-blocks-wrapper ">

                                            <?php 
                                                $args = array(   
                                                            'post_type' => 'portfolio',   
                                                            'paged' => $paged,
                                                        );  
                                                        $wp_query = new WP_Query($args);
                                                        $i = 1;
                                                        while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
                                                        $cates = get_the_terms(get_the_ID(),'type');
                                                        $cate_name ='';
                                                        $cate_slug = '';
                                                              foreach((array)$cates as $cate){
                                                    if(count($cates)>0){
                                                        $cate_name .= $cate->name.' ' ;
                                                        $cate_slug .= $cate->slug .' ';     
                                                        } 
                                                        } 
                                        ?> 


                                                <!-- portfolio-block -->
                                                <article class="portfolio-block <?php echo esc_attr($cate_slug);?>

                                                 ">
                                                    <!-- portfolio-item -->

                                                    <div class="portfolio-item <?php echo esc_attr($wide_portfolio); ?> <?php echo esc_attr($margin_portfolio); ?> ">

                                                    


                                                        <!-- portfolio-item-header -->
                                                        <div class="portfolio-item-header">

                                                        <?php $video_portfolio = get_post_meta(get_the_ID(),'_cmb_link_video_portfolio', true);?>

                                                            <?php if($video_portfolio != ''){?>
                                                            <a href="<?php echo esc_attr($video_portfolio); ?>" title="Preview" class="fancybox">
                                                            <?php }else{ ?>

                                                            <a href="<?php echo wp_get_attachment_url( get_post_thumbnail_id());?>" title="Preview" class="fancybox">
                                                            <?php } ?>
                                                                <img src="<?php echo wp_get_attachment_url( get_post_thumbnail_id());?>" alt="Portfolio Item" />
                                                            </a>
                                                        </div><!-- /portfolio-item-header -->


                                                        <!-- portfolio-item-footer -->
                                                        <div class="portfolio-item-footer">

                                                            <!-- portfolio-item-title -->
                                                            <div class="portfolio-item-title">
                                                                <h4>
                                                                    <a href="<?php the_permalink();?>" title="<?php the_title();?>">
                                                                        <?php the_title();?> 
                                                                    </a>
                                                                </h4>
                                                            </div><!-- /portfolio-item-title -->

                                                            <!-- portfolio-item-cat -->
                                                            <div class="portfolio-item-cat">
                                                                <span><?php echo esc_html($cate_name);?></span>
                                                            </div><!-- /portfolio-item-cat -->

                                                        </div><!-- /portfolio-item-footer -->


                                                    </div><!-- /portfolio-item -->
                                                </article><!-- /portfolio-block -->


                                                <?php $i++;
                                                    endwhile;?>  


                                                


                                            </div><!-- /portfolio-blocks-wrapper -->

                                        </div><!-- /col-md-12 -->
                                    </div><!-- /row -->


                                    <!-- row -->
                                    <div class="row">
                                        <!-- col-md-12 -->
                                        <div class="col-md-12">

                                            <!-- pagination-wrapper -->
                                            <div class="pagination-wrapper">

                                                <nav>
                                                    <?php avaxy_pagination();?>
                                                </nav>

                                            </div><!-- /pagination-wrapper -->

                                        </div><!-- /col-md-12 -->
                                    </div><!-- /row -->


                                </div><!-- /col-md-9 main-content -->
                                <!-- col-md-3 sidebar -->
                                <div class="col-md-3 sidebar">


                                     <?php get_sidebar('portfolio');?>


                                </div><!-- /col-md-3 sidebar -->



                            </div><!-- /row -->
                        </div><!-- /container -->


                    </div><!-- /section-container -->
                </div><!-- /main-section -->

            </div><!-- /light-section -->

   <?php get_footer('portfolio');?>  