<?php 
/*
 * Template Name: Team4 Page
 * Description: A Page Template with a Page Builder design.
 */
   $avaxy_redux_demo = get_option('redux_demo');
   get_header('');?>  
            <?php if(isset($avaxy_redux_demo['team_image']['url']) && $avaxy_redux_demo['team_image']['url'] != ''){?>
            <div class="breadcrumb-section breadcrumb-style-3" style="background-image: url('<?php echo esc_url($avaxy_redux_demo['team_image']['url']);?>');">
            <?php }else{?>
            <div class="breadcrumb-section breadcrumb-style-3">
            <?php }?> 
                <div class="main-section">
                    <div class="section-container">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="breadcrumb-head">
                                        <div class="breadcrumb-sub-title">
                                            <h5><?php if(isset($avaxy_redux_demo['team_text_top'])){?>
                                                                        <?php echo esc_attr($avaxy_redux_demo['team_text_top']); ?>
                                                                        <?php }else{?>
                                                                        <?php echo esc_html__( 'Awesome', 'avaxy' );
                                                                        }
                                                                        ?></h5>
                                        </div>
                                        <div class="breadcrumb-title">
                                            <h1><?php if(isset($avaxy_redux_demo['team_title'])){?>
                                                                        <?php echo esc_attr($avaxy_redux_demo['team_title']); ?>
                                                                        <?php }else{?>
                                                                        <?php echo esc_html__( 'Team', 'avaxy' );
                                                                        }
                                                                        ?></h1>
                                        </div>

                                    </div>
                                    <ol class="breadcrumb">
                                        <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html__( 'Home', 'avaxy' ); ?></a></li>
                                        <li class="active"><?php if(isset($avaxy_redux_demo['team_title'])){?>
                                                                        <?php echo esc_attr($avaxy_redux_demo['team_title']); ?>
                                                                        <?php }else{?>
                                                                        <?php echo esc_html__( 'Team', 'avaxy' );
                                                                        }
                                                                        ?></li>
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="light-section">
                <div class="main-section">
                    <div class="section-container">
                        <div class="container">
                            <div class="row">
                            <?php 
                            $args = array(   
                                        'post_type' => 'team',   
                                        'paged' => $paged,
                                    );  
                                    $wp_query = new WP_Query($args);
                                    $i = 1;
                                    while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
                                    $cates = get_the_terms(get_the_ID(),'title');
                                    $cate_name ='';
                                    $cate_slug = '';
                                          foreach((array)$cates as $cate){
                                if(count($cates)>0){
                                    $cate_name .= $cate->name.' ' ;
                                    $cate_slug .= $cate->slug .' ';     
                                    } 
                                    } 
                                    ?> 
                                <div class="col-md-3 member-block">
                                    <div class="member-item">
                                        <div class="member-header">
                                            <img src="<?php echo wp_get_attachment_url( get_post_thumbnail_id());?>" alt="Member Image" />
                                        </div>
                                        <div class="member-footer">
                                            <div class="member-name">
                                                <h4>
                                                    <a href="<?php the_permalink();?>"><?php the_title(); ?></a>
                                                </h4>
                                            </div>
                                            <div class="member-title">
                                                <p><?php echo esc_html($cate_name);?></p>
                                            </div>
                                            <?php 
                                                
                                                $member_excerpt_des = get_post_meta(get_the_ID(),'_cmb_member_excerpt_des', true); 
                                                $member_face = get_post_meta(get_the_ID(),'_cmb_member_face', true); 
                                                $member_twit = get_post_meta(get_the_ID(),'_cmb_member_twit', true); 
                                                $member_goog = get_post_meta(get_the_ID(),'_cmb_member_goog', true); 
                                                $member_beha = get_post_meta(get_the_ID(),'_cmb_member_beha', true);
                                                ?>
                                            <div class="member-desc">
                                                <p><?php echo esc_html($member_excerpt_des);?></p>
                                            </div>
                                            <div class="member-social">
                                                <div class="social-icons">
                                                    <ul>
                                                        <li>
                                                            <a href="<?php echo esc_attr($member_face);?>" title="Facebook"><i class="<?php if(isset($avaxy_redux_demo['header_icon_facebook'])){?>
                                                                    <?php echo esc_attr($avaxy_redux_demo['header_icon_facebook']); ?>
                                                                    <?php }else{?>
                                                                    <?php echo esc_html__( 'fa fa-facebook', 'avaxy' );
                                                                    }
                                                                    ?>"></i></a>
                                                        </li>
                                                        <li>
                                                            <a href="<?php echo esc_attr($member_twit);?>" title="Twitter"><i class="<?php if(isset($avaxy_redux_demo['header_icon_twitter'])){?>
                                                                    <?php echo esc_attr($avaxy_redux_demo['header_icon_twitter']); ?>
                                                                    <?php }else{?>
                                                                    <?php echo esc_html__( 'fa fa-twitter', 'avaxy' );
                                                                    }
                                                                    ?>"></i></a>
                                                        </li>
                                                        <li>
                                                            <a href="<?php echo esc_attr($member_goog);?>" title="Google Plus"><i class="<?php if(isset($avaxy_redux_demo['header_icon_google'])){?>
                                                                    <?php echo esc_attr($avaxy_redux_demo['header_icon_google']); ?>
                                                                    <?php }else{?>
                                                                    <?php echo esc_html__( 'fa fa-google-plus', 'avaxy' );
                                                                    }
                                                                    ?>"></i></a>
                                                        </li>
                                                        <li>
                                                            <a href="<?php echo esc_attr($member_beha);?>" title="Behance"><i class="<?php if(isset($avaxy_redux_demo['header_icon_behance'])){?>
                                                                    <?php echo esc_attr($avaxy_redux_demo['header_icon_behance']); ?>
                                                                    <?php }else{?>
                                                                    <?php echo esc_html__( 'fa fa-behance', 'avaxy' );
                                                                    }
                                                                    ?>"></i></a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php $i++; endwhile;?> 
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="nesto-cta cta-light">
                                        <div class="cta-desc">
                                            <h5><?php if(isset($avaxy_redux_demo['team_text_contact'])){?>
                                                                        <?php echo esc_attr($avaxy_redux_demo['team_text_contact']); ?>
                                                                        <?php }else{?>
                                                                        <?php echo esc_html__( 'AVAXY IS HTML5 TEMPLATE, WHICH CONTAINS EVERY THING YOU WANT FOR YOUR WEBSITE IN A CREATIVE WAY.', 'avaxy' );
                                                                        }
                                                                        ?></h5>
                                        </div>
                                        <div class="cta-button">
                                            <a href="<?php if(isset($avaxy_redux_demo['link_contact'])){?>
                                                                        <?php echo esc_attr($avaxy_redux_demo['link_contact']); ?>
                                                                        <?php }else{?>
                                                                        <?php echo esc_html__( '#', 'avaxy' );
                                                                        }
                                                                        ?>" title="Contact Us" class="btn btn-nesto">
                                                <?php if(isset($avaxy_redux_demo['team_contact'])){?>
                                                                        <?php echo esc_attr($avaxy_redux_demo['team_contact']); ?>
                                                                        <?php }else{?>
                                                                        <?php echo esc_html__( 'Contact us', 'avaxy' );
                                                                        }
                                                                        ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php if(isset($avaxy_redux_demo['team4_template'])){?>                                            
            <?php echo html_entity_decode($avaxy_redux_demo['team4_template']) ?>
            <?php } ?>
<?php get_footer('portfolio');?>  